/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.jobexecution.client;

import com.sas.svcs.jobexecution.client.ExecutionState;
import com.sas.svcs.jobexecution.client.JobExecutionType;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class JobQueryOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Set<String> _keywords = new HashSet<String>(5);
    private boolean _keywordsORed;
    private JobExecutionType _executionType;
    private ExecutionState _executionState;
    private Date _submittedDate;

    public void setKeywords(Set<String> keywords) {
        this._keywords.clear();
        if (null != keywords) {
            this._keywords.addAll(keywords);
        }
    }

    public void addKeyword(String keyword) {
        if (null != keyword) {
            this._keywords.add(keyword);
        }
    }

    public Set<String> getKeywords() {
        return new HashSet<String>(this._keywords);
    }

    public void setKeywordsORed(boolean keywordsORed) {
        this._keywordsORed = keywordsORed;
    }

    public boolean isKeywordsORed() {
        return this._keywordsORed;
    }

    public void setExecutionType(JobExecutionType executionType) {
        this._executionType = executionType;
    }

    public void setExecutionTypeValue(String executionType) {
        JobExecutionType jobExecutionType = JobExecutionType.fromValue(executionType);
        this.setExecutionType(jobExecutionType);
    }

    public JobExecutionType getExecutionType() {
        return this._executionType;
    }

    public void setExecutionState(ExecutionState executionState) {
        this._executionState = executionState;
    }

    public void setExecutionStateValue(String executionState) {
        ExecutionState jobExecutionState = ExecutionState.fromValue(executionState);
        this.setExecutionState(jobExecutionState);
    }

    public ExecutionState getExecutionState() {
        return this._executionState;
    }

    public Date getSubmittedDate() {
        return this._submittedDate;
    }

    public void setSubmittedDate(Date date) {
        this._submittedDate = date;
    }

    public String toString() {
        int stringLength = 256;
        StringBuilder stringBuilder = new StringBuilder(256).append(super.toString()).append("[executionType=");
        if (null != this._executionType) {
            stringBuilder.append(this._executionType.getType());
        }
        stringBuilder.append("][executionState=");
        if (null != this._executionState) {
            stringBuilder.append(this._executionState.getState());
        }
        stringBuilder.append("][keywordsORed=").append(this._keywordsORed).append("][keywords=");
        if (!this._keywords.isEmpty()) {
            for (String keyword : this._keywords) {
                stringBuilder.append('{').append(keyword).append('}');
            }
        }
        stringBuilder.append("][submittedDate=").append(this._submittedDate).append(']');
        return stringBuilder.toString();
    }
}

