/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection;

import com.sas.codepolicy.SASScope;
import com.sas.iom.orb.DelegateRemote;
import com.sas.services.connection.AuthenticationTicketCredential;
import com.sas.services.connection.Cluster;
import com.sas.services.connection.ClusterEnvelope;
import com.sas.services.connection.ConnectionEnvelope;
import com.sas.services.connection.ConnectionFactoryAdminInterface;
import com.sas.services.connection.ConnectionFactoryEvent;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionFactoryKernel;
import com.sas.services.connection.ConnectionFactoryRequest;
import com.sas.services.connection.ConnectionFactoryUtil;
import com.sas.services.connection.ConnectionImpl;
import com.sas.services.connection.ConnectionImpl2;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.ConnectionRequest;
import com.sas.services.connection.Credential;
import com.sas.services.connection.FatalConnectionFactoryException;
import com.sas.services.connection.RB;
import com.sas.services.connection.SecurityPackageCredential;
import com.sas.services.connection.Server;
import com.sas.services.connection.TrustedPeerCredential;
import com.sas.services.connection.WrongCredentialsException;
import com.sas.text.Message;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.ObjectImpl;

@SASScope
public final class AggregationKernel
extends ConnectionFactoryKernel {
    private List _domains;
    private Map _clusterMap;
    private Set _cxSet;
    private String _securityPackageDomain;
    private boolean _securityPackageAllowed;
    private boolean _trustedPeerAllowed;
    private String _authService;

    public AggregationKernel(ConnectionFactoryRequest cxfReq, Cluster[] clusters) {
        super(cxfReq);
        if (clusters == null || clusters.length == 0) {
            throw new IllegalArgumentException("\"clusters\" cannot be null or empty.");
        }
        this._domains = new ArrayList(clusters.length);
        this._clusterMap = new HashMap(clusters.length, 1.0f);
        for (int i = 0; i < clusters.length; ++i) {
            Cluster cluster = clusters[i];
            if (cluster == null) {
                throw new IllegalArgumentException("Element " + i + " of \"clusters\" cannot be null.");
            }
            String domain = cluster.getDomain();
            if (!this._domains.add(domain)) {
                StringBuffer msgBuffer = new StringBuffer("Each cluster must have a unique domain. The domain for element ");
                msgBuffer.append(i).append(" (").append(domain).append(") has been used by another cluster.");
                throw new IllegalArgumentException(msgBuffer.toString());
            }
            if (cluster.isSecurityPackageAllowed()) {
                if (this._securityPackageDomain != null) {
                    String msg = "No more than one cluster may support a security package.";
                    throw new IllegalArgumentException(msg);
                }
                this._securityPackageDomain = cluster.getDomain();
                this._securityPackageAllowed = true;
            }
            String authService = cluster.getAuthService();
            if (this._authService == null) {
                this._authService = authService;
            } else if (!this._authService.equals(authService)) {
                String msg = "All clusters must use the same authentication service";
                throw new IllegalArgumentException(msg);
            }
            ClusterEnvelope clEnv = new ClusterEnvelope(this, cluster);
            this._clusterMap.put(domain, clEnv);
        }
        this._trustedPeerAllowed = clusters.length == 1 && AggregationKernel.isMetadataServer(clusters);
        this._cxSet = new HashSet();
        if (cxfReq.isLoggableFINE()) {
            String configStr = ConnectionFactoryUtil.clusterArrayToString(clusters);
            cxfReq.logFINE("resolved configuration: " + configStr);
        }
    }

    @Override
    public synchronized void destroy() {
        if (this.isDestroyed()) {
            return;
        }
        ConnectionFactoryRequest cxfReq = this.getRequest();
        if (cxfReq.isLoggableFINE()) {
            cxfReq.logFINE("connection factory destroyed");
        }
        Iterator cxIterator = this._cxSet.iterator();
        while (cxIterator.hasNext()) {
            WeakReference ref = (WeakReference)cxIterator.next();
            cxIterator.remove();
            ConnectionEnvelope cxEnv = (ConnectionEnvelope)ref.get();
            if (cxEnv == null) continue;
            this.destroyConnection(cxEnv, "destroy");
        }
        this.destroyKernel();
    }

    @Override
    protected boolean isSecurityPackageAllowed() {
        return this._securityPackageAllowed;
    }

    @Override
    protected boolean isTrustedPeerAllowed() {
        return this._trustedPeerAllowed;
    }

    @Override
    protected String getAuthService() {
        return this._authService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ConnectionInterface doGetConnection(ConnectionRequest cxReq) throws ConnectionFactoryException {
        Credential cred = cxReq.getCredential();
        String domain = null;
        domain = cred instanceof TrustedPeerCredential || cred instanceof AuthenticationTicketCredential ? (String)this._domains.get(0) : (cred instanceof SecurityPackageCredential ? this._securityPackageDomain : cred.getDomain());
        ClusterEnvelope clEnv = null;
        AggregationKernel aggregationKernel = this;
        synchronized (aggregationKernel) {
            if (this.isShutdown() || this.isDestroyed()) {
                throw new IllegalStateException("\"getConnection()\" cannot be called on a factory after \"shutdown()\" or \"destroy()\" has been called.");
            }
            clEnv = (ClusterEnvelope)this._clusterMap.get(domain);
            if (clEnv == null) {
                String messageIndex = "cxf.000.ex.fmt";
                String messagePattern = RB.getStringResource(messageIndex);
                String message = Message.format((String)messagePattern, (Object)messageIndex, (Object)domain);
                throw new WrongCredentialsException(message, cred, this._domains);
            }
        }
        ConnectionEnvelope cxEnv = clEnv.getConnection(cxReq);
        if (cxEnv.isBogus()) {
            Throwable thr = cxEnv.getCause();
            if (thr instanceof FatalConnectionFactoryException) {
                FatalConnectionFactoryException ex = (FatalConnectionFactoryException)thr;
                ConnectionFactoryEvent event = null;
                event = new ConnectionFactoryEvent(2, ex);
                this.shutdownKernel(event);
                throw ex;
            }
            if (thr instanceof RuntimeException) {
                throw (RuntimeException)thr;
            }
            if (thr instanceof Error) {
                throw (Error)thr;
            }
            ConnectionFactoryException cfe = null;
            cfe = thr instanceof ConnectionFactoryException ? (ConnectionFactoryException)thr : new ConnectionFactoryException(thr);
            throw cfe;
        }
        AggregationKernel thr = this;
        synchronized (thr) {
            if (this.isDestroyed()) {
                this.destroyConnection(cxEnv, "destroy");
                throw new IllegalStateException("\"getConnection()\" cannot be called on a factory after \"shutdown()\" or \"destroy()\" has been called.");
            }
            this._cxSet.add(new WeakReference<ConnectionEnvelope>(cxEnv));
        }
        ConnectionImpl cx = null;
        ObjectImpl obj = (ObjectImpl)cxEnv.getRootObject();
        Delegate delegate = obj._get_delegate();
        DelegateRemote delegateRemote = null;
        try {
            delegateRemote = (DelegateRemote)delegate;
            String normUserName = delegateRemote.getNormUserName();
            String normDomain = delegateRemote.getNormDomain();
            cx = new ConnectionImpl2(cxEnv, this, 0, normUserName, normDomain);
        }
        catch (ClassCastException classCastException) {
        }
        catch (NO_IMPLEMENT nO_IMPLEMENT) {
            // empty catch block
        }
        if (cx == null) {
            cx = new ConnectionImpl(cxEnv, this, 0);
        }
        if (delegateRemote != null) {
            delegateRemote.addReference(cx);
        }
        return cx;
    }

    @Override
    protected ConnectionFactoryAdminInterface getAdminInterface(Credential adminLogin) throws ConnectionFactoryException {
        return this;
    }

    @Override
    protected List getDomains() {
        return ConnectionFactoryUtil.copyList(this._domains);
    }

    @Override
    protected synchronized void reactivateConnection(ConnectionEnvelope cxEnv, int clientNumber, int reason) {
        if (this.isDestroyed()) {
            return;
        }
        String whom = null;
        String cause = null;
        if (reason == 0) {
            whom = "(user)";
            cause = "return";
        } else {
            whom = "(garbage collector)";
            cause = "garbage_collection";
        }
        String connectionID = cxEnv.getConnectionID();
        ConnectionRequest cxReq = cxEnv.getConnectionRequest();
        if (cxReq.isLoggableFINE()) {
            cxReq.logFINE("connection returned: " + connectionID + whom);
        }
        if (cxReq.isTraceable()) {
            String msg = "traceback for connection returned " + connectionID;
            Throwable tb = new Throwable("This traceback is for information only. It is not an error.");
            cxReq.trace(msg, tb);
        }
        if (reason == 1 && cxReq.isLoggableWARNING()) {
            cxReq.logWARNING("A connection was returned to the factory by the garbage collector " + connectionID);
        }
        Iterator cxIterator = this._cxSet.iterator();
        while (cxIterator.hasNext()) {
            WeakReference ref = (WeakReference)cxIterator.next();
            if (!cxEnv.equals(ref.get())) continue;
            cxIterator.remove();
            break;
        }
        this.destroyConnection(cxEnv, cause);
        if (this.isShutdown() && this._cxSet.isEmpty()) {
            this.destroy();
        }
    }

    private void destroyConnection(ConnectionEnvelope cxEnv, String cause) {
        ObjectImpl obj = (ObjectImpl)cxEnv.getRootObject();
        try {
            obj._orb().shutdown(true);
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        ConnectionFactoryRequest cxfReq = this.getRequest();
        if (cxfReq.isLoggableFINE()) {
            String connectionID = cxEnv.getConnectionID();
            cxfReq.logFINE("connection destroyed: " + connectionID);
        }
    }

    @Override
    protected void shutdownKernel(ConnectionFactoryEvent event) {
        ConnectionFactoryRequest cxfReq = this.getRequest();
        if (cxfReq.isLoggableFINE()) {
            if (event.getType() == 0) {
                cxfReq.logFINE("connection factory shutdown");
            } else {
                cxfReq.logFINE("connection factory shutdown (fatal error detected)");
            }
        }
        super.shutdownKernel(event);
        if (this._cxSet.isEmpty()) {
            this.destroy();
        }
    }

    private static boolean isMetadataServer(Cluster[] clusterArr) {
        for (int i = 0; i < clusterArr.length; ++i) {
            Cluster cluster = clusterArr[i];
            String classID = cluster.getClassID();
            if (Server.isMetadataServerClassID(classID)) continue;
            return false;
        }
        return true;
    }
}

