/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rio;

import com.sas.codepolicy.SASScope;
import com.sas.rio.MVASQLException;
import com.sas.rio.MessageCode;
import com.sas.rio.MissingValue;
import java.sql.SQLException;

@SASScope
public class Matrix {
    private double[][] numericValuesForInsert = null;
    private String[][] characterValuesForInsert = null;
    private byte[][] missingNumericValuesForInsert = null;
    private int m_row = 0;
    private int m_columnCount = 0;
    private int[] m_columnTypes = null;
    private int m_numRows = 0;
    private int[] typesMap = null;
    private static final String emptyString = "";

    public Matrix(int numRows, int[] types) throws SQLException {
        int charLength = 0;
        int numLength = 0;
        this.m_columnCount = types.length;
        this.m_columnTypes = types;
        this.m_numRows = numRows;
        this.typesMap = new int[this.m_columnCount];
        block4: for (int i = 0; i < this.m_columnCount; ++i) {
            switch (types[i]) {
                case 12: {
                    this.typesMap[i] = charLength++;
                    continue block4;
                }
                case 8: 
                case 91: 
                case 92: 
                case 93: {
                    this.typesMap[i] = numLength++;
                    continue block4;
                }
                default: {
                    throw new MVASQLException(MessageCode.Matrix_typeError, types[i]);
                }
            }
        }
        this.numericValuesForInsert = new double[numRows][numLength];
        this.characterValuesForInsert = new String[numRows][charLength];
        this.missingNumericValuesForInsert = new byte[numRows][numLength];
    }

    public synchronized void moveToBufferRow(int row) throws SQLException {
        if (row < 1 || row > this.m_numRows) {
            throw new MVASQLException(MessageCode.Matrix_rowError, row);
        }
        this.m_row = row - 1;
    }

    public synchronized void updateString(int columnIndex, String x) throws SQLException {
        this.validateColumnIndex(columnIndex);
        int rioIndex = this.typesMap[--columnIndex];
        switch (this.m_columnTypes[columnIndex]) {
            case 12: {
                if (x == null) {
                    this.characterValuesForInsert[this.m_row][rioIndex] = emptyString;
                    break;
                }
                this.characterValuesForInsert[this.m_row][rioIndex] = x;
                break;
            }
            case 8: 
            case 91: 
            case 92: 
            case 93: {
                this.updateDouble(columnIndex + 1, Double.valueOf(x.trim()));
                break;
            }
        }
    }

    public synchronized void updateDouble(int columnIndex, double x) throws SQLException {
        this.validateColumnIndex(columnIndex);
        int rioIndex = this.typesMap[--columnIndex];
        switch (this.m_columnTypes[columnIndex]) {
            case 8: 
            case 91: 
            case 92: 
            case 93: {
                this.numericValuesForInsert[this.m_row][rioIndex] = x;
                if (Double.isNaN(x)) {
                    this.missingNumericValuesForInsert[this.m_row][rioIndex] = 32;
                    break;
                }
                this.missingNumericValuesForInsert[this.m_row][rioIndex] = 127;
                break;
            }
            case 12: {
                String s = Double.toString(x);
                this.updateString(columnIndex + 1, s);
                break;
            }
        }
    }

    public synchronized void updateNull(int columnIndex) throws SQLException {
        this.validateColumnIndex(columnIndex);
        switch (this.m_columnTypes[--columnIndex]) {
            case 8: 
            case 91: 
            case 92: 
            case 93: {
                this.updateDouble(columnIndex + 1, Double.NaN);
                break;
            }
            case 12: {
                this.updateString(columnIndex + 1, null);
                break;
            }
        }
    }

    public synchronized void updateNull(int columnIndex, String x) throws SQLException {
        this.validateColumnIndex(columnIndex);
        int rioIndex = this.typesMap[--columnIndex];
        switch (this.m_columnTypes[columnIndex]) {
            case 8: 
            case 91: 
            case 92: 
            case 93: {
                this.numericValuesForInsert[this.m_row][rioIndex] = Double.NaN;
                this.missingNumericValuesForInsert[this.m_row][rioIndex] = MissingValue.getNumericValue(x);
                break;
            }
            case 12: {
                this.updateNull(columnIndex + 1);
                break;
            }
        }
    }

    public synchronized void updateFloat(int columnIndex, float x) throws SQLException {
        this.validateColumnIndex(columnIndex);
        int arrayIndex = columnIndex - 1;
        switch (this.m_columnTypes[arrayIndex]) {
            case 8: {
                this.updateDouble(columnIndex, x);
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                throw new MVASQLException(MessageCode.MVAResultSet_cannotConvertToFloat, new Object[0]);
            }
            case 12: {
                String s = Float.toString(x);
                this.updateString(columnIndex, s);
                break;
            }
        }
    }

    public synchronized void updateInt(int columnIndex, int x) throws SQLException {
        this.validateColumnIndex(columnIndex);
        int arrayIndex = columnIndex - 1;
        switch (this.m_columnTypes[arrayIndex]) {
            case 8: {
                this.updateDouble(columnIndex, x);
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                throw new MVASQLException(MessageCode.MVAResultSet_cannotConvertToInt, new Object[0]);
            }
            case 12: {
                String s = Integer.toString(x);
                this.updateString(columnIndex, s);
                break;
            }
        }
    }

    public synchronized void updateShort(int columnIndex, short x) throws SQLException {
        this.validateColumnIndex(columnIndex);
        int arrayIndex = columnIndex - 1;
        switch (this.m_columnTypes[arrayIndex]) {
            case 8: {
                this.updateDouble(columnIndex, x);
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                throw new MVASQLException(MessageCode.MVAResultSet_cannotConvertToShort, new Object[0]);
            }
            case 12: {
                String s = Short.toString(x);
                this.updateString(columnIndex, s);
                break;
            }
        }
    }

    public synchronized void updateLong(int columnIndex, long x) throws SQLException {
        this.validateColumnIndex(columnIndex);
        int arrayIndex = columnIndex - 1;
        switch (this.m_columnTypes[arrayIndex]) {
            case 8: {
                this.updateDouble(columnIndex, x);
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                throw new MVASQLException(MessageCode.MVAResultSet_cannotConvertToLong, new Object[0]);
            }
            case 12: {
                String s = Long.toString(x);
                this.updateString(columnIndex, s);
                break;
            }
        }
    }

    public void validateColumnIndex(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.m_columnCount) {
            throw new MVASQLException(MessageCode.Matrix_colError, columnIndex);
        }
    }

    public int getColumnCount() {
        return this.m_columnCount;
    }

    public double[][] getNumericValuesForInsert() {
        return this.numericValuesForInsert;
    }

    public byte[][] getMissingNumericValuesForInsert() {
        return this.missingNumericValuesForInsert;
    }

    public String[][] getCharacterValuesForInsert() {
        return this.characterValuesForInsert;
    }
}

