/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rio;

import com.sas.codepolicy.SASScope;
import java.util.ArrayList;
import java.util.Collection;

@SASScope
final class Cache<E>
extends ArrayList<E> {
    private static final long serialVersionUID = 42L;
    private int _maxSize = 0;

    public Cache(int maxSize) {
        super(maxSize);
        this._maxSize = maxSize;
    }

    public Cache(Collection<? extends E> c) {
        super(c);
        this._maxSize = c.size();
    }

    @Override
    public boolean add(E element) {
        int _size = this.size();
        if (_size < this._maxSize) {
            super.add(element);
        } else if (_size == this._maxSize) {
            super.remove(0);
            super.add(element);
        }
        return true;
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        assert (minCapacity > 0);
        if (minCapacity > this._maxSize) {
            super.ensureCapacity(minCapacity);
            this._maxSize = minCapacity;
        }
    }

    public void setSize(int newSize) {
        assert (newSize > 0);
        if (newSize > this._maxSize) {
            super.ensureCapacity(newSize);
            this._maxSize = newSize;
        } else if (newSize < this._maxSize && newSize < super.size()) {
            while (super.size() > newSize) {
                super.remove(0);
            }
            this._maxSize = newSize;
            super.trimToSize();
        }
    }
}

