/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom.orb.brg;

import com.sas.codepolicy.SASScope;
import com.sas.iom.orb.brg.RB;
import com.sas.security.sspi.SSPIAuth;
import com.sas.security.sspi.SSPIAuthException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.UNKNOWN;

@SASScope
public class SecurityPackageBase {
    private Locale _locale;
    private byte _continuationFlag;
    private SSPIAuth _sspiAuth;
    private byte[] _contextBuf;
    private byte[] _curContext;
    private static final String JGSSAuth_Class = "com.sas.security.jgss.JGSSAuth";
    private static final String JGSSAuth_Method_hasClientContext = "hasClientContext";

    protected SecurityPackageBase() {
    }

    protected synchronized void initClient(String securityPackage, String securityPackageLst, String spn, String host, int port) {
        if (this._sspiAuth != null) {
            throw new IllegalStateException();
        }
        if (spn == null) {
            spn = SSPIAuth.createServicePrincipalNameForHost((String)host);
        }
        this._sspiAuth = SecurityPackageBase.getDelegatedAuth(spn);
        if (this._sspiAuth == null) {
            try {
                this._sspiAuth = new SSPIAuth(securityPackage, securityPackageLst, spn, host, port);
            }
            catch (UnsatisfiedLinkError ule) {
                String messageIndex = "SecurityPackageBase.000.ex.txt";
                String message = RB.getStringResource(messageIndex, this._locale);
                INITIALIZE initialize = new INITIALIZE(message);
                initialize.initCause((Throwable)ule);
                throw initialize;
            }
        }
        int bufL = this._sspiAuth.GetMaxMessageSize();
        this._contextBuf = new byte[bufL];
        this.updateContext(null);
    }

    protected synchronized byte[] getContext() {
        if (this._sspiAuth == null) {
            throw new IllegalStateException();
        }
        return this._curContext;
    }

    protected synchronized void updateContext(byte[] newContext) {
        if (this._sspiAuth == null) {
            throw new IllegalStateException();
        }
        if (!this._sspiAuth.AmIDone()) {
            int contextBufL = 0;
            try {
                contextBufL = this._sspiAuth.GenClientContext(newContext, this._contextBuf);
            }
            catch (SSPIAuthException sae) {
                String messageIndex = "SecurityPackageBase.001.ex.txt";
                String message = RB.getStringResource(messageIndex, this._locale);
                UNKNOWN unknown = new UNKNOWN(message);
                unknown.initCause((Throwable)sae);
                throw unknown;
            }
            this._curContext = new byte[contextBufL];
            System.arraycopy(this._contextBuf, 0, this._curContext, 0, contextBufL);
        } else if (newContext != null) {
            this._curContext = new byte[newContext.length];
            System.arraycopy(newContext, 0, this._curContext, 0, newContext.length);
        } else {
            this._curContext = null;
        }
    }

    protected synchronized void term() {
        if (this._sspiAuth != null) {
            this._sspiAuth.deleteSecurityContext();
            this._sspiAuth.freeCredentialsHandle();
            this._sspiAuth = null;
            this._contextBuf = null;
            this._curContext = null;
        }
    }

    protected void setContinuationFlag(byte continuationFlag) {
        this._continuationFlag = continuationFlag;
    }

    protected byte getContinuationFlag() {
        return this._continuationFlag;
    }

    protected void setLocale(Locale locale) {
        this._locale = locale;
    }

    protected Locale getLocale() {
        return this._locale;
    }

    private static SSPIAuth getDelegatedAuth(String spn) {
        if (spn != null) {
            try {
                Class<?> jgssAuthClass = Class.forName(JGSSAuth_Class);
                Method hasClientContextMethod = jgssAuthClass.getMethod(JGSSAuth_Method_hasClientContext, String.class);
                Boolean result = (Boolean)hasClientContextMethod.invoke(null, spn);
                if (result.booleanValue()) {
                    Constructor<?> constructor = jgssAuthClass.getConstructor(String.class);
                    return (SSPIAuth)constructor.newInstance(spn);
                }
            }
            catch (ClassNotFoundException jgssAuthClass) {
            }
            catch (NoSuchMethodException nsme) {
                throw new IllegalStateException(nsme);
            }
            catch (InvocationTargetException ite) {
                throw new IllegalStateException(ite.getTargetException());
            }
            catch (IllegalAccessException iae) {
                throw new IllegalStateException(iae);
            }
            catch (InstantiationException ie) {
                throw new IllegalStateException(ie);
            }
        }
        return null;
    }
}

