/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom.orb.brg;

import com.sas.codepolicy.SASScope;
import com.sas.iom.orb.SelectionHandlerInterface;
import com.sas.iom.orb.SelectionHub;
import com.sas.iom.orb.SelectionHubActivation;
import com.sas.iom.orb.SelectionHubKey;
import com.sas.iom.orb.TrackedResourceInterface;
import com.sas.iom.orb.WorkException;
import com.sas.iom.orb.WorkInterface;
import com.sas.iom.orb.brg.Conversation;
import com.sas.iom.orb.brg.Engine;
import com.sas.iom.orb.brg.ORBImpl;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.SystemException;

@SASScope
public final class Daemon
implements SelectionHandlerInterface,
TrackedResourceInterface,
WorkInterface {
    public static final String hostKey = "host";
    public static final String portKey = "port";
    public static final String encrKey = "encr";
    public static final String encrlvlKey = "encrlvl";
    public static final String peLevelKey = "pelevel";
    public static final String logFileKey = "logfile";
    public static final String majorKey = "major";
    public static final String minorKey = "minor";
    public static final String lockserverKey = "lockserver";
    public static final String noSecurityKey = "nosecurity";
    public static final String loginConfigAppNameKey = "loginconfigappname";
    public static final String loggerNameSuffixKey = "loggernamesuffix";
    public static final String clsidMapKey = "clsidmap";
    public static final String defaultClassNameKey = "defaultclassname";
    private static final Logger _logger = LogManager.getLogger(Daemon.class);
    private static long _daemonCounter;
    private long _daemonID;
    private long _connectionCounter;
    private ORBImpl _orb;
    private SocketAddress _addr;
    private Map _options;
    private SelectionHub _hub;
    private ServerSocketChannel _serverChannel;
    private SelectionHubActivation _act;
    private List _sockList;
    private Map _conversationMap;
    private boolean _lockServer;
    private boolean _noSecurity;
    private String _loginConfigAppName;
    private boolean _shutdown;

    protected Daemon(ORBImpl orb, SelectionHub hub, Properties daemonParms) {
        this._orb = orb;
        this._hub = hub;
        this._daemonID = Daemon.assignDaemonID();
        String host = daemonParms.getProperty(hostKey);
        String _port = daemonParms.getProperty(portKey, "0");
        int port = Integer.parseInt(_port);
        this._addr = host == null ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
        this._lockServer = daemonParms.containsKey(lockserverKey);
        this._noSecurity = daemonParms.containsKey(noSecurityKey);
        this._loginConfigAppName = daemonParms.getProperty(loginConfigAppNameKey, "PFS");
        HashMap ops = new HashMap();
        Daemon.parmToOptionString(encrKey, daemonParms, encrKey, ops);
        Daemon.parmToOptionString(encrlvlKey, daemonParms, encrlvlKey, ops);
        Daemon.parmToOptionString(defaultClassNameKey, daemonParms, defaultClassNameKey, ops);
        Daemon.parmToOptionByte(majorKey, daemonParms, majorKey, ops);
        Daemon.parmToOptionByte(minorKey, daemonParms, minorKey, ops);
        Daemon.loadClsidMap(daemonParms, ops);
        this._options = Collections.unmodifiableMap(ops);
        this._sockList = new ArrayList(4);
        this._conversationMap = new WeakHashMap(8);
    }

    @Override
    public void handleException(SelectionHubKey hubKey, IOException ex) {
        _logger.fatal("listen failed", (Throwable)ex);
        this.shutdown(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleSelection(SelectionHubKey hubKey) {
        ServerSocketChannel srvrChannel = (ServerSocketChannel)hubKey.channel();
        SocketChannel sockChannel = null;
        try {
            sockChannel = srvrChannel.accept();
        }
        catch (IOException ioe) {
            Daemon daemon = this;
            synchronized (daemon) {
                if (!this._shutdown) {
                    _logger.fatal("accept failed", (Throwable)ioe);
                }
            }
        }
        if (sockChannel == null) {
            return;
        }
        List ioe = this._sockList;
        synchronized (ioe) {
            this._sockList.add(sockChannel);
        }
        try {
            hubKey.executeDaemon(this);
        }
        catch (WorkException we) {
            this.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SocketChannel channel = null;
        List list = this._sockList;
        synchronized (list) {
            if (this._sockList.isEmpty()) {
                return;
            }
            channel = (SocketChannel)this._sockList.remove(0);
        }
        if (_logger.isDebugEnabled()) {
            Socket sock = channel.socket();
            InetAddress addr = sock.getInetAddress();
            String msg = "accepting inbound connection from " + addr.toString();
            _logger.debug(msg);
        }
        try {
            Conversation conversation = new Conversation(this._orb, this._hub, this, channel);
            Engine.initServer(conversation);
            Map map = this._conversationMap;
            synchronized (map) {
                this._conversationMap.put(conversation, null);
            }
        }
        catch (SystemException se) {
            _logger.fatal("conversation initialization failed", (Throwable)se);
        }
    }

    @Override
    public void release() {
    }

    public synchronized int start() {
        this._orb.trackResource(this);
        try {
            this._serverChannel = ServerSocketChannel.open();
            ServerSocket socket = this._serverChannel.socket();
            socket.setReuseAddress(true);
            socket.bind(this._addr);
            int localPort = socket.getLocalPort();
            this._serverChannel.configureBlocking(false);
            this._act = this._hub.activateServer(this._serverChannel, 16, this);
            this._act.register();
            this._shutdown = false;
            return localPort;
        }
        catch (IOException ioe) {
            COMM_FAILURE comm_failure = new COMM_FAILURE();
            comm_failure.initCause((Throwable)ioe);
            throw comm_failure;
        }
    }

    @Override
    public synchronized void shutdown(boolean waitForCompletion) {
        this._shutdown = true;
        if (this._serverChannel != null) {
            try {
                this._serverChannel.close();
            }
            catch (IOException ioe) {
                _logger.debug("ignoring exception thrown while closing server socket channel", (Throwable)ioe);
            }
            this._serverChannel = null;
        }
        this._orb.untrackResource(this);
        if (this._act != null) {
            this._act.deactivate();
            this._act = null;
        }
    }

    protected Map getOptions() {
        return this._options;
    }

    protected boolean isSecurityDisabled() {
        return this._noSecurity;
    }

    protected String getLoginConfigAppName() {
        return this._loginConfigAppName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void abortConversation(Conversation conversation) {
        boolean empty = false;
        Map map = this._conversationMap;
        synchronized (map) {
            this._conversationMap.remove(conversation);
            empty = this._conversationMap.isEmpty();
        }
        if (empty && !this._lockServer) {
            this.shutdown(true);
        }
    }

    protected long getDaemonID() {
        return this._daemonID;
    }

    protected synchronized long assignConnectionID() {
        long connectionID = this._connectionCounter++;
        return connectionID;
    }

    private static void parmToOptionByte(String parmName, Properties parms, String opName, Map options) {
        String _val = parms.getProperty(parmName);
        if (_val != null) {
            Byte val = Byte.valueOf(_val);
            options.put(opName, val);
        }
    }

    private static void parmToOptionString(String parmName, Properties parms, String opName, Map options) {
        String _val = parms.getProperty(parmName);
        if (_val != null) {
            options.put(opName, _val);
        }
    }

    private static void loadClsidMap(Properties parms, Map options) {
        String fileName = parms.getProperty(clsidMapKey);
        if (fileName == null) {
            return;
        }
        Properties properties = new Properties();
        try {
            FileInputStream is = new FileInputStream(fileName);
            properties.load(is);
        }
        catch (IOException ioe) {
            BAD_PARAM bad_param = new BAD_PARAM();
            bad_param.initCause((Throwable)ioe);
            throw bad_param;
        }
        int size = properties.size();
        Map<String, Object> clsidMap = new HashMap(size);
        Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            String classID = entry.getKey().toString().toLowerCase(Locale.US);
            Object className = entry.getValue();
            clsidMap.put(classID, className);
        }
        clsidMap = Collections.unmodifiableMap(clsidMap);
        options.put(clsidMapKey, clsidMap);
    }

    private static synchronized long assignDaemonID() {
        long daemonID = _daemonCounter++;
        return daemonID;
    }
}

