/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom.orb;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.iom.SASIOMDefs.UUID;
import java.util.Arrays;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class UUIDConverter {
    private UUIDConverter() {
    }

    public static String uuidToString(UUID uuid) {
        int i;
        StringBuffer buf = new StringBuffer(36);
        UUIDConverter.dataToString(uuid.Data1, 8, buf);
        buf.append("-");
        UUIDConverter.dataToString(uuid.Data2, 4, buf);
        buf.append("-");
        UUIDConverter.dataToString(uuid.Data3, 4, buf);
        buf.append("-");
        for (i = 0; i < 2; ++i) {
            UUIDConverter.dataToString(uuid.Data4[i], 2, buf);
        }
        buf.append("-");
        for (i = 2; i < 8; ++i) {
            UUIDConverter.dataToString(uuid.Data4[i], 2, buf);
        }
        String s = buf.toString();
        return s;
    }

    public static UUID stringToUUID(String str) {
        int i;
        int d1 = (int)Long.parseLong(str.substring(0, 8), 16);
        short d2 = (short)Long.parseLong(str.substring(9, 13), 16);
        short d3 = (short)Long.parseLong(str.substring(14, 18), 16);
        byte[] d4 = new byte[8];
        for (i = 0; i < 2; ++i) {
            d4[i] = (byte)Long.parseLong(str.substring(i * 2 + 19, i * 2 + 21), 16);
        }
        for (i = 2; i < 8; ++i) {
            d4[i] = (byte)Long.parseLong(str.substring(i * 2 + 20, i * 2 + 22), 16);
        }
        UUID uuid = new UUID(d1, d2, d3, d4);
        return uuid;
    }

    public static boolean equals(UUID uuid1, UUID uuid2) {
        if (uuid1 == uuid2) {
            return true;
        }
        if (uuid1 == null || uuid2 == null) {
            return false;
        }
        if (uuid1.Data1 != uuid2.Data1) {
            return false;
        }
        if (uuid1.Data2 != uuid2.Data2) {
            return false;
        }
        if (uuid1.Data3 != uuid2.Data3) {
            return false;
        }
        return Arrays.equals(uuid1.Data4, uuid2.Data4);
    }

    @SASScope
    protected static void dataToString(int data, int length, StringBuffer hexBuffer) {
        if (data < 0) {
            if (length == 2) {
                data += 256;
            } else if (length == 4) {
                data += 65536;
            }
        }
        String hex = Integer.toHexString(data);
        for (int i = length - hex.length(); i > 0; --i) {
            hexBuffer.append("0");
        }
        hexBuffer.append(hex);
    }
}

