/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom.orb;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SASIOMDefs.CP_ID;
import com.sas.iom.SASIOMDefs.ConnectionPoint;
import com.sas.iom.SASIOMDefs.ConnectionPointContainer_1_1Operations;
import com.sas.iom.SASIOMDefs.ConnectionPointHelper;
import com.sas.iom.SASIOMDefs.ConnectionPointHolder;
import com.sas.iom.SASIOMDefs.ConnectionPointPOA;
import com.sas.iom.orb.CP_IDConverter;
import com.sas.iom.orb.DelegateBase;
import com.sas.iom.orb.GenericObject;
import com.sas.iom.orb.ORBBase;
import com.sas.iom.orb.POAImpl;
import com.sas.iom.orb.RequestBase;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.Bounds;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Request;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.PortableServer.Servant;

@SASScope
public class ConnectionPointContainerImpl
implements ConnectionPointContainer_1_1Operations {
    private static final String helperSuffix = "Helper";
    private static final String idName = "id";
    private ORBBase orb;
    private Map cpMap;

    public ConnectionPointContainerImpl(ORBBase orb, Class[] eventInterfaces) {
        this.orb = orb;
        int count = eventInterfaces != null ? eventInterfaces.length : 0;
        this.cpMap = new HashMap(count * 2);
        for (int i = 0; i < count; ++i) {
            this.activateConnectionPoint(eventInterfaces[i], null);
        }
    }

    public ORBBase getORB() {
        return this.orb;
    }

    public synchronized Object getEventSink(Class eventInterface) {
        CP_ID cpid = ConnectionPointContainerImpl.eventInterfaceToID(eventInterface);
        String id = CP_IDConverter.cp_idToString(cpid);
        ConnectionPoint cpRef = (ConnectionPoint)this.cpMap.get(id);
        POAImpl poa = this.orb.getRootPOA();
        ConnectionPointImpl cp = (ConnectionPointImpl)poa.transientReferenceToServant(cpRef);
        Object sink = cp.getSink();
        return sink;
    }

    @Override
    public synchronized void FindConnectionPoint(CP_ID arg0, ConnectionPointHolder arg1) {
        String id = CP_IDConverter.cp_idToString(arg0);
        arg1.value = (ConnectionPoint)this.cpMap.get(id);
    }

    @Override
    public synchronized CP_ID[] SupportedConnectionPoints() {
        Set keySet = this.cpMap.keySet();
        int size = keySet.size();
        CP_ID[] cpidArray = new CP_ID[size];
        Iterator keyItr = keySet.iterator();
        for (int i = 0; i < size; ++i) {
            String id = (String)keyItr.next();
            cpidArray[i] = CP_IDConverter.stringToCP_ID(id);
        }
        return cpidArray;
    }

    private void activateConnectionPoint(Class eventInterface, ConnectionPointImpl parent) {
        if (eventInterface.equals(Object.class)) {
            return;
        }
        CP_ID cpid = ConnectionPointContainerImpl.eventInterfaceToID(eventInterface);
        String id = CP_IDConverter.cp_idToString(cpid);
        ConnectionPointImpl cpServant = new ConnectionPointImpl(cpid, parent);
        POAImpl poa = this.orb.getRootPOA();
        Object _cp = poa.activateTransientObject((Servant)cpServant);
        ConnectionPoint cp = ConnectionPointHelper.narrow(_cp);
        this.cpMap.put(id, cp);
        Class<?>[] kids = eventInterface.getInterfaces();
        for (int i = 0; i < kids.length; ++i) {
            this.activateConnectionPoint(kids[i], cpServant);
        }
    }

    private static CP_ID eventInterfaceToID(Class eventInterface) {
        String base = eventInterface.getName();
        String helperName = base + helperSuffix;
        Class<?> helper = null;
        try {
            helper = Class.forName(helperName);
        }
        catch (ClassNotFoundException cnfe) {
            BAD_PARAM bad_param = new BAD_PARAM(base);
            bad_param.initCause((Throwable)cnfe);
            throw bad_param;
        }
        Method idMethod = null;
        try {
            idMethod = helper.getMethod(idName, null);
        }
        catch (NoSuchMethodException nsme) {
            BAD_PARAM bad_param = new BAD_PARAM(base);
            bad_param.initCause((Throwable)nsme);
            throw bad_param;
        }
        String id = null;
        try {
            id = (String)idMethod.invoke(null, (java.lang.Object[])null);
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getTargetException();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            BAD_PARAM bad_param = new BAD_PARAM(base);
            bad_param.initCause(cause);
            throw bad_param;
        }
        catch (IllegalAccessException iae) {
            BAD_PARAM bad_param = new BAD_PARAM(base);
            bad_param.initCause((Throwable)iae);
            throw bad_param;
        }
        CP_ID cpid = CP_IDConverter.stringToCP_ID(id);
        return cpid;
    }

    @SASScope
    private class EventSinkRequestImpl
    extends RequestBase {
        protected EventSinkRequestImpl(Object target, String operation) {
            super((ORB)ConnectionPointContainerImpl.this.orb, target, operation);
        }

        public void invoke() {
            ObjectImpl targ = (ObjectImpl)this.target();
            EventSinkDelegateImpl delegate = (EventSinkDelegateImpl)targ._get_delegate();
            ConnectionPointImpl cp = delegate.getConnectionPoint();
            this.broadcast(cp);
        }

        private void broadcast(ConnectionPointImpl cp) {
            String op = this.operation();
            NVList args = this.arguments();
            int argCount = args.count();
            Collection listeners = cp.getListeners();
            for (Object listener : listeners) {
                Request subRequest = listener._request(op);
                NVList subArgs = subRequest.arguments();
                for (int i = 0; i < argCount; ++i) {
                    NamedValue nv = null;
                    try {
                        nv = args.item(i);
                    }
                    catch (Bounds b) {
                        INTERNAL internal = new INTERNAL();
                        internal.initCause((Throwable)b);
                        throw internal;
                    }
                    String name = nv.name();
                    Any value = nv.value();
                    int flags = nv.flags();
                    subArgs.add_value(name, value, flags);
                }
                subRequest.invoke();
            }
            ConnectionPointImpl parent = cp.getParent();
            if (parent != null) {
                this.broadcast(parent);
            }
        }
    }

    @SASScope
    private class EventSinkDelegateImpl
    extends DelegateBase {
        private ConnectionPointImpl cp;

        protected EventSinkDelegateImpl(ConnectionPointImpl cp) {
            super((ORB)ConnectionPointContainerImpl.this.orb);
            this.cp = cp;
        }

        public boolean is_a(Object obj, String repository_id) {
            CP_ID candidate;
            CP_ID cpid = this.cp.getCP_ID();
            return CP_IDConverter.equals(cpid, candidate = CP_IDConverter.stringToCP_ID(repository_id));
        }

        public boolean non_existent(Object obj) {
            return false;
        }

        @Override
        public Request request(Object obj, String operation) {
            return new EventSinkRequestImpl(obj, operation);
        }

        protected ConnectionPointImpl getConnectionPoint() {
            return this.cp;
        }
    }

    @SASScope
    private class ConnectionPointImpl
    extends ConnectionPointPOA {
        private CP_ID cpid;
        private ConnectionPointImpl parent;
        private Map listenerMap;
        private GenericObject sink;
        private int idCounter;

        protected ConnectionPointImpl(CP_ID cpid, ConnectionPointImpl parent) {
            this.cpid = cpid;
            this.parent = parent;
            this.listenerMap = new HashMap(8);
            this.sink = new GenericObject();
            EventSinkDelegateImpl sinkDelegate = new EventSinkDelegateImpl(this);
            this.sink._set_delegate(sinkDelegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void Advise(Object arg0, IntHolder arg1) {
            int id = 0;
            ConnectionPointImpl connectionPointImpl = this;
            synchronized (connectionPointImpl) {
                id = this.idCounter++;
            }
            Integer key = new Integer(id);
            this.listenerMap.put(key, arg0);
            arg1.value = id;
        }

        @Override
        public void Unadvise(int arg0) {
            Integer key = new Integer(arg0);
            this.listenerMap.remove(key);
        }

        protected CP_ID getCP_ID() {
            return this.cpid;
        }

        protected ConnectionPointImpl getParent() {
            return this.parent;
        }

        protected Collection getListeners() {
            Collection listeners = this.listenerMap.values();
            return listeners;
        }

        protected Object getSink() {
            return this.sink;
        }
    }
}

