/*
 * Decompiled with CFR 0.152.
 */
package com.sas.filter.model;

public class Timestamp
extends java.sql.Timestamp {
    private static final long serialVersionUID = 1L;
    private static final long MILLISECONDS_IN_DAY = 86400000L;

    public Timestamp(long time) {
        super(time);
    }

    public static java.sql.Timestamp valueOf(String s) {
        String str = null;
        java.sql.Timestamp ts = null;
        long t = 0L;
        String[] tokens = s.split(":");
        switch (tokens.length) {
            case 4: {
                str = "1970-01-01 " + tokens[1] + ":" + tokens[2] + ":" + tokens[3];
                ts = java.sql.Timestamp.valueOf(str);
                int days = Integer.valueOf(tokens[0]);
                t = ts.getTime() + (long)days * 86400000L;
                break;
            }
            case 3: {
                str = "1970-01-01 " + s;
                ts = java.sql.Timestamp.valueOf(str);
                t = ts.getTime();
                break;
            }
            default: {
                throw new IllegalArgumentException("Timestamp format must be [days:]hh:mm:ss[.fffffffff]");
            }
        }
        return new Timestamp(t);
    }

    @Override
    public String toString() {
        String nanosString;
        long t = super.getTime();
        long days = t % 86400000L;
        int hour = super.getHours();
        int minute = super.getMinutes();
        int second = super.getSeconds();
        int nanos = super.getNanos();
        String dayString = days > 0L ? Long.toString(days) : null;
        String zeros = "000000000";
        String hourString = hour < 10 ? "0" + hour : Integer.toString(hour);
        String minuteString = minute < 10 ? "0" + minute : Integer.toString(minute);
        String secondString = second < 10 ? "0" + second : Integer.toString(second);
        if (nanos == 0) {
            nanosString = "0";
        } else {
            nanosString = Integer.toString(nanos);
            nanosString = zeros.substring(0, 9 - nanosString.length()) + nanosString;
            char[] nanosChar = new char[nanosString.length()];
            nanosString.getChars(0, nanosString.length(), nanosChar, 0);
            int truncIndex = 8;
            while (nanosChar[truncIndex] == '0') {
                --truncIndex;
            }
            nanosString = new String(nanosChar, 0, truncIndex + 1);
        }
        StringBuffer timestampBuf = new StringBuffer(20 + nanosString.length());
        if (dayString != null) {
            timestampBuf.append(dayString);
            timestampBuf.append(":");
        }
        timestampBuf.append(hourString);
        timestampBuf.append(":");
        timestampBuf.append(minuteString);
        timestampBuf.append(":");
        timestampBuf.append(secondString);
        timestampBuf.append(".");
        timestampBuf.append(nanosString);
        return timestampBuf.toString();
    }
}

