/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.beans.ConstructorProperties;
import java.io.InvalidObjectException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.WeakHashMap;
import javax.management.JMX;
import javax.management.ObjectName;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataInvocationHandler;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularType;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.management.ManagementException;
import org.apache.geode.management.internal.ArrayConverter;
import org.apache.geode.management.internal.CollectionConverter;
import org.apache.geode.management.internal.CompositeConverter;
import org.apache.geode.management.internal.EnumConverter;
import org.apache.geode.management.internal.IdentityConverter;
import org.apache.geode.management.internal.OpenTypeUtil;
import org.apache.geode.management.internal.TableConverter;

public abstract class OpenTypeConverter {
    private final Type targetType;
    private final OpenType openType;
    private final Class openClass;
    @MakeNotStatic
    private static final ConverterMap converterMap;
    @MakeNotStatic
    private static final Map<Type, Type> inProgress;
    @MakeNotStatic
    private static final List<OpenTypeConverter> preDefinedConverters;
    @Immutable
    protected static final String[] keyArray;
    @Immutable
    protected static final String[] keyValueArray;

    protected OpenTypeConverter(Type targetType, OpenType openType, Class openClass) {
        this.targetType = targetType;
        this.openType = openType;
        this.openClass = openClass;
    }

    public Object fromOpenValue(Object value) throws InvalidObjectException {
        if (value == null) {
            return null;
        }
        return this.fromNonNullOpenValue(value);
    }

    abstract Object fromNonNullOpenValue(Object var1) throws InvalidObjectException;

    void checkReconstructible() throws InvalidObjectException {
    }

    Object toOpenValue(Object value) throws OpenDataException {
        if (value == null) {
            return null;
        }
        return this.toNonNullOpenValue(value);
    }

    abstract Object toNonNullOpenValue(Object var1) throws OpenDataException;

    boolean isIdentity() {
        return false;
    }

    Type getTargetType() {
        return this.targetType;
    }

    OpenType getOpenType() {
        return this.openType;
    }

    Class getOpenClass() {
        return this.openClass;
    }

    private static synchronized OpenTypeConverter getConverter(Type type) {
        WeakReference wr;
        Type component;
        if (type instanceof GenericArrayType && (component = ((GenericArrayType)((Object)type)).getGenericComponentType()) instanceof Class) {
            type = Array.newInstance((Class)component, 0).getClass();
        }
        return (wr = (WeakReference)converterMap.get(type)) == null ? null : (OpenTypeConverter)wr.get();
    }

    private static synchronized void putConverter(Type type, OpenTypeConverter conv) {
        WeakReference<OpenTypeConverter> wr = new WeakReference<OpenTypeConverter>(conv);
        converterMap.put(type, wr);
    }

    private static synchronized void putPreDefinedConverter(Type type, OpenTypeConverter conv) {
        OpenTypeConverter.putConverter(type, conv);
        preDefinedConverters.add(conv);
    }

    public static synchronized OpenTypeConverter toConverter(Type objType) throws OpenDataException {
        if (inProgress.containsKey(objType)) {
            throw new OpenDataException("Recursive data structure, including " + OpenTypeConverter.typeName(objType));
        }
        OpenTypeConverter conv = OpenTypeConverter.getConverter(objType);
        if (conv != null) {
            return conv;
        }
        inProgress.put(objType, objType);
        try {
            conv = OpenTypeConverter.makeConverter(objType);
        }
        catch (OpenDataException e) {
            throw OpenTypeConverter.openDataException("Cannot convert type: " + objType, e);
        }
        finally {
            inProgress.remove(objType);
        }
        OpenTypeConverter.putConverter(objType, conv);
        return conv;
    }

    private static OpenTypeConverter makeConverter(Type objType) throws OpenDataException {
        if (objType instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)objType).getGenericComponentType();
            return OpenTypeConverter.makeArrayOrCollectionConverter(objType, componentType);
        }
        if (objType instanceof Class) {
            Class objClass = (Class)objType;
            if (objClass.isEnum()) {
                return OpenTypeConverter.makeEnumConverter(objClass);
            }
            if (objClass.isArray()) {
                Class<?> componentType = objClass.getComponentType();
                return OpenTypeConverter.makeArrayOrCollectionConverter(objClass, componentType);
            }
            if (JMX.isMXBeanInterface(objClass)) {
                throw OpenTypeConverter.openDataException("Cannot obtain array class", new ManagementException(" MXBean as an Return Type is not supported"));
            }
            return OpenTypeConverter.makeCompositeConverter(objClass);
        }
        if (objType instanceof ParameterizedType) {
            return OpenTypeConverter.makeParameterizedConverter((ParameterizedType)objType);
        }
        throw new OpenDataException("Cannot map type: " + objType);
    }

    private static <T extends Enum<T>> OpenTypeConverter makeEnumConverter(Class<T> enumClass) {
        return new EnumConverter<T>(enumClass);
    }

    private static OpenTypeConverter makeArrayOrCollectionConverter(Type collectionType, Type elementType) throws OpenDataException {
        Class<?> openArrayClass;
        OpenTypeConverter elementConverter = OpenTypeConverter.toConverter(elementType);
        OpenType elementOpenType = elementConverter.getOpenType();
        ArrayType openType = new ArrayType(1, elementOpenType);
        Class elementOpenClass = elementConverter.getOpenClass();
        String openArrayClassName = elementOpenClass.isArray() ? "[" + elementOpenClass.getName() : "[L" + elementOpenClass.getName() + ";";
        try {
            openArrayClass = Class.forName(openArrayClassName);
        }
        catch (ClassNotFoundException e) {
            throw OpenTypeConverter.openDataException("Cannot obtain array class", e);
        }
        if (collectionType instanceof ParameterizedType) {
            return new CollectionConverter(collectionType, openType, openArrayClass, elementConverter);
        }
        if (elementConverter.isIdentity()) {
            return new IdentityConverter(collectionType, openType, openArrayClass);
        }
        return new ArrayConverter(collectionType, openType, openArrayClass, elementConverter);
    }

    private static OpenTypeConverter makeTabularConverter(Type objType, boolean sortedMap, Type keyType, Type valueType) throws OpenDataException {
        String objTypeName = objType.toString();
        OpenTypeConverter keyConverter = OpenTypeConverter.toConverter(keyType);
        OpenTypeConverter valueConverter = OpenTypeConverter.toConverter(valueType);
        OpenType keyOpenType = keyConverter.getOpenType();
        OpenType valueOpenType = valueConverter.getOpenType();
        CompositeType rowType = new CompositeType(objTypeName, objTypeName, keyValueArray, keyValueArray, new OpenType[]{keyOpenType, valueOpenType});
        TabularType tabularType = new TabularType(objTypeName, objTypeName, rowType, keyArray);
        return new TableConverter(objType, sortedMap, tabularType, keyConverter, valueConverter);
    }

    private static OpenTypeConverter makeParameterizedConverter(ParameterizedType objType) throws OpenDataException {
        Type rawType = objType.getRawType();
        if (rawType instanceof Class) {
            boolean sortedMap;
            Class c = (Class)rawType;
            if (c == List.class || c == Set.class || c == SortedSet.class) {
                Type[] actuals = objType.getActualTypeArguments();
                assert (actuals.length == 1);
                if (c == SortedSet.class) {
                    OpenTypeConverter.mustBeComparable(c, actuals[0]);
                }
                return OpenTypeConverter.makeArrayOrCollectionConverter(objType, actuals[0]);
            }
            boolean bl = sortedMap = c == SortedMap.class;
            if (c == Map.class || sortedMap) {
                Type[] actuals = objType.getActualTypeArguments();
                assert (actuals.length == 2);
                if (sortedMap) {
                    OpenTypeConverter.mustBeComparable(c, actuals[0]);
                }
                return OpenTypeConverter.makeTabularConverter(objType, sortedMap, actuals[0], actuals[1]);
            }
        }
        throw new OpenDataException("Cannot convert type: " + objType);
    }

    private static OpenTypeConverter makeCompositeConverter(Class c) throws OpenDataException {
        Method[] methods = c.getMethods();
        SortedMap<String, Method> getterMap = OpenTypeUtil.newSortedMap();
        for (Method method : methods) {
            Object old;
            String propertyName = OpenTypeConverter.propertyName(method);
            if (propertyName == null || (old = getterMap.put(OpenTypeUtil.toCamelCase(propertyName), method)) == null) continue;
            String string = "Class " + c.getName() + " has method name clash: " + ((Method)old).getName() + ", " + method.getName();
            throw new OpenDataException(string);
        }
        int nitems = getterMap.size();
        if (nitems == 0) {
            throw new OpenDataException("Can't map " + c.getName() + " to an open data type");
        }
        Method[] getters = new Method[nitems];
        String[] itemNames = new String[nitems];
        OpenType[] openTypes = new OpenType[nitems];
        int i = 0;
        for (Map.Entry entry : getterMap.entrySet()) {
            Method getter;
            itemNames[i] = (String)entry.getKey();
            getters[i] = getter = (Method)entry.getValue();
            Type retType = getter.getGenericReturnType();
            openTypes[i] = OpenTypeConverter.toConverter(retType).getOpenType();
            ++i;
        }
        CompositeType compositeType = new CompositeType(c.getName(), c.getName(), itemNames, itemNames, openTypes);
        return new CompositeConverter(c, compositeType, itemNames, getters);
    }

    static InvalidObjectException invalidObjectException(String msg, Throwable cause) {
        return new InvalidObjectException(msg);
    }

    static InvalidObjectException invalidObjectException(Throwable cause) {
        return OpenTypeConverter.invalidObjectException(cause.getMessage(), cause);
    }

    static OpenDataException openDataException(String msg, Throwable cause) {
        return new OpenDataException(msg);
    }

    static OpenDataException openDataException(Throwable cause) {
        return OpenTypeConverter.openDataException(cause.getMessage(), cause);
    }

    static void mustBeComparable(Class collection, Type element) throws OpenDataException {
        if (!(element instanceof Class) || !Comparable.class.isAssignableFrom((Class)element)) {
            String msg = "Parameter class " + element + " of " + collection.getName() + " does not implement " + Comparable.class.getName();
            throw new OpenDataException(msg);
        }
    }

    public static String propertyName(Method m) {
        String rest = null;
        String name = m.getName();
        if (name.startsWith("get")) {
            rest = name.substring(3);
        } else if (name.startsWith("is") && m.getReturnType() == Boolean.TYPE) {
            rest = name.substring(2);
        }
        if (rest == null || rest.length() == 0 || m.getParameterTypes().length > 0 || m.getReturnType() == Void.TYPE || name.equals("getClass")) {
            return null;
        }
        return rest;
    }

    protected static String typeName(Type t) {
        if (t instanceof Class) {
            Class c = (Class)t;
            if (c.isArray()) {
                return OpenTypeConverter.typeName(c.getComponentType()) + "[]";
            }
            return c.getName();
        }
        return t.toString();
    }

    private static Type fixType(Type t) {
        if (!(t instanceof GenericArrayType)) {
            return t;
        }
        GenericArrayType gat = (GenericArrayType)t;
        Type ultimate = OpenTypeConverter.ultimateComponentType(gat);
        if (!(ultimate instanceof Class)) {
            return t;
        }
        Class component = (Class)OpenTypeConverter.fixType(gat.getGenericComponentType());
        return Array.newInstance(component, 0).getClass();
    }

    private static Type ultimateComponentType(GenericArrayType gat) {
        Type component = gat.getGenericComponentType();
        if (component instanceof GenericArrayType) {
            return OpenTypeConverter.ultimateComponentType((GenericArrayType)component);
        }
        return component;
    }

    static {
        OpenType[] simpleTypes;
        converterMap = new ConverterMap();
        inProgress = OpenTypeUtil.newIdentityHashMap();
        preDefinedConverters = OpenTypeUtil.newList();
        for (OpenType t : simpleTypes = new OpenType[]{SimpleType.BIGDECIMAL, SimpleType.BIGINTEGER, SimpleType.BOOLEAN, SimpleType.BYTE, SimpleType.CHARACTER, SimpleType.DATE, SimpleType.DOUBLE, SimpleType.FLOAT, SimpleType.INTEGER, SimpleType.LONG, SimpleType.OBJECTNAME, SimpleType.SHORT, SimpleType.STRING, SimpleType.VOID}) {
            Class<?> c;
            try {
                c = Class.forName(t.getClassName(), false, ObjectName.class.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new Error(e);
            }
            IdentityConverter conv = new IdentityConverter(c, t, c);
            OpenTypeConverter.putPreDefinedConverter(c, conv);
            if (!c.getName().startsWith("java.lang.")) continue;
            try {
                Field typeField = c.getField("TYPE");
                Class primitiveType = (Class)typeField.get(null);
                IdentityConverter primitiveConv = new IdentityConverter(primitiveType, t, primitiveType);
                OpenTypeConverter.putPreDefinedConverter(primitiveType, primitiveConv);
                if (primitiveType == Void.TYPE) continue;
                Class<?> primitiveArrayType = Array.newInstance(primitiveType, 0).getClass();
                ArrayType<?> primitiveArrayOpenType = ArrayType.getPrimitiveArrayType(primitiveArrayType);
                IdentityConverter primitiveArrayConv = new IdentityConverter(primitiveArrayType, primitiveArrayOpenType, primitiveArrayType);
                OpenTypeConverter.putPreDefinedConverter(primitiveArrayType, primitiveArrayConv);
            }
            catch (NoSuchFieldException typeField) {
            }
            catch (IllegalAccessException e) {
                assert (false);
            }
        }
        keyArray = new String[]{"key"};
        keyValueArray = new String[]{"key", "value"};
    }

    protected static class CompositeBuilderViaProxy
    extends CompositeBuilder {
        CompositeBuilderViaProxy(Class targetClass, String[] itemNames) {
            super(targetClass, itemNames);
        }

        @Override
        String applicable(Method[] getters) {
            Class targetClass = this.getTargetClass();
            if (!targetClass.isInterface()) {
                return "not an interface";
            }
            Set<Method> methods = OpenTypeUtil.newSet(Arrays.asList(targetClass.getMethods()));
            methods.removeAll(Arrays.asList(getters));
            String bad = null;
            for (Method m : methods) {
                String mname = m.getName();
                Class<?>[] mparams = m.getParameterTypes();
                try {
                    Method om = Object.class.getMethod(mname, mparams);
                    if (Modifier.isPublic(om.getModifiers())) continue;
                    bad = mname;
                }
                catch (NoSuchMethodException e) {
                    bad = mname;
                }
            }
            if (bad != null) {
                return "contains methods other than getters (" + bad + ")";
            }
            return null;
        }

        @Override
        Object fromCompositeData(CompositeData cd, String[] itemNames, OpenTypeConverter[] converters) {
            Class targetClass = this.getTargetClass();
            return Proxy.newProxyInstance(targetClass.getClassLoader(), new Class[]{targetClass}, (InvocationHandler)new CompositeDataInvocationHandler(cd));
        }
    }

    protected static class CompositeBuilderViaConstructor
    extends CompositeBuilder {
        private List<Constr> annotatedConstructors;

        CompositeBuilderViaConstructor(Class targetClass, String[] itemNames) {
            super(targetClass, itemNames);
        }

        @Override
        String applicable(Method[] getters) throws InvalidObjectException {
            Class<ConstructorProperties> propertyNamesClass = ConstructorProperties.class;
            Class targetClass = this.getTargetClass();
            Constructor<?>[] constrs = targetClass.getConstructors();
            List<Constructor<?>> annotatedConstrList = OpenTypeUtil.newList();
            for (Constructor<?> constr : constrs) {
                if (!Modifier.isPublic(constr.getModifiers()) || constr.getAnnotation(propertyNamesClass) == null) continue;
                annotatedConstrList.add(constr);
            }
            if (annotatedConstrList.isEmpty()) {
                return "no constructor has @ConstructorProperties annotation";
            }
            this.annotatedConstructors = OpenTypeUtil.newList();
            Map<String, Integer> getterMap = OpenTypeUtil.newMap();
            String[] itemNames = this.getItemNames();
            for (int i = 0; i < itemNames.length; ++i) {
                getterMap.put(itemNames[i], i);
            }
            Set<BitSet> getterIndexSets = OpenTypeUtil.newSet();
            for (Constructor constructor : annotatedConstrList) {
                Object[] propertyNames = constructor.getAnnotation(propertyNamesClass).value();
                Type[] paramTypes = constructor.getGenericParameterTypes();
                if (paramTypes.length != propertyNames.length) {
                    String msg = "Number of constructor params does not match @ConstructorProperties annotation: " + constructor;
                    throw new InvalidObjectException(msg);
                }
                for (int i = 0; i < paramTypes.length; ++i) {
                    paramTypes[i] = OpenTypeConverter.fixType(paramTypes[i]);
                }
                int[] paramIndexes = new int[getters.length];
                for (int i = 0; i < getters.length; ++i) {
                    paramIndexes[i] = -1;
                }
                BitSet present = new BitSet();
                for (int i = 0; i < propertyNames.length; ++i) {
                    String propertyName = propertyNames[i];
                    if (!getterMap.containsKey(propertyName)) {
                        String msg = "@ConstructorProperties includes name " + propertyName + " which does not correspond to a property";
                        for (String getterName : getterMap.keySet()) {
                            if (!getterName.equalsIgnoreCase(propertyName)) continue;
                            msg = msg + " (differs only in case from property " + getterName + ")";
                        }
                        msg = msg + ": " + constructor;
                        throw new InvalidObjectException(msg);
                    }
                    int getterIndex = (Integer)getterMap.get(propertyName);
                    paramIndexes[getterIndex] = i;
                    if (present.get(getterIndex)) {
                        String msg = "@ConstructorProperties contains property " + propertyName + " more than once: " + constructor;
                        throw new InvalidObjectException(msg);
                    }
                    present.set(getterIndex);
                    Method getter = getters[getterIndex];
                    Type propertyType = getter.getGenericReturnType();
                    if (propertyType.equals(paramTypes[i])) continue;
                    String msg = "@ConstructorProperties gives property " + propertyName + " of type " + propertyType + " for parameter  of type " + paramTypes[i] + ": " + constructor;
                    throw new InvalidObjectException(msg);
                }
                if (!getterIndexSets.add(present)) {
                    String msg = "More than one constructor has a @ConstructorProperties annotation with this set of names: " + Arrays.toString(propertyNames);
                    throw new InvalidObjectException(msg);
                }
                Constr c = new Constr(constructor, paramIndexes, present);
                this.annotatedConstructors.add(c);
            }
            for (BitSet bitSet : getterIndexSets) {
                boolean seen = false;
                for (BitSet b : getterIndexSets) {
                    if (bitSet == b) {
                        seen = true;
                        continue;
                    }
                    if (!seen) continue;
                    BitSet u = new BitSet();
                    u.or(bitSet);
                    u.or(b);
                    if (getterIndexSets.contains(u)) continue;
                    TreeSet<String> names = new TreeSet<String>();
                    int i = u.nextSetBit(0);
                    while (i >= 0) {
                        names.add(itemNames[i]);
                        i = u.nextSetBit(i + 1);
                    }
                    String msg = "Constructors with @ConstructorProperties annotation  would be ambiguous for these items: " + names;
                    throw new InvalidObjectException(msg);
                }
            }
            return null;
        }

        @Override
        Object fromCompositeData(CompositeData cd, String[] itemNames, OpenTypeConverter[] converters) throws InvalidObjectException {
            CompositeType ct = cd.getCompositeType();
            BitSet present = new BitSet();
            for (int i = 0; i < itemNames.length; ++i) {
                if (ct.getType(itemNames[i]) == null) continue;
                present.set(i);
            }
            Constr max = null;
            for (Constr constr : this.annotatedConstructors) {
                if (!CompositeBuilderViaConstructor.subset(constr.presentParams, present) || max != null && !CompositeBuilderViaConstructor.subset(max.presentParams, constr.presentParams)) continue;
                max = constr;
            }
            if (max == null) {
                String msg = "No constructor has a @ConstructorProperties for this set of items: " + ct.keySet();
                throw new InvalidObjectException(msg);
            }
            Object[] params = new Object[max.presentParams.cardinality()];
            for (int i = 0; i < itemNames.length; ++i) {
                if (!max.presentParams.get(i)) continue;
                Object openItem = cd.get(itemNames[i]);
                Object javaItem = converters[i].fromOpenValue(openItem);
                int index = max.paramIndexes[i];
                if (index < 0) continue;
                params[index] = javaItem;
            }
            try {
                return max.constructor.newInstance(params);
            }
            catch (Exception e) {
                String msg = "Exception constructing " + this.getTargetClass().getName();
                throw OpenTypeConverter.invalidObjectException(msg, e);
            }
        }

        private static boolean subset(BitSet sub, BitSet sup) {
            BitSet subcopy = (BitSet)sub.clone();
            subcopy.andNot(sup);
            return subcopy.isEmpty();
        }

        private static class Constr {
            final Constructor constructor;
            final int[] paramIndexes;
            final BitSet presentParams;

            Constr(Constructor constructor, int[] paramIndexes, BitSet presentParams) {
                this.constructor = constructor;
                this.paramIndexes = paramIndexes;
                this.presentParams = presentParams;
            }
        }
    }

    protected static class CompositeBuilderViaSetters
    extends CompositeBuilder {
        private Method[] setters;

        CompositeBuilderViaSetters(Class targetClass, String[] itemNames) {
            super(targetClass, itemNames);
        }

        @Override
        String applicable(Method[] getters) {
            try {
                Constructor constructor = this.getTargetClass().getConstructor(null);
            }
            catch (Exception e) {
                return "does not have a public no-arg constructor";
            }
            Method[] setters = new Method[getters.length];
            for (int i = 0; i < getters.length; ++i) {
                Method setter;
                Method getter = getters[i];
                Class<?> returnType = getter.getReturnType();
                String name = OpenTypeConverter.propertyName(getter);
                String setterName = "set" + name;
                try {
                    setter = this.getTargetClass().getMethod(setterName, returnType);
                    if (setter.getReturnType() != Void.TYPE) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    return "not all getters have corresponding setters (" + getter + ")";
                }
                setters[i] = setter;
            }
            this.setters = setters;
            return null;
        }

        @Override
        Object fromCompositeData(CompositeData cd, String[] itemNames, OpenTypeConverter[] converters) throws InvalidObjectException {
            Object o;
            try {
                o = this.getTargetClass().newInstance();
                for (int i = 0; i < itemNames.length; ++i) {
                    if (!cd.containsKey(itemNames[i])) continue;
                    Object openItem = cd.get(itemNames[i]);
                    Object javaItem = converters[i].fromOpenValue(openItem);
                    this.setters[i].invoke(o, javaItem);
                }
            }
            catch (Exception e) {
                throw OpenTypeConverter.invalidObjectException(e);
            }
            return o;
        }
    }

    protected static class CompositeBuilderCheckGetters
    extends CompositeBuilder {
        private final OpenTypeConverter[] getterConverters;
        private Throwable possibleCause;

        CompositeBuilderCheckGetters(Class targetClass, String[] itemNames, OpenTypeConverter[] getterConverters) {
            super(targetClass, itemNames);
            this.getterConverters = getterConverters;
        }

        @Override
        String applicable(Method[] getters) {
            for (int i = 0; i < getters.length; ++i) {
                try {
                    this.getterConverters[i].checkReconstructible();
                    continue;
                }
                catch (InvalidObjectException e) {
                    this.possibleCause = e;
                    return "method " + getters[i].getName() + " returns type that cannot be mapped back from OpenData";
                }
            }
            return "";
        }

        @Override
        Throwable possibleCause() {
            return this.possibleCause;
        }

        @Override
        Object fromCompositeData(CompositeData cd, String[] itemNames, OpenTypeConverter[] converters) {
            throw new Error();
        }
    }

    protected static class CompositeBuilderViaFrom
    extends CompositeBuilder {
        private Method fromMethod;

        CompositeBuilderViaFrom(Class targetClass, String[] itemNames) {
            super(targetClass, itemNames);
        }

        @Override
        String applicable(Method[] getters) throws InvalidObjectException {
            Class targetClass = this.getTargetClass();
            try {
                Method fromMethod = targetClass.getMethod("from", CompositeData.class);
                if (!Modifier.isStatic(fromMethod.getModifiers())) {
                    String msg = "Method from(CompositeData) is not static";
                    throw new InvalidObjectException("Method from(CompositeData) is not static");
                }
                if (fromMethod.getReturnType() != this.getTargetClass()) {
                    String msg = "Method from(CompositeData) returns " + OpenTypeConverter.typeName(fromMethod.getReturnType()) + " not " + OpenTypeConverter.typeName(targetClass);
                    throw new InvalidObjectException(msg);
                }
                this.fromMethod = fromMethod;
                return null;
            }
            catch (InvalidObjectException e) {
                throw e;
            }
            catch (Exception e) {
                return "no method from(CompositeData)";
            }
        }

        @Override
        Object fromCompositeData(CompositeData cd, String[] itemNames, OpenTypeConverter[] converters) throws InvalidObjectException {
            try {
                return this.fromMethod.invoke(null, cd);
            }
            catch (Exception e) {
                String msg = "Failed to invoke from(CompositeData)";
                throw OpenTypeConverter.invalidObjectException("Failed to invoke from(CompositeData)", e);
            }
        }
    }

    protected static abstract class CompositeBuilder {
        private final Class targetClass;
        private final String[] itemNames;

        CompositeBuilder(Class targetClass, String[] itemNames) {
            this.targetClass = targetClass;
            this.itemNames = itemNames;
        }

        Class getTargetClass() {
            return this.targetClass;
        }

        String[] getItemNames() {
            return this.itemNames;
        }

        abstract String applicable(Method[] var1) throws InvalidObjectException;

        Throwable possibleCause() {
            return null;
        }

        abstract Object fromCompositeData(CompositeData var1, String[] var2, OpenTypeConverter[] var3) throws InvalidObjectException;
    }

    private static class ConverterMap
    extends WeakHashMap<Type, WeakReference<OpenTypeConverter>> {
        private ConverterMap() {
        }
    }
}

