/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.versions;

import java.util.BitSet;
import java.util.Iterator;
import org.apache.geode.internal.cache.versions.RVVException;

public class BitSetExceptionIterator
implements Iterator<RVVException> {
    private final BitSet bitSet;
    private final long bitSetVersion;
    private final long maximumVersion;
    private long nextClearBit;

    public BitSetExceptionIterator(BitSet bitSet, long bitSetVersion, long maximumVersion) {
        this.bitSet = bitSet;
        this.bitSetVersion = bitSetVersion;
        this.maximumVersion = maximumVersion;
        this.nextClearBit = this.findNextClearBit(bitSet, 0);
    }

    private int findNextClearBit(BitSet bitSet, int fromIndex) {
        long maxmimumClearBit;
        int nextClearBit = bitSet.nextClearBit(fromIndex);
        if ((long)nextClearBit >= (maxmimumClearBit = this.maximumVersion - this.bitSetVersion)) {
            return -1;
        }
        return nextClearBit;
    }

    @Override
    public boolean hasNext() {
        return this.nextClearBit != -1L;
    }

    @Override
    public RVVException next() {
        if (!this.hasNext()) {
            return null;
        }
        int nextSetBit = this.bitSet.nextSetBit((int)Math.min(Integer.MAX_VALUE, this.nextClearBit));
        long nextSetVersion = nextSetBit == -1 ? this.maximumVersion : (long)nextSetBit + this.bitSetVersion;
        RVVException exception = RVVException.createException(this.nextClearBit + this.bitSetVersion - 1L, nextSetVersion);
        this.nextClearBit = nextSetBit == -1 ? -1L : (long)this.findNextClearBit(this.bitSet, nextSetBit);
        return exception;
    }
}

