/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ObjectPartList;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.SecurityService;
import org.jetbrains.annotations.NotNull;

public class GetAll70
extends BaseCommand {
    @Immutable
    private static final GetAll70 singleton = new GetAll70();

    public static Command getCommand() {
        return singleton;
    }

    @Override
    public void cmdExecute(@NotNull Message clientMessage, @NotNull ServerConnection serverConnection, @NotNull SecurityService securityService, long start) throws IOException, InterruptedException {
        boolean requestSerializedValues;
        Object[] keys;
        serverConnection.setAsTrue(2);
        serverConnection.setAsTrue(3);
        int partIdx = 0;
        Part regionNamePart = clientMessage.getPart(partIdx++);
        String regionName = regionNamePart.getCachedString();
        Part keysPart = clientMessage.getPart(partIdx++);
        try {
            keys = (Object[])keysPart.getObject();
        }
        catch (Exception e) {
            GetAll70.writeChunkedException(clientMessage, e, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        boolean bl = requestSerializedValues = clientMessage.getPart(partIdx++).getInt() == 1;
        if (logger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(serverConnection.getName()).append(": Received getAll request (").append(clientMessage.getPayloadLength()).append(" bytes) from ").append(serverConnection.getSocketString()).append(" for region ").append(regionName).append(" keys ");
            if (keys != null) {
                for (Object key : keys) {
                    buffer.append(key).append(" ");
                }
            } else {
                buffer.append("NULL");
            }
            logger.debug(buffer.toString());
        }
        if (regionName == null) {
            String message = "The input region name for the getAll request is null";
            logger.warn("{}: {}", (Object)serverConnection.getName(), (Object)message);
            GetAll70.writeChunkedErrorResponse(clientMessage, 58, message, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        LocalRegion region = (LocalRegion)serverConnection.getCache().getRegion(regionName);
        if (region == null) {
            String reason = " was not found during getAll request";
            GetAll70.writeRegionDestroyedEx(clientMessage, regionName, reason, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        ChunkedMessage chunkedResponseMsg = serverConnection.getChunkedResponseMessage();
        chunkedResponseMsg.setMessageType(1);
        chunkedResponseMsg.setTransactionId(clientMessage.getTransactionId());
        chunkedResponseMsg.sendHeader();
        try {
            this.fillAndSendGetAllResponseChunks(region, regionName, keys, serverConnection, requestSerializedValues, securityService);
            serverConnection.setAsTrue(1);
        }
        catch (Exception e) {
            GetAll70.checkForInterrupt(serverConnection, e);
            GetAll70.writeChunkedException(clientMessage, e, serverConnection);
            serverConnection.setAsTrue(1);
        }
    }

    /*
     * Exception decompiling
     */
    private void fillAndSendGetAllResponseChunks(Region<?, ?> region, String regionName, Object[] keys, ServerConnection servConn, boolean requestSerializedValues, SecurityService securityService) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK], 9[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void sendGetAllResponseChunk(Region<?, ?> region, ObjectPartList list, boolean lastChunk, ServerConnection servConn) throws IOException {
        ChunkedMessage chunkedResponseMsg = servConn.getChunkedResponseMessage();
        chunkedResponseMsg.setNumberOfParts(1);
        chunkedResponseMsg.setLastChunk(lastChunk);
        chunkedResponseMsg.addObjPartNoCopying(list);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sending {} getAll response chunk for region={}{}", (Object)servConn.getName(), (Object)(lastChunk ? " last " : " "), (Object)region.getFullPath(), (Object)(logger.isTraceEnabled() ? " values=" + list + " chunk=<" + chunkedResponseMsg + ">" : ""));
        }
        chunkedResponseMsg.sendChunk(servConn);
    }
}

