/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.entries;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.entries.VersionedThinRegionEntryHeap;
import org.apache.geode.internal.cache.versions.VersionSource;
import org.apache.geode.internal.cache.versions.VersionStamp;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.util.concurrent.CustomEntryConcurrentHashMap;

public class VersionedThinRegionEntryHeapStringKey1
extends VersionedThinRegionEntryHeap {
    private static final AtomicLongFieldUpdater<VersionedThinRegionEntryHeapStringKey1> LAST_MODIFIED_UPDATER = AtomicLongFieldUpdater.newUpdater(VersionedThinRegionEntryHeapStringKey1.class, "lastModified");
    protected int hash;
    private CustomEntryConcurrentHashMap.HashEntry<Object, Object> nextEntry;
    private volatile long lastModified;
    private volatile Object value;
    private VersionSource memberId;
    private short entryVersionLowBytes;
    private short regionVersionHighBytes;
    private int regionVersionLowBytes;
    private byte entryVersionHighByte;
    private byte distributedSystemId;
    private final long bits1;

    public VersionedThinRegionEntryHeapStringKey1(RegionEntryContext context, String key, Object value, boolean byteEncode) {
        super(context, value);
        long tempBits1 = 0L;
        if (byteEncode) {
            for (int i = key.length() - 1; i >= 0; --i) {
                tempBits1 |= (long)((byte)key.charAt(i) & 0xFF);
                tempBits1 <<= 8;
            }
            tempBits1 |= 0x40L;
        } else {
            for (int i = key.length() - 1; i >= 0; --i) {
                tempBits1 |= (long)key.charAt(i);
                tempBits1 <<= 16;
            }
        }
        this.bits1 = tempBits1 |= (long)key.length();
    }

    @Override
    protected Object getValueField() {
        return this.value;
    }

    @Override
    protected void setValueField(Object value) {
        this.value = value;
    }

    @Override
    protected long getLastModifiedField() {
        return LAST_MODIFIED_UPDATER.get(this);
    }

    @Override
    protected boolean compareAndSetLastModifiedField(long expectedValue, long newValue) {
        return LAST_MODIFIED_UPDATER.compareAndSet(this, expectedValue, newValue);
    }

    @Override
    public int getEntryHash() {
        return this.hash;
    }

    @Override
    protected void setEntryHash(int hash) {
        this.hash = hash;
    }

    @Override
    public CustomEntryConcurrentHashMap.HashEntry<Object, Object> getNextEntry() {
        return this.nextEntry;
    }

    @Override
    public void setNextEntry(CustomEntryConcurrentHashMap.HashEntry<Object, Object> nextEntry) {
        this.nextEntry = nextEntry;
    }

    @Override
    public int getEntryVersion() {
        return this.entryVersionHighByte << 16 & 0xFF0000 | this.entryVersionLowBytes & 0xFFFF;
    }

    @Override
    public long getRegionVersion() {
        return (long)this.regionVersionHighBytes << 32 | (long)this.regionVersionLowBytes & 0xFFFFFFFFL;
    }

    @Override
    public long getVersionTimeStamp() {
        return this.getLastModified();
    }

    @Override
    public void setVersionTimeStamp(long timeStamp) {
        this.setLastModified(timeStamp);
    }

    @Override
    public VersionSource getMemberID() {
        return this.memberId;
    }

    @Override
    public int getDistributedSystemId() {
        return this.distributedSystemId;
    }

    public void setVersions(VersionTag versionTag) {
        this.memberId = versionTag.getMemberID();
        int eVersion = versionTag.getEntryVersion();
        this.entryVersionLowBytes = (short)(eVersion & 0xFFFF);
        this.entryVersionHighByte = (byte)((eVersion & 0xFF0000) >> 16);
        this.regionVersionHighBytes = versionTag.getRegionVersionHighBytes();
        this.regionVersionLowBytes = versionTag.getRegionVersionLowBytes();
        if (!versionTag.isGatewayTag() && this.distributedSystemId == versionTag.getDistributedSystemId()) {
            if (this.getVersionTimeStamp() <= versionTag.getVersionTimeStamp()) {
                this.setVersionTimeStamp(versionTag.getVersionTimeStamp());
            } else {
                versionTag.setVersionTimeStamp(this.getVersionTimeStamp());
            }
        } else {
            this.setVersionTimeStamp(versionTag.getVersionTimeStamp());
        }
        this.distributedSystemId = (byte)(versionTag.getDistributedSystemId() & 0xFF);
    }

    @Override
    public void setMemberID(VersionSource memberId) {
        this.memberId = memberId;
    }

    @Override
    public VersionStamp getVersionStamp() {
        return this;
    }

    public VersionTag asVersionTag() {
        VersionTag tag = VersionTag.create(this.memberId);
        tag.setEntryVersion(this.getEntryVersion());
        tag.setRegionVersion(this.regionVersionHighBytes, this.regionVersionLowBytes);
        tag.setVersionTimeStamp(this.getVersionTimeStamp());
        tag.setDistributedSystemId(this.distributedSystemId);
        return tag;
    }

    public void processVersionTag(InternalRegion region, VersionTag versionTag, boolean isTombstoneFromGII, boolean hasDelta, VersionSource versionSource, InternalDistributedMember sender, boolean checkForConflicts) {
        this.basicProcessVersionTag(region, versionTag, isTombstoneFromGII, hasDelta, versionSource, sender, checkForConflicts);
    }

    @Override
    public void processVersionTag(EntryEvent cacheEvent) {
        super.processVersionTag(cacheEvent);
    }

    @Override
    public short getRegionVersionHighBytes() {
        return this.regionVersionHighBytes;
    }

    @Override
    public int getRegionVersionLowBytes() {
        return this.regionVersionLowBytes;
    }

    private int getKeyLength() {
        return (int)(this.bits1 & 0x3FL);
    }

    private int getEncoding() {
        return (int)(this.bits1 >> 6) & 3;
    }

    @Override
    public Object getKey() {
        int keyLength = this.getKeyLength();
        char[] chars = new char[keyLength];
        long tempBits1 = this.bits1;
        if (this.getEncoding() == 1) {
            for (int i = 0; i < keyLength; ++i) {
                chars[i] = (char)((tempBits1 >>= 8) & 0xFFL);
            }
        } else {
            for (int i = 0; i < keyLength; ++i) {
                chars[i] = (char)((tempBits1 >>= 16) & 0xFFFFL);
            }
        }
        return new String(chars);
    }

    @Override
    public boolean isKeyEqual(Object key) {
        if (key instanceof String) {
            String stringKey = (String)key;
            int keyLength = this.getKeyLength();
            if (stringKey.length() == keyLength) {
                long tempBits1 = this.bits1;
                if (this.getEncoding() == 1) {
                    for (int i = 0; i < keyLength; ++i) {
                        char character = (char)((tempBits1 >>= 8) & 0xFFL);
                        if (stringKey.charAt(i) == character) continue;
                        return false;
                    }
                } else {
                    for (int i = 0; i < keyLength; ++i) {
                        char character = (char)((tempBits1 >>= 16) & 0xFFFFL);
                        if (stringKey.charAt(i) == character) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }
}

