/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.entries;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.entries.VersionedThinLRURegionEntryOffHeap;
import org.apache.geode.internal.cache.eviction.EvictionController;
import org.apache.geode.internal.cache.eviction.EvictionNode;
import org.apache.geode.internal.cache.persistence.DiskRecoveryStore;
import org.apache.geode.internal.cache.versions.VersionSource;
import org.apache.geode.internal.cache.versions.VersionStamp;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.offheap.OffHeapRegionEntryHelper;
import org.apache.geode.internal.util.concurrent.CustomEntryConcurrentHashMap;

public class VersionedThinLRURegionEntryOffHeapUUIDKey
extends VersionedThinLRURegionEntryOffHeap {
    private static final AtomicLongFieldUpdater<VersionedThinLRURegionEntryOffHeapUUIDKey> LAST_MODIFIED_UPDATER = AtomicLongFieldUpdater.newUpdater(VersionedThinLRURegionEntryOffHeapUUIDKey.class, "lastModified");
    protected int hash;
    private CustomEntryConcurrentHashMap.HashEntry<Object, Object> nextEntry;
    private volatile long lastModified;
    private volatile long offHeapAddress;
    private static final AtomicLongFieldUpdater<VersionedThinLRURegionEntryOffHeapUUIDKey> OFF_HEAP_ADDRESS_UPDATER = AtomicLongFieldUpdater.newUpdater(VersionedThinLRURegionEntryOffHeapUUIDKey.class, "offHeapAddress");
    private VersionSource memberId;
    private short entryVersionLowBytes;
    private short regionVersionHighBytes;
    private int regionVersionLowBytes;
    private byte entryVersionHighByte;
    private byte distributedSystemId;
    private final long keyMostSigBits;
    private final long keyLeastSigBits;
    private EvictionNode nextEvictionNode;
    private EvictionNode previousEvictionNode;
    private int size;

    public VersionedThinLRURegionEntryOffHeapUUIDKey(RegionEntryContext context, UUID key, Object value) {
        super(context, value);
        this.keyMostSigBits = key.getMostSignificantBits();
        this.keyLeastSigBits = key.getLeastSignificantBits();
    }

    @Override
    public Token getValueAsToken() {
        return OffHeapRegionEntryHelper.getValueAsToken(this);
    }

    @Override
    protected Object getValueField() {
        return OffHeapRegionEntryHelper._getValue(this);
    }

    @Override
    protected void setValueField(Object value) {
        OffHeapRegionEntryHelper.setValue(this, value);
    }

    @Override
    public Object getValueRetain(RegionEntryContext context, boolean decompress) {
        return OffHeapRegionEntryHelper._getValueRetain(this, decompress, context);
    }

    @Override
    public long getAddress() {
        return OFF_HEAP_ADDRESS_UPDATER.get(this);
    }

    @Override
    public boolean setAddress(long expectedAddress, long newAddress) {
        return OFF_HEAP_ADDRESS_UPDATER.compareAndSet(this, expectedAddress, newAddress);
    }

    @Override
    public void release() {
        OffHeapRegionEntryHelper.releaseEntry(this);
    }

    @Override
    public void returnToPool() {
    }

    @Override
    protected long getLastModifiedField() {
        return LAST_MODIFIED_UPDATER.get(this);
    }

    @Override
    protected boolean compareAndSetLastModifiedField(long expectedValue, long newValue) {
        return LAST_MODIFIED_UPDATER.compareAndSet(this, expectedValue, newValue);
    }

    @Override
    public int getEntryHash() {
        return this.hash;
    }

    @Override
    protected void setEntryHash(int hash) {
        this.hash = hash;
    }

    @Override
    public CustomEntryConcurrentHashMap.HashEntry<Object, Object> getNextEntry() {
        return this.nextEntry;
    }

    @Override
    public void setNextEntry(CustomEntryConcurrentHashMap.HashEntry<Object, Object> nextEntry) {
        this.nextEntry = nextEntry;
    }

    @Override
    public void setDelayedDiskId(DiskRecoveryStore diskRecoveryStore) {
    }

    @Override
    public synchronized int updateEntrySize(EvictionController evictionController) {
        return this.updateEntrySize(evictionController, this.getValue());
    }

    @Override
    public synchronized int updateEntrySize(EvictionController evictionController, Object value) {
        int oldSize = this.getEntrySize();
        int newSize = evictionController.entrySize(this.getKeyForSizing(), value);
        this.setEntrySize(newSize);
        int delta = newSize - oldSize;
        return delta;
    }

    @Override
    public boolean isRecentlyUsed() {
        return this.areAnyBitsSet(0x1000000000000000L);
    }

    @Override
    public void setRecentlyUsed(RegionEntryContext context) {
        if (!this.isRecentlyUsed()) {
            this.setBits(0x1000000000000000L);
            context.incRecentlyUsed();
        }
    }

    @Override
    public void unsetRecentlyUsed() {
        this.clearBits(-1152921504606846977L);
    }

    @Override
    public boolean isEvicted() {
        return this.areAnyBitsSet(0x2000000000000000L);
    }

    @Override
    public void setEvicted() {
        this.setBits(0x2000000000000000L);
    }

    @Override
    public void unsetEvicted() {
        this.clearBits(-2305843009213693953L);
    }

    @Override
    public void setNext(EvictionNode nextEvictionNode) {
        this.nextEvictionNode = nextEvictionNode;
    }

    @Override
    public EvictionNode next() {
        return this.nextEvictionNode;
    }

    @Override
    public void setPrevious(EvictionNode previousEvictionNode) {
        this.previousEvictionNode = previousEvictionNode;
    }

    @Override
    public EvictionNode previous() {
        return this.previousEvictionNode;
    }

    @Override
    public int getEntrySize() {
        return this.size;
    }

    protected void setEntrySize(int size) {
        this.size = size;
    }

    @Override
    public Object getKeyForSizing() {
        return null;
    }

    @Override
    public int getEntryVersion() {
        return this.entryVersionHighByte << 16 & 0xFF0000 | this.entryVersionLowBytes & 0xFFFF;
    }

    @Override
    public long getRegionVersion() {
        return (long)this.regionVersionHighBytes << 32 | (long)this.regionVersionLowBytes & 0xFFFFFFFFL;
    }

    @Override
    public long getVersionTimeStamp() {
        return this.getLastModified();
    }

    @Override
    public void setVersionTimeStamp(long timeStamp) {
        this.setLastModified(timeStamp);
    }

    @Override
    public VersionSource getMemberID() {
        return this.memberId;
    }

    @Override
    public int getDistributedSystemId() {
        return this.distributedSystemId;
    }

    public void setVersions(VersionTag versionTag) {
        this.memberId = versionTag.getMemberID();
        int eVersion = versionTag.getEntryVersion();
        this.entryVersionLowBytes = (short)(eVersion & 0xFFFF);
        this.entryVersionHighByte = (byte)((eVersion & 0xFF0000) >> 16);
        this.regionVersionHighBytes = versionTag.getRegionVersionHighBytes();
        this.regionVersionLowBytes = versionTag.getRegionVersionLowBytes();
        if (!versionTag.isGatewayTag() && this.distributedSystemId == versionTag.getDistributedSystemId()) {
            if (this.getVersionTimeStamp() <= versionTag.getVersionTimeStamp()) {
                this.setVersionTimeStamp(versionTag.getVersionTimeStamp());
            } else {
                versionTag.setVersionTimeStamp(this.getVersionTimeStamp());
            }
        } else {
            this.setVersionTimeStamp(versionTag.getVersionTimeStamp());
        }
        this.distributedSystemId = (byte)(versionTag.getDistributedSystemId() & 0xFF);
    }

    @Override
    public void setMemberID(VersionSource memberId) {
        this.memberId = memberId;
    }

    @Override
    public VersionStamp getVersionStamp() {
        return this;
    }

    public VersionTag asVersionTag() {
        VersionTag tag = VersionTag.create(this.memberId);
        tag.setEntryVersion(this.getEntryVersion());
        tag.setRegionVersion(this.regionVersionHighBytes, this.regionVersionLowBytes);
        tag.setVersionTimeStamp(this.getVersionTimeStamp());
        tag.setDistributedSystemId(this.distributedSystemId);
        return tag;
    }

    public void processVersionTag(InternalRegion region, VersionTag versionTag, boolean isTombstoneFromGII, boolean hasDelta, VersionSource versionSource, InternalDistributedMember sender, boolean checkForConflicts) {
        this.basicProcessVersionTag(region, versionTag, isTombstoneFromGII, hasDelta, versionSource, sender, checkForConflicts);
    }

    @Override
    public void processVersionTag(EntryEvent cacheEvent) {
        super.processVersionTag(cacheEvent);
    }

    @Override
    public short getRegionVersionHighBytes() {
        return this.regionVersionHighBytes;
    }

    @Override
    public int getRegionVersionLowBytes() {
        return this.regionVersionLowBytes;
    }

    @Override
    public Object getKey() {
        return new UUID(this.keyMostSigBits, this.keyLeastSigBits);
    }

    @Override
    public boolean isKeyEqual(Object key) {
        if (key instanceof UUID) {
            UUID uuid = (UUID)key;
            return uuid.getLeastSignificantBits() == this.keyLeastSigBits && uuid.getMostSignificantBits() == this.keyMostSigBits;
        }
        return false;
    }
}

