/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.data.templates;

import com.sas.commons.rest.links.Link;
import com.sas.framework.commons.util.LocaleUtil;
import com.sas.svcs.template.client.NotificationTemplate;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;

@XmlRootElement(name="template")
public class NotificationTemplateData {
    NotificationTemplate t;
    private String htmlLetterheadName;
    private String txtLetterheadName;
    private List<Link> links;

    public NotificationTemplateData() {
        this.t = new NotificationTemplate();
    }

    public NotificationTemplateData(NotificationTemplate t) {
        this.t = t;
        this.addLink(new Link("GET", "contents", "/content/157/" + t.getId() + "/notificationTemplates"));
    }

    public NotificationTemplateData(String templateId) {
        this.addLink(new Link("GET", "contents", "/content/157/" + templateId + "/notificationTemplates"));
    }

    public String getId() {
        if (this.t != null) {
            return this.t.getId();
        }
        return null;
    }

    public String getName() {
        if (this.t != null) {
            return this.t.getName();
        }
        return null;
    }

    public String getEncoding() {
        if (this.t != null) {
            return this.t.getEncoding();
        }
        return null;
    }

    public String getVersion() {
        if (this.t != null) {
            return this.t.getVersion();
        }
        return null;
    }

    public String getHtmlLetterheadId() {
        if (this.t != null) {
            return this.t.getHtmlLetterheadId();
        }
        return null;
    }

    public String getTxtLetterheadId() {
        if (this.t != null) {
            return this.t.getTxtLetterheadId();
        }
        return null;
    }

    public String getLocale() {
        if (this.t != null && this.t.getLocale() != null) {
            return this.t.getLocale().toString();
        }
        return null;
    }

    public String getContent() {
        if (this.t == null) {
            return null;
        }
        if (this.t.getContentStream() == null) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)this.t.getEncoding())) {
            try {
                return new String(this.t.getContentStream(), this.t.getEncoding());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return new String(this.t.getContentStream());
    }

    public String getHtmlLetterheadName() {
        return this.htmlLetterheadName;
    }

    public String getTxtLetterheadName() {
        return this.txtLetterheadName;
    }

    public void setEncoding(String encoding) {
        this.t.setEncoding(encoding);
    }

    public void setVersion(String version) {
        this.t.setVersion(version);
    }

    public void setHtmlLetterheadId(String id) {
        this.t.setHtmlLetterheadId(id);
    }

    public void setTxtLetterheadId(String id) {
        this.t.setTxtLetterheadId(id);
    }

    public void setLocale(String l) {
        this.t.setLocale(LocaleUtil.getLocaleFromString((String)l));
    }

    public void setId(String id) {
        this.t.setId(id);
    }

    public NotificationTemplate toNotificationTemplate() {
        return this.t;
    }

    public void setContent(String content) {
        if (StringUtils.isNotEmpty((CharSequence)this.t.getEncoding())) {
            try {
                this.t.setContentStream(content.getBytes(this.t.getEncoding()));
            }
            catch (UnsupportedEncodingException e) {
                this.t.setContentStream(content.getBytes());
            }
        } else {
            this.t.setContentStream(content.getBytes());
        }
    }

    public void setName(String name) {
        this.t.setName(name);
    }

    public void setHtmlLetterheadName(String htmlLetterheadName) {
        this.htmlLetterheadName = htmlLetterheadName;
    }

    public void setTxtLetterheadName(String txtLetterheadName) {
        this.txtLetterheadName = txtLetterheadName;
    }

    @XmlElement(name="link")
    public List<Link> getLinks() {
        return this.links;
    }

    public void addLink(Link link) {
        if (this.links == null) {
            this.links = new ArrayList<Link>();
        }
        this.links.add(link);
    }
}

