/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.data.storedprocess;

import com.sas.commons.rest.links.Link;
import com.sas.svcs.content.framework.client.ContentComponent;
import com.sas.svcs.content.framework.client.ContentNode;
import com.sas.svcs.content.storedprocess.client.StoredProcess;
import com.sas.svcs.content.storedprocessreport.client.StoredProcessReport;
import com.sas.svcs.web.data.content.ContentNodeData;
import com.sas.svcs.web.data.storedprocess.StoredProcessExpirationPolicyData;
import com.sas.svcs.web.data.storedprocess.Util;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="storedprocessreport")
public class StoredProcessReportData
extends ContentNodeData {
    StoredProcessReport _storedProcessReport;
    StoredProcessExpirationPolicyData _expirationPolicy;
    List<Link> _links;

    public StoredProcessReportData() {
        this(new StoredProcessReport(), false);
    }

    public StoredProcessReportData(StoredProcessReport storedProcessReport, boolean createLinks) {
        super((ContentNode)storedProcessReport);
        this._storedProcessReport = storedProcessReport;
        this._expirationPolicy = new StoredProcessExpirationPolicyData(storedProcessReport.getExpirationPolicy());
        if (createLinks) {
            ArrayList<Link> linkList = new ArrayList<Link>(1);
            StoredProcess sp = (StoredProcess)storedProcessReport.getStoredProcess().getTarget();
            if (sp != null) {
                Link spLink = new Link("GET", "storedprocess", Util.getUriForContentComponent((ContentComponent)storedProcessReport));
                linkList.add(spLink);
            }
            this.setLinks(linkList);
        }
    }

    public int getMaximumSavedOutput() {
        return this._storedProcessReport.getMaximumSavedOutput();
    }

    public void setMaximumSavedOutput(int maximumSavedOutput) {
        this._storedProcessReport.setMaximumSavedOutput(maximumSavedOutput);
    }

    public StoredProcessExpirationPolicyData getStoredProcessExpirationPolicy() {
        return this._expirationPolicy;
    }

    public void setStoredProcessExpirationPolicy(StoredProcessExpirationPolicyData expirationPolicy) {
        this._expirationPolicy = expirationPolicy;
        this._storedProcessReport.setExpirationPolicy(expirationPolicy._expirationPolicy);
    }

    public StoredProcessReportVersion getVersion() {
        StoredProcessReportVersion retVersion = null;
        StoredProcessReport.Version sprVersion = this._storedProcessReport.getVersion();
        if (sprVersion != null) {
            switch (sprVersion) {
                case V1: {
                    retVersion = StoredProcessReportVersion.V1;
                }
            }
        }
        return retVersion;
    }

    public void setVersion(StoredProcessReportVersion version) {
        StoredProcessReport.Version sprVersion = null;
        switch (version) {
            case V1: {
                sprVersion = StoredProcessReport.Version.V1;
            }
        }
        this._storedProcessReport.setVersion(sprVersion);
    }

    @XmlElementWrapper(name="links")
    @XmlElement(name="link")
    public List<Link> getLinks() {
        return this._links;
    }

    public void setLinks(List<Link> links) {
        this._links = links;
    }

    static enum StoredProcessReportVersion {
        V1;

    }
}

