/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.data.servers;

import com.sas.commons.rest.links.Link;
import com.sas.svcs.common.client.Reference;
import com.sas.svcs.common.client.ReferenceList;
import com.sas.svcs.content.client.util.ContentRESTUtils;
import com.sas.svcs.content.framework.client.ContentComponent;
import com.sas.svcs.content.framework.client.ContentObject;
import com.sas.svcs.resource.platform.serverdata.client.LogicalServer;
import com.sas.svcs.resource.platform.serverdata.client.ServerBase;
import com.sas.svcs.resource.platform.serverdata.client.ServerComponent;
import com.sas.svcs.resource.platform.serverdata.client.ServerContext;
import com.sas.svcs.web.data.content.ContentObjectAttrData;
import com.sas.svcs.web.data.servers.ServerBaseData;
import com.sas.svcs.web.data.servers.ServerComponentData;
import com.sas.svcs.web.data.servers.ServerComponents;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="logicalServer")
public class LogicalServerData
extends ServerBaseData {
    LogicalServer logicalServer;

    public LogicalServerData() {
        this(new LogicalServer());
    }

    public LogicalServerData(LogicalServer logicalServer) {
        super((ServerBase)logicalServer);
        this.logicalServer = logicalServer;
    }

    public LogicalServerData(LogicalServer logicalServer, boolean doFull) {
        super((ServerBase)logicalServer, doFull);
        this.logicalServer = logicalServer;
    }

    @XmlElementWrapper(name="computeTasks")
    @XmlElement(name="contentObject")
    public List<ContentObjectAttrData> getComputeTasks() {
        ArrayList<ContentObjectAttrData> computeDataList = null;
        ReferenceList computeRef = this.logicalServer.getComputeTasks();
        if (computeRef != null && computeRef.getTargetList() != null) {
            computeDataList = new ArrayList<ContentObjectAttrData>();
            ArrayList computeList = (ArrayList)computeRef.getTargetList();
            for (ContentObject co : computeList) {
                computeDataList.add(new ContentObjectAttrData((ContentComponent)co));
            }
        }
        return computeDataList;
    }

    @XmlElement
    public ServerComponents getServerComponents() {
        if (!this.doFull) {
            return null;
        }
        ServerComponents result = null;
        ReferenceList scRef = this.logicalServer.getServerComponents();
        if (scRef != null && scRef.getTargetList() != null) {
            ArrayList<ServerComponentData> scDataList = new ArrayList<ServerComponentData>();
            ArrayList scList = (ArrayList)scRef.getTargetList();
            for (ServerComponent sc : scList) {
                scDataList.add(new ServerComponentData(sc, this.doFull));
            }
            result = new ServerComponents(scDataList);
        }
        return result;
    }

    @XmlAttribute
    public boolean isDefaultInstance() {
        return this.logicalServer.isDefaultInstance();
    }

    @XmlElementWrapper(name="links")
    @XmlElement(name="link")
    public List<Link> getLinks() {
        List<Link> result = this.getLinkList();
        if (this.logicalServer != null) {
            ReferenceList serverComponentRef;
            Reference serverContextRef = this.logicalServer.getServerContext();
            if (serverContextRef != null && serverContextRef.getTarget() != null) {
                Link scLink = new Link("GET", "serverContext", "/content/42/" + ContentRESTUtils.getIdForLink((String)((ServerContext)serverContextRef.getTarget()).getId()));
                result.add(scLink);
            }
            if ((serverComponentRef = this.logicalServer.getServerComponents()) != null && serverComponentRef.getTargetList() != null && ((ArrayList)serverComponentRef.getTargetList()).size() > 0) {
                for (ServerComponent nextServer : (ArrayList)serverComponentRef.getTargetList()) {
                    Link compLink = new Link("GET", "serverComponent", "/content/93/" + ContentRESTUtils.getIdForLink((String)nextServer.getId()));
                    result.add(compLink);
                }
            }
        }
        return result;
    }

    public LogicalServer toLogicalServer() {
        return this.logicalServer;
    }
}

