/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.data.relationships;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sas.svcs.content.relationship.client.Relationship;
import com.sas.svcs.content.relationship.client.RelationshipDirection;
import com.sas.svcs.content.relationship.client.Resource;
import com.sas.svcs.web.data.relationships.RelationshipAttributeData;
import com.sas.svcs.web.data.relationships.RelationshipAttributes;
import com.sas.svcs.web.data.relationships.ResourceData;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="", propOrder={"relationshipType", "direction", "resource", "relationshipAttributes"})
public class RelationshipData {
    protected Relationship rn;
    protected RelationshipAttributes relationshipAttributes;
    protected ResourceData resource;

    public RelationshipData() {
        this.rn = new Relationship();
    }

    public RelationshipData(Relationship relationship) {
        this.rn = relationship;
        this.relationshipAttributes = new RelationshipAttributes(relationship.getAttributeMap());
        this.resource = new ResourceData(relationship.getResource());
    }

    @XmlElement(name="resource", required=true)
    public ResourceData getResource() {
        return new ResourceData(this.rn.getResource());
    }

    @XmlElement
    public String getRelationshipType() {
        return this.rn.getRelationshipType();
    }

    @XmlElement
    public String getDirection() {
        return this.rn.getDirection().toString();
    }

    @JsonIgnore
    public void setResource(Resource resource) {
        this.rn.setResource(resource);
        this.resource = new ResourceData(resource);
    }

    @JsonProperty(value="resource")
    public void setResource(ResourceData resourceData) {
        this.rn.setResource(resourceData.toResource());
        this.resource = resourceData;
    }

    @JsonIgnore
    public void setDirection(RelationshipDirection direction) {
        this.rn.setDirection(direction);
    }

    @JsonProperty(value="direction")
    public void setDirection(String direction) {
        if (direction.equals(RelationshipDirection.TO.toString())) {
            this.rn.setDirection(RelationshipDirection.TO);
        } else if (direction.equals(RelationshipDirection.FROM.toString())) {
            this.rn.setDirection(RelationshipDirection.FROM);
        } else if (direction.equals(RelationshipDirection.BOTH.toString())) {
            this.rn.setDirection(RelationshipDirection.BOTH);
        }
    }

    public void setRelationshipType(String relationshipType) {
        this.rn.setRelationshipType(relationshipType);
    }

    @XmlElement(name="properties")
    public RelationshipAttributes getRelationshipAttributes() {
        return this.relationshipAttributes;
    }

    public void setRelationshipAttributes(RelationshipAttributes relationshipAttributes) {
        if (relationshipAttributes != null) {
            this.relationshipAttributes = relationshipAttributes;
            List<RelationshipAttributeData> attrL = relationshipAttributes.getAttributes();
            for (RelationshipAttributeData attrData : attrL) {
                this.rn.setAttribute(attrData.getName(), attrData.getValue());
            }
        }
    }

    public Relationship toRelationshipNode() {
        return this.rn;
    }
}

