/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.data.identity;

import com.sas.commons.rest.links.Link;
import com.sas.svcs.content.client.util.ContentRESTUtils;
import com.sas.svcs.resource.platform.identity.client.Identity;
import com.sas.svcs.resource.platform.identity.client.Role;
import com.sas.svcs.web.data.identity.ContributingRoles;
import com.sas.svcs.web.data.identity.IdentityData;
import com.sas.svcs.web.data.identity.Members;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="role")
public class RoleData
extends IdentityData {
    public RoleData() {
        this(new Role());
    }

    public RoleData(Role role) {
        super((Identity)role);
    }

    @XmlElement
    public Members getMembers() {
        Members result = null;
        List memberList = this.toRole().getMembers();
        if (memberList != null) {
            ArrayList<IdentityData> identityDataList = new ArrayList<IdentityData>();
            for (Identity identity : memberList) {
                identityDataList.add(new IdentityData(identity));
            }
            result = new Members(identityDataList);
        }
        return result;
    }

    public void setMembers(Members members) {
        Collection<IdentityData> identityDataList = members.getMembers();
        if (members == null || identityDataList == null) {
            return;
        }
        ArrayList<Identity> identityList = new ArrayList<Identity>(identityDataList.size());
        for (IdentityData identityData : identityDataList) {
            identityList.add(identityData.toIdentity());
        }
        this.toRole().setMembers(identityList);
    }

    @XmlElement
    public ContributingRoles getContributingRoles() {
        ContributingRoles result = null;
        List roleList = this.toRole().getContributingRoles();
        if (roleList != null) {
            ArrayList<RoleData> roleDataList = new ArrayList<RoleData>();
            for (Role role : roleList) {
                roleDataList.add(new RoleData(role));
            }
            result = new ContributingRoles(roleDataList);
        }
        return result;
    }

    public void setContributingRoles(ContributingRoles contributingRoles) {
        Collection<RoleData> roleDataList = contributingRoles.getContributingRoles();
        if (contributingRoles == null || roleDataList == null) {
            return;
        }
        ArrayList<Role> roleList = new ArrayList<Role>(roleDataList.size());
        for (RoleData roleData : roleDataList) {
            roleList.add(roleData.toRole());
        }
        this.toRole().setContributingRoles(roleList);
    }

    @XmlElement(name="link")
    public List<Link> getLinks() {
        ArrayList<Link> result = null;
        Link lsLink = null;
        if (this.toRole() != null) {
            if (this.toRole().getMembers() == null) {
                if (result == null) {
                    result = new ArrayList<Link>();
                }
                lsLink = new Link("GET", "members", "/identity/148/" + ContentRESTUtils.getIdForLink((String)this.toRole().getId()) + "/members");
                result.add(lsLink);
            }
            if (this.toRole().getContributingRoles() == null) {
                if (result == null) {
                    result = new ArrayList();
                }
                lsLink = new Link("GET", "contributing-roles", "/identity/148/" + ContentRESTUtils.getIdForLink((String)this.toRole().getId()) + "/contributing-roles");
                result.add(lsLink);
            }
        }
        return result;
    }

    public Role toRole() {
        return (Role)this.toContentComponent();
    }
}

