/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.data.dataintegration;

import com.sas.commons.rest.links.Link;
import com.sas.commons.rest.util.Properties;
import com.sas.svcs.common.client.ChildReferenceList;
import com.sas.svcs.content.client.util.ContentRESTUtils;
import com.sas.svcs.content.framework.client.ContentNode;
import com.sas.svcs.content.platform.di.client.Column;
import com.sas.svcs.content.platform.di.client.Table;
import com.sas.svcs.web.data.content.ContentNodeData;
import com.sas.svcs.web.data.dataintegration.ColumnData;
import com.sas.svcs.web.data.dataintegration.Columns;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="table")
public class TableData
extends ContentNodeData {
    Table table;

    public TableData() {
        this(new Table());
    }

    public TableData(Table table) {
        super((ContentNode)table);
        this.table = table;
    }

    @XmlElement(name="columns")
    public Columns getColumns() {
        ChildReferenceList columns = this.table.getColumns();
        if (!columns.isPopulated()) {
            return null;
        }
        ArrayList<ColumnData> columnDatas = new ArrayList<ColumnData>();
        if (columns.getTargetList() != null) {
            ArrayList columnList = (ArrayList)columns.getTargetList();
            for (Column column : columnList) {
                columnDatas.add(new ColumnData(column));
            }
        }
        return new Columns(columnDatas);
    }

    @XmlElement
    public String getDbmsType() {
        return this.table.getDbmsType();
    }

    @XmlElement
    public Properties getExtendedAttributes() {
        if (this.table.getExtendedAttributes() != null) {
            ArrayList<Properties.Property> propertyList = new ArrayList<Properties.Property>();
            for (Map.Entry<Object, Object> nextEntry : this.table.getExtendedAttributes().entrySet()) {
                propertyList.add(new Properties.Property((String)nextEntry.getKey(), (String)nextEntry.getValue()));
            }
            return new Properties(propertyList);
        }
        return null;
    }

    @XmlElement
    public String getMemberType() {
        return this.table.getMemberType();
    }

    @XmlElement
    public List<String> getNotes() {
        return this.table.getNotes();
    }

    @XmlElement
    public double getNumRows() {
        return this.table.getNumRows();
    }

    @XmlElement
    public String getSasTableName() {
        return this.table.getSasTableName();
    }

    @XmlElement
    public String getTableName() {
        return this.table.getTableName();
    }

    @XmlElement
    public boolean isCaseSensitiveNames() {
        return this.table.isCaseSensitiveNames();
    }

    @XmlElement
    public boolean isCompressed() {
        return this.table.isCompressed();
    }

    @XmlElement
    public boolean isDBMSView() {
        return this.table.isDBMSView();
    }

    @XmlElement
    public boolean isEncrypted() {
        return this.table.isEncrypted();
    }

    @XmlElement
    public boolean isSpecialCharacterNames() {
        return this.table.isSpecialCharacterNames();
    }

    @XmlElement(name="link")
    public List<Link> getLinks() {
        ArrayList<Link> links = new ArrayList<Link>(2);
        links.add(new Link("GET", "get-library", "/content/32/" + ContentRESTUtils.getIdForLink((String)this.getId()) + "/library"));
        links.add(new Link("GET", "get-columns", "/content/32/" + ContentRESTUtils.getIdForLink((String)this.getId()) + "/columns"));
        links.add(new Link("GET", "library", "/content/tables/" + ContentRESTUtils.getIdForLink((String)this.getId()) + "/library"));
        return links;
    }

    public Table toTable() {
        return this.table;
    }
}

