/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.data.content;

import com.sas.svcs.web.data.content.ContentRelationship;
import com.sas.svcs.web.data.content.ValidationProperty;
import com.sas.svcs.web.data.content.ValidationPropertyType;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="validationRequest")
public class ValidationRequest {
    private int version = 1;
    private long objectType;
    private List<ValidationProperty> properties;
    private List<ContentRelationship> relationships;

    public ValidationRequest() {
        this.relationships = new ArrayList<ContentRelationship>();
        this.properties = new ArrayList<ValidationProperty>();
    }

    public ValidationRequest(long objectType, List<ValidationProperty> properties, List<ContentRelationship> relationships) {
        this.objectType = objectType;
        this.properties = properties;
        this.relationships = relationships;
    }

    public long getObjectType() {
        return this.objectType;
    }

    public void setObjectType(long objectType) {
        this.objectType = objectType;
    }

    @XmlElementWrapper(name="relationships")
    @XmlElement(name="relationship")
    public List<ContentRelationship> getRelationships() {
        return this.relationships;
    }

    public ContentRelationship getRelationship(String rel) {
        if (this.relationships != null) {
            for (ContentRelationship relationship : this.relationships) {
                if (!rel.equalsIgnoreCase(relationship.getRel())) continue;
                return relationship;
            }
        }
        return null;
    }

    public void setRelationships(List<ContentRelationship> relationships) {
        this.relationships = relationships;
    }

    @XmlElementWrapper(name="properties")
    @XmlElement(name="property")
    public List<ValidationProperty> getProperties() {
        return this.properties;
    }

    public ValidationProperty getProperty(String name, ValidationPropertyType type) {
        if (this.properties != null) {
            for (ValidationProperty property : this.properties) {
                if (!name.equalsIgnoreCase(property.getName()) || type != property.getType()) continue;
                return property;
            }
        }
        return null;
    }

    public void setProperties(List<ValidationProperty> properties) {
        this.properties = properties;
    }

    @XmlAttribute
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }
}

