/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.data.content;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.sas.svcs.web.data.content.ValidationProperty;
import com.sas.svcs.web.data.content.ValidationPropertyType;
import java.io.IOException;

public class ValidationPropertyDeserializer
extends JsonDeserializer<ValidationProperty> {
    public ValidationProperty deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        ObjectCodec oc = parser.getCodec();
        JsonNode node = (JsonNode)oc.readTree(parser);
        String value = null;
        JsonNode valueNode = node.get("value");
        String typeString = node.get("type").textValue();
        ValidationPropertyType type = ValidationPropertyType.fromString(typeString);
        if (type != null) {
            switch (type) {
                case INTEGER: {
                    value = String.valueOf(valueNode.asLong());
                    break;
                }
                case DECIMAL: {
                    value = String.valueOf(valueNode.asDouble());
                    break;
                }
                case BOOLEAN: {
                    value = String.valueOf(valueNode.asBoolean());
                    break;
                }
                default: {
                    value = valueNode.textValue();
                }
            }
        }
        String name = node.get("name").textValue();
        return new ValidationProperty(name, value, type);
    }
}

