/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest.util;

import com.sas.svcs.labeledentity.client.Label;
import com.sas.svcs.labeledentity.client.LabeledEntity;
import com.sas.svcs.web.data.authorization.AuthorizationLabel;
import com.sas.svcs.web.data.authorization.AuthorizationLabels;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class AuthorizationUtil {
    public static final String WIP_ADMIN_GROUP = "GROUP_SASAdministrators";
    public static final String REQUIRE_ADMIN_USER_ROLE_FLAG = "sas.endpoints.require.adminpriv";
    public static final String IDENTITIES_ENDPOINT = "identities";
    public static final String CONTENT_SERVERS_ENDPOINT = "contentservers";

    public static AuthorizationLabels restLabelsForLabeledEntities(LabeledEntity le) {
        if (null == le) {
            return null;
        }
        Collection leLabels = le.getLabels().values();
        ArrayList<AuthorizationLabel> labels = new ArrayList<AuthorizationLabel>(leLabels.size());
        for (Label leLabel : leLabels) {
            labels.add(new AuthorizationLabel(leLabel.getLocale().toString(), leLabel.getValue()));
        }
        return new AuthorizationLabels(labels);
    }

    public static Locale localeFromString(String locale) {
        if (null == locale) {
            return null;
        }
        String[] parts = locale.split("_");
        Locale loc = null;
        if (parts.length == 3) {
            loc = new Locale(parts[0], parts[1], parts[2]);
        } else if (parts.length == 2) {
            loc = new Locale(parts[0], parts[1]);
        } else if (parts.length == 1) {
            loc = new Locale(parts[0]);
        } else {
            throw new IllegalArgumentException("Locale '" + locale + "' could not be converted to a valid locale");
        }
        return loc;
    }

    public static Map<Locale, Label> labelsForRestLabel(AuthorizationLabels authorizationLabels) {
        if (null == authorizationLabels) {
            return Collections.emptyMap();
        }
        List<AuthorizationLabel> labelList = authorizationLabels.labels;
        HashMap<Locale, Label> labels = new HashMap<Locale, Label>(labelList.size());
        for (AuthorizationLabel pl : labelList) {
            Locale loc = AuthorizationUtil.localeFromString(pl.locale);
            labels.put(loc, new Label(loc, pl.value));
        }
        return labels;
    }

    public static boolean isUserAuthorizedForEndpoint(String endpoint) {
        if (AuthorizationUtil.isAuthorizationRequired(endpoint)) {
            return AuthorizationUtil.hasAuthority(AuthorizationUtil.getAuthentication(), WIP_ADMIN_GROUP);
        }
        return true;
    }

    public static boolean isUserIdCurrentUser(String userId) {
        String currentUserId = SecurityContextHolder.getContext().getAuthentication().getName();
        return userId.equals(currentUserId);
    }

    private static Authentication getAuthentication() throws RuntimeException {
        try {
            return SecurityContextHolder.getContext().getAuthentication();
        }
        catch (Exception e) {
            throw new RuntimeException("Error obtaining authentication details. Unable to verify user access to endpoint.");
        }
    }

    private static boolean hasAuthority(Authentication authentication, String auth) {
        for (GrantedAuthority authority : authentication.getAuthorities()) {
            if (!auth.equals(authority.getAuthority())) continue;
            return true;
        }
        return false;
    }

    private static boolean isAuthorizationRequired(String endpoint) {
        String authRequiredEndpointList = AuthorizationUtil.getSystemProperty(REQUIRE_ADMIN_USER_ROLE_FLAG);
        if (null == authRequiredEndpointList || authRequiredEndpointList.isEmpty()) {
            return false;
        }
        List<String> endpoints = AuthorizationUtil.getEndpointsAsArray(authRequiredEndpointList);
        return endpoints.contains(endpoint);
    }

    private static List<String> getEndpointsAsArray(String endpoints) {
        List<Object> returnList = new ArrayList<String>();
        if (!endpoints.contains(",")) {
            returnList.add(endpoints);
        } else {
            returnList = Arrays.asList(endpoints.split("\\s*,\\s*"));
        }
        returnList.replaceAll(String::trim);
        return returnList;
    }

    private static String getSystemProperty(String name) {
        String result = null;
        try {
            result = System.getProperty(name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return result;
    }
}

