/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest.content;

import com.sas.commons.rest.spring.ErrorResponseFactory;
import com.sas.svcs.content.lifecycle.client.ContentValidationService;
import com.sas.svcs.web.controllers.rest.content.AbstractContentLifecycleController;
import com.sas.svcs.web.controllers.rest.content.NameValidation;
import com.sas.svcs.web.controllers.rest.content.ValidationMethod;
import com.sas.svcs.web.data.content.ValidationProperty;
import com.sas.svcs.web.data.content.ValidationPropertyType;
import com.sas.svcs.web.data.content.ValidationRequest;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/content"})
public class DefaultContentLifecycleController
extends AbstractContentLifecycleController {
    private ContentValidationService validationService;
    private static final String FOLDER_LIST = "28|79|29|75|105";
    private static final String FOLDER_LIST_NOT_IN = "^(?:(?!28|79|29|75|105).)*$";

    @Autowired
    public void setContentValidationService(ContentValidationService validationService) {
        this.validationService = validationService;
    }

    @RequestMapping(value={"/validations"}, method={RequestMethod.POST}, consumes={"application/vnd.sas.content.validation.request+xml", "application/vnd.sas.content.validation.request+json"}, produces={"application/vnd.sas.content.validation+xml", "application/vnd.sas.content.validation+json"})
    @ResponseBody
    public ResponseEntity<?> validate(@RequestBody ValidationRequest request, @RequestHeader(value="Accept-Language", required=false) String language) {
        ValidationMethod method = this.getValidationMethod(request);
        if (method == null) {
            return ErrorResponseFactory.newResponseEntity((HttpStatus)HttpStatus.BAD_REQUEST, (String)"Invalid validation request structure", null);
        }
        return method.submitValidation(request, language);
    }

    private ValidationMethod getValidationMethod(ValidationRequest request) {
        NameValidation method = null;
        long objectType = request.getObjectType();
        ValidationProperty property = request.getProperty("name", ValidationPropertyType.STRING);
        if (property != null && objectType != 0L) {
            method = new NameValidation(this.validationService);
        }
        return method;
    }

    @Override
    @RequestMapping(value={"/{objectTypeId:^(?:(?!28|79|29|75|105).)*$}/{objectId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<?> deleteObject(@PathVariable long objectTypeId, @PathVariable String objectId, Locale locale) {
        return super.deleteObject(objectTypeId, objectId, locale);
    }
}

