/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest;

import com.sas.svcs.identifiers.client.ActionTypeIdentifierServiceInterface;
import com.sas.svcs.notifications.client.AlertNotificationType;
import com.sas.svcs.notifications.client.AlertNotificationTypesServiceInterface;
import com.sas.svcs.web.data.types.ActionTypes;
import com.sas.svcs.web.data.types.NotificationTypes;
import com.sas.svcs.web.data.types.Type;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class TypesController {
    AlertNotificationTypesServiceInterface notificationTypes;
    ActionTypeIdentifierServiceInterface actionTypes;

    @Autowired
    public void setNotificationTypes(AlertNotificationTypesServiceInterface notificationTypes) {
        this.notificationTypes = notificationTypes;
    }

    @Autowired
    public void setActionTypes(ActionTypeIdentifierServiceInterface actionTypes) {
        this.actionTypes = actionTypes;
    }

    @RequestMapping(value={"/types/notifications"}, method={RequestMethod.GET})
    @ResponseBody
    public NotificationTypes getNotificationTypes() {
        List alertNotificationTypes = this.notificationTypes.getAlertNotificationTypes();
        ArrayList<Type> notificationTypeList = new ArrayList<Type>();
        for (AlertNotificationType notificationType : alertNotificationTypes) {
            notificationTypeList.add(new Type(notificationType.getId(), notificationType.getName()));
        }
        return new NotificationTypes(notificationTypeList);
    }

    @RequestMapping(value={"/types/actions"}, method={RequestMethod.GET})
    @ResponseBody
    public ActionTypes getActionTypes() {
        List actionTypeNameList = this.actionTypes.getTypeNames();
        ArrayList<Type> actionTypeList = new ArrayList<Type>();
        for (String name : actionTypeNameList) {
            long id = this.actionTypes.getTypeIdentifier(name);
            actionTypeList.add(new Type(id, name));
        }
        return new ActionTypes(actionTypeList);
    }
}

