/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest;

import com.sas.svcs.common.client.ChildReferenceList;
import com.sas.svcs.common.client.ObjectIdentityUtils;
import com.sas.svcs.common.client.Reference;
import com.sas.svcs.commons.Identifiable;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.client.util.ContentRESTUtils;
import com.sas.svcs.content.platform.di.client.Column;
import com.sas.svcs.content.platform.di.client.Library;
import com.sas.svcs.content.platform.di.client.Table;
import com.sas.svcs.content.platform.di.client.TableService;
import com.sas.svcs.web.controllers.rest.content.AbstractContentLifecycleController;
import com.sas.svcs.web.controllers.rest.util.RegistryUtil;
import com.sas.svcs.web.data.dataintegration.ColumnData;
import com.sas.svcs.web.data.dataintegration.Columns;
import com.sas.svcs.web.data.dataintegration.LibraryData;
import com.sas.svcs.web.data.dataintegration.TableData;
import com.sas.svcs.web.data.dataintegration.Tables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class TableController
extends AbstractContentLifecycleController {
    private TableService tableService;
    private RegistryUtil registryUtil;

    @Autowired
    public void setTableService(TableService tableService) {
        this.tableService = tableService;
    }

    @Autowired
    public void setRegistryUtil(RegistryUtil registryUtil) {
        this.registryUtil = registryUtil;
    }

    @RequestMapping(value={"/content/32/{objectId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<TableData> getTable(@PathVariable String objectId) {
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        Table table = this.tableService.getTableById(new ObjectIdentity(32L, id));
        if (table == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)new TableData(table), HttpStatus.OK);
    }

    @RequestMapping(value={"/content/32/{objectId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<?> deleteTable(@PathVariable String objectId, Locale locale) {
        return this.deleteObject(32L, objectId, locale);
    }

    @RequestMapping(value={"/content/32"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Tables> getTables(@RequestParam(value="id", required=false) List<String> ids) {
        ArrayList<Table> tables;
        if (ids == null) {
            tables = this.tableService.getAllTables();
        } else {
            tables = new ArrayList<Table>(ids.size());
            for (String id : ids) {
                Table table = this.tableService.getTableDescriptor(new ObjectIdentity(32L, ContentRESTUtils.getIdFromLink((String)id)));
                if (table == null) continue;
                tables.add(table);
            }
        }
        ArrayList<TableData> tableDatas = new ArrayList<TableData>(tables.size());
        for (Table table : tables) {
            tableDatas.add(new TableData(table));
        }
        return new ResponseEntity((Object)new Tables(tableDatas), HttpStatus.OK);
    }

    @RequestMapping(value={"/content/32/{objectId}/library"}, method={RequestMethod.GET})
    public void getLibraryReference(@PathVariable String objectId, HttpServletResponse response) throws IOException {
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        Table table = this.tableService.getTableById(new ObjectIdentity(32L, id));
        if (table == null) {
            response.setStatus(404);
            return;
        }
        Reference libraryRef = table.getLibrary();
        if (libraryRef.getTarget() == null) {
            response.sendError(404, "UnsetReference");
            return;
        }
        Library lib = (Library)libraryRef.getTarget();
        String redirUrl = this.registryUtil.getRestUrl(ObjectIdentityUtils.createObjectIdentity((Identifiable)lib));
        response.setHeader("Location", redirUrl);
        response.setStatus(303);
    }

    @RequestMapping(value={"/content/tables/{objectId}/library"}, method={RequestMethod.GET})
    public ResponseEntity<LibraryData> getAssociatedLibrary(@PathVariable String objectId) {
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        Table table = this.tableService.getTableById(new ObjectIdentity(32L, id));
        if (table == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        Reference libraryRef = table.getLibrary();
        if (libraryRef.getTarget() == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        Library library = (Library)libraryRef.getTarget();
        return new ResponseEntity((Object)new LibraryData(library), HttpStatus.OK);
    }

    @RequestMapping(value={"/content/32/{objectId}/columns"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Columns> getColumns(@PathVariable String objectId) {
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        Table table = this.tableService.getTableById(new ObjectIdentity(32L, id));
        if (table == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        ChildReferenceList columnsRef = table.getColumns();
        List columns = (List)columnsRef.getTargetList();
        if (columns == null) {
            return new ResponseEntity((Object)new Columns(new ArrayList<ColumnData>(0)), HttpStatus.OK);
        }
        ArrayList<ColumnData> columnDatas = new ArrayList<ColumnData>(columns.size());
        for (Column column : columns) {
            columnDatas.add(new ColumnData(column));
        }
        return new ResponseEntity((Object)new Columns(columnDatas), HttpStatus.OK);
    }
}

