/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest;

import com.sas.svcs.config.client.UrlGeneratorInterface;
import com.sas.svcs.notifications.client.AlertNotification;
import com.sas.svcs.notifications.client.AlertNotificationRetrievalServiceInterface;
import com.sas.svcs.web.controllers.rest.AbstractUserController;
import com.sas.svcs.web.data.notifications.Notifications;
import java.util.ArrayList;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class NotificationsController
extends AbstractUserController {
    AlertNotificationRetrievalServiceInterface notifications;
    UrlGeneratorInterface urlGenerator;

    @Autowired
    public void setUrlGenerator(UrlGeneratorInterface urlGenerator) {
        this.urlGenerator = urlGenerator;
    }

    @Autowired
    public void setNotifications(AlertNotificationRetrievalServiceInterface notifications) {
        this.notifications = notifications;
    }

    @RequestMapping(value={"/users/{userid}/notifications"}, method={RequestMethod.GET})
    @ResponseBody
    public Notifications getNotifications(@PathVariable String userid, @RequestParam(required=false) String types) {
        ArrayList<AlertNotification> value;
        this.checkUser(userid);
        if (null == types) {
            value = this.notifications.getNotifications(userid);
        } else {
            String[] typeArray;
            value = new ArrayList();
            for (String type : typeArray = types.split(",")) {
                value.addAll(this.notifications.getNotifications(userid, Short.parseShort(type)));
            }
        }
        return new Notifications(value, userid, this.urlGenerator.generateExternalUrl("Logon Manager 9.4", "Director", new Properties()));
    }

    @RequestMapping(value={"/users/{userid}/notifications"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<String> deleteNotifications(@PathVariable String userid) {
        this.checkUser(userid);
        this.notifications.deleteByUser(userid);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/users/{userid}/notifications/{notificationId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<String> deleteNotifications(@PathVariable String userid, @PathVariable long notificationId) {
        this.checkUser(userid);
        if (!this.notifications.exists(notificationId)) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        this.notifications.delete(notificationId);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }
}

