/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest;

import com.sas.svcs.content.framework.client.ObjectExistsException;
import com.sas.svcs.content.framework.client.ObjectNotFoundException;
import com.sas.svcs.template.client.NotificationContent;
import com.sas.svcs.template.client.NotificationLetterhead;
import com.sas.svcs.template.client.NotificationLetterheadService;
import com.sas.svcs.web.data.templates.NotificationLetterheadData;
import com.sas.svcs.web.data.templates.NotificationLetterheads;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class NotificationLetterheadsController {
    private static final Logger logger = LogManager.getLogger(NotificationLetterheadsController.class);
    private NotificationLetterheadService notificationLetterheadService;

    @Autowired
    public void setNotificationLetterheadService(NotificationLetterheadService n) {
        this.notificationLetterheadService = n;
    }

    @RequestMapping(value={"/content/notificationLetterheads"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<NotificationLetterheads> createLetterheadDefault(@RequestBody NotificationLetterheads letterheads) {
        return this.createLetterheadAndReturnDetails(letterheads);
    }

    @RequestMapping(value={"/content/notificationLetterheads"}, method={RequestMethod.POST}, headers={"accept=application/vnd.sas.notification.letterheads.details+xml"})
    @ResponseBody
    public ResponseEntity<NotificationLetterheads> createLetterheadAndReturnDetails(@RequestBody NotificationLetterheads letterheads) {
        logger.debug("Calling create letterheads in details method");
        List<NotificationLetterheadData> letterheadDataList = letterheads.getNotificationLetterheadList();
        ArrayList<NotificationLetterheadData> newLetterheadList = new ArrayList<NotificationLetterheadData>();
        for (NotificationLetterheadData letterheadData : letterheadDataList) {
            try {
                NotificationLetterhead letterhead = this.create(letterheadData);
                if (letterhead == null) continue;
                newLetterheadList.add(new NotificationLetterheadData(letterhead));
            }
            catch (Exception e) {
                logger.error("Error while trying to create " + letterheadData.getName() + " in locale " + letterheadData.getLocale() + e.getMessage());
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        NotificationLetterheads l = new NotificationLetterheads(newLetterheadList);
        return new ResponseEntity((Object)l, HttpStatus.CREATED);
    }

    @RequestMapping(value={"/content/notificationLetterheads"}, method={RequestMethod.POST}, headers={"accept=application/vnd.sas.notification.letterheads+xml"})
    @ResponseBody
    public ResponseEntity<NotificationLetterheads> createLetterheads(@RequestBody NotificationLetterheads letterheads) {
        logger.debug("Calling create letterheads");
        List<NotificationLetterheadData> letterheadDataList = letterheads.getNotificationLetterheadList();
        ArrayList<NotificationLetterheadData> newLetterheadList = new ArrayList<NotificationLetterheadData>();
        for (NotificationLetterheadData letterheadData : letterheadDataList) {
            try {
                NotificationLetterhead letterhead = this.create(letterheadData);
                if (letterhead == null) continue;
                newLetterheadList.add(new NotificationLetterheadData(letterhead.getId()));
            }
            catch (Exception e) {
                logger.error("Error while trying to create " + letterheadData.getName() + " in locale " + letterheadData.getLocale() + e.getMessage());
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        NotificationLetterheads l = new NotificationLetterheads(newLetterheadList);
        return new ResponseEntity((Object)l, HttpStatus.CREATED);
    }

    private NotificationLetterhead create(NotificationLetterheadData letterheadData) throws Exception {
        NotificationLetterhead letterhead = null;
        NotificationLetterhead l = letterheadData.toNotificationLetterhead();
        try {
            letterhead = (NotificationLetterhead)this.notificationLetterheadService.create((NotificationContent)l);
        }
        catch (ObjectExistsException e) {
            logger.info("Letterhead " + l.getName() + " already exists");
        }
        return letterhead;
    }

    @RequestMapping(value={"/content/notificationLetterhead/{locale}/{letterheadName}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<NotificationLetterheads> getLetterhead(@PathVariable Locale locale, @PathVariable String letterheadName) {
        logger.debug("Getting letterhead");
        ArrayList<NotificationLetterheadData> list = new ArrayList<NotificationLetterheadData>();
        try {
            NotificationLetterhead l = (NotificationLetterhead)this.notificationLetterheadService.getTemplate(letterheadName, locale);
            if (l != null) {
                list.add(new NotificationLetterheadData(l));
            }
        }
        catch (ObjectNotFoundException e) {
            logger.error("Error while trying to get '" + letterheadName + "' in locale " + locale + e.getMessage());
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)new NotificationLetterheads(list), HttpStatus.OK);
    }
}

