/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest;

import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.client.util.ContentRESTUtils;
import com.sas.svcs.content.framework.client.ContentObject;
import com.sas.svcs.content.framework.client.ObjectNotFoundException;
import com.sas.svcs.content.streaming.client.StreamService;
import com.sas.svcs.content.transport.client.ExportPackage;
import com.sas.svcs.content.transport.client.ExportPackageService;
import com.sas.svcs.web.data.exportpackage.ExportPackageData;
import com.sas.svcs.web.data.exportpackage.ExportPackages;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ExportPackageController {
    private ExportPackageService exportPackageService;
    private StreamService streamService;

    @Autowired
    public void setExportPackageService(ExportPackageService exportPackageService) {
        this.exportPackageService = exportPackageService;
    }

    @Autowired
    public void setStreamService(StreamService streamService) {
        this.streamService = streamService;
    }

    @RequestMapping(value={"/content/159/"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<ExportPackages> getExportPackages() {
        ArrayList<ExportPackageData> packageDataList = new ArrayList<ExportPackageData>();
        List packageList = this.exportPackageService.getPackages();
        for (ExportPackage nextPackage : packageList) {
            packageDataList.add(new ExportPackageData(nextPackage));
        }
        return new ResponseEntity((Object)new ExportPackages(packageDataList), HttpStatus.OK);
    }

    @RequestMapping(value={"/content/159/{objectId}"}, method={RequestMethod.GET}, headers={"accept=application/zip"})
    public void getPackageZip(HttpServletRequest request, HttpServletResponse response, @PathVariable String objectId) {
        ObjectIdentity identity = new ObjectIdentity(159L, ContentRESTUtils.getIdFromLink((String)objectId));
        ExportPackage thePackage = this.exportPackageService.getPackageById(identity);
        if (thePackage == null) {
            response.setStatus(404);
            return;
        }
        response.setContentType("application/zip");
        response.setHeader("Content-Disposition", "attachemnt; filename=" + thePackage.getName() + ".zip");
        try {
            ServletOutputStream outputStream = response.getOutputStream();
            this.streamService.getStreamContents((ContentObject)thePackage, (OutputStream)outputStream);
            outputStream.close();
        }
        catch (IOException ex) {
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"/content/159/{objectId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<ExportPackageData> getExportPackage(@PathVariable String objectId, HttpServletRequest request) {
        ObjectIdentity identity = new ObjectIdentity(159L, ContentRESTUtils.getIdFromLink((String)objectId));
        ExportPackage thePackage = this.exportPackageService.getPackageById(identity);
        if (thePackage == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)new ExportPackageData(thePackage), HttpStatus.OK);
    }

    @RequestMapping(value={"/content/159/{objectId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<String> deleteExportPackage(@PathVariable String objectId, HttpServletRequest request) {
        ObjectIdentity identity = new ObjectIdentity(159L, ContentRESTUtils.getIdFromLink((String)objectId));
        ExportPackage thePackage = this.exportPackageService.getPackageById(identity);
        if (thePackage == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        try {
            this.exportPackageService.delete(thePackage);
        }
        catch (ObjectNotFoundException ex) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }
}

