/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest;

import com.sas.svcs.alerts.client.Alert;
import com.sas.svcs.alerts.client.AlertCondition;
import com.sas.svcs.alerts.client.AlertsServiceInterface;
import com.sas.svcs.web.controllers.rest.AbstractUserController;
import com.sas.svcs.web.data.alerts.AlertData;
import com.sas.svcs.web.data.alerts.Alerts;
import com.sas.svcs.web.data.alerts.ContentAlertData;
import com.sas.svcs.web.data.alerts.ContentAlerts;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AlertsController
extends AbstractUserController {
    AlertsServiceInterface alertService;

    @Autowired
    public void setAlertService(AlertsServiceInterface alertService) {
        this.alertService = alertService;
    }

    @RequestMapping(value={"/users/{userid}/alerts"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Alerts> getAlertRegistrations(@PathVariable String userid) {
        this.checkUser(userid);
        List subscribedAlerts = this.alertService.getSubscribedAlerts(userid);
        return new ResponseEntity((Object)new Alerts(subscribedAlerts), HttpStatus.OK);
    }

    @RequestMapping(value={"/users/{userid}/alerts/{alertId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<AlertData> getAlert(@PathVariable String userid, @PathVariable long alertId) {
        this.checkUser(userid);
        Alert alert = this.alertService.getById(alertId);
        if (alert == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)new AlertData(alert), HttpStatus.OK);
    }

    @RequestMapping(value={"/users/{userid}/alerts"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<String> registerAlerts(@PathVariable String userid, @RequestBody Alerts alerts) {
        long alertid = -1L;
        this.checkUser(userid);
        StringBuilder sb = new StringBuilder();
        for (AlertData alertData : alerts.getAlerts()) {
            Alert alert = alertData.getAlert();
            alert.setSubscriber(userid);
            alertid = this.alertService.register(alert);
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("" + alertid);
        }
        return new ResponseEntity((Object)sb.toString(), HttpStatus.CREATED);
    }

    @RequestMapping(value={"/users/{userid}/alerts/{alertId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<String> deleteAlertRegistration(@PathVariable String userid, @PathVariable long alertId) {
        this.checkUser(userid);
        if (!this.alertService.exists(alertId)) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        this.alertService.delete(alertId);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/content/{objectTypeId}/{objectId}/alerts"}, method={RequestMethod.GET})
    @ResponseBody
    public ContentAlerts getContentObjectAlertRegistrations(@PathVariable long objectTypeId, @PathVariable String objectId) {
        String userid = this.getUserid();
        List alerts = this.alertService.findWithConditions(userid, this.getContentObjectConditions(objectTypeId, objectId));
        return new ContentAlerts(alerts);
    }

    @RequestMapping(value={"/content/{objectTypeId}/{objectId}/alerts"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<ContentAlerts> createContentObjectAlertRegistrations(@PathVariable long objectTypeId, @PathVariable String objectId, @RequestBody ContentAlerts alerts) {
        String userid = this.getUserid();
        AlertCondition[] conditions = this.getContentObjectConditions(objectTypeId, objectId);
        for (ContentAlertData contentAlert : alerts.getAlerts()) {
            Alert a = new Alert();
            a.setEventName(contentAlert.getEventName());
            a.setName(contentAlert.getName());
            a.setTargetDirective(contentAlert.getDirective());
            a.setTargetParms(contentAlert.getParameters());
            a.setDeliveryTypeFlags(contentAlert.getDeliveryType());
            a.setSubscriberType((short)0);
            a.setSubscriber(userid);
            a.setActive(true);
            a.setConditions(Arrays.asList(conditions));
            this.alertService.register(a);
        }
        return new ResponseEntity((Object)this.getContentObjectAlertRegistrations(objectTypeId, objectId), HttpStatus.CREATED);
    }

    private AlertCondition[] getContentObjectConditions(long objectTypeId, String objectId) {
        AlertCondition objectTypeIdCondition = new AlertCondition("objectTypeId", (Object)objectTypeId);
        AlertCondition objectIdCondition = new AlertCondition("objectId", (Object)objectId, 12);
        return new AlertCondition[]{objectTypeIdCondition, objectIdCondition};
    }

    private String getUserid() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        return securityContext.getAuthentication().getName();
    }
}

