/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.ibm.icu.util.TimeZone;
import com.platform.LSFJobFlow.api.JFConfigManager;
import com.platform.LSFJobFlow.api.JFDebug;
import com.platform.LSFJobFlow.api.JFEvent;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFLoginManager;
import com.platform.LSFJobFlow.api.JFResource;
import com.platform.LSFJobFlow.api.JFUser;
import com.platform.LSFJobFlow.api.JFVersion;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class JFTimeEvent
extends JFEvent {
    public static final String EVENT_GENERATOR_TYPE = "CalendarTime_v1";
    private String m_calendarName = null;
    private String m_hours = null;
    private String m_minutes = null;
    private String m_user = null;
    private String m_duration = null;
    private String m_occurrences = null;
    private String m_timeZoneID = null;

    public JFTimeEvent(String string, String string2, String string3, String string4, String string5) throws JFException {
        this(string, string2, string3, string4, string5, null, null);
    }

    public JFTimeEvent(String string, String string2, String string3, String string4, String string5, String string6) throws JFException {
        if (string2 == null) {
            string2 = JFLoginManager.getUserName();
        }
        if (string2 == null) {
            throw new JFException(JFResource.getString("USERNAME_NOT_FND"));
        }
        this.m_user = string2;
        this.initialize(string, string3, string4, string5, string6, null);
    }

    public JFTimeEvent(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws JFException {
        if (string2 == null) {
            string2 = JFLoginManager.getUserName();
        }
        if (string2 == null) {
            throw new JFException(JFResource.getString("USERNAME_NOT_FND"));
        }
        this.m_user = string2;
        this.initialize(string, string3, string4, string5, string6, string7);
    }

    public String getCalendarName() {
        return this.m_calendarName;
    }

    public void setCalendarName(String string) {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("CAL_CALNAME_NULL"));
        }
        this.m_calendarName = string;
    }

    public String getUser() {
        return JFUser.deFormatString(this.m_user);
    }

    public void setUser(String string) throws JFException {
        if (string == null) {
            throw new JFException(JFResource.getString("USERNAME_NOT_FND"));
        }
        this.m_user = string;
    }

    public String getHour() {
        return this.m_hours;
    }

    public void setHour(String string) {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("CAL_ARG_NULL"));
        }
        this.m_hours = string;
    }

    public String getMinute() {
        return this.m_minutes;
    }

    public void setMinute(String string) {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("CAL_ARG_NULL"));
        }
        this.m_minutes = string;
    }

    public String getDuration() {
        return this.m_duration;
    }

    public void setDuration(String string) {
        this.m_duration = string;
    }

    public String getOccurrences() {
        return this.m_occurrences;
    }

    public void setOccurrences(String string) {
        this.m_occurrences = string;
    }

    public String getTimeZoneID() {
        return this.m_timeZoneID;
    }

    public void setTimeZoneID(String string) throws JFException {
        this.setTimeZoneInfo(string);
    }

    private void initialize(String string, String string2, String string3, String string4, String string5, String string6) throws JFException {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("CAL_CALNAME_NULL"));
        }
        if (string2 == null || string3 == null) {
            throw new NullPointerException(JFResource.getString("CAL_ARG_NULL"));
        }
        this.m_calendarName = string;
        this.m_hours = string2;
        this.m_minutes = string3;
        this.m_duration = string4;
        this.m_occurrences = string5;
        this.setTimeZoneInfo(string6);
    }

    public JFTimeEvent() {
    }

    @Override
    public String getEventGeneratorType() {
        return EVENT_GENERATOR_TYPE;
    }

    private void setTimeZoneInfo(String string) throws JFException {
        boolean bl = !JFConfigManager.checkServerVersionCompatible(new JFVersion("7.1"));
        String string2 = string;
        if (!bl && (string2 == null || string2.equals(""))) {
            int n = JFConfigManager.getTimeZoneFlag();
            if (n == 0) {
                string2 = "Client";
            }
            if (n == 1) {
                string2 = "Server";
            }
            if (n == 2) {
                string2 = "UTC";
            }
        }
        if (string2 != null && !string2.equals("")) {
            if (string2.equalsIgnoreCase("Client")) {
                this.m_timeZoneID = TimeZone.getDefault().getID();
                if (this.m_timeZoneID.equals("Custom")) {
                    this.m_timeZoneID = TimeZone.getDefault().getDisplayName();
                }
                this.setAttribute("TimeZoneType", "0");
            } else if (string2.equalsIgnoreCase("Server")) {
                this.m_timeZoneID = "Server";
                this.setAttribute("TimeZoneType", "1");
            } else if (string2.equalsIgnoreCase("UTC")) {
                this.m_timeZoneID = "UTC";
                this.setAttribute("TimeZoneType", "2");
            } else {
                if (!this.isValidTimeZoneID(string2)) {
                    throw new JFException(JFResource.getString("INVALID_TIME_ZONE"));
                }
                this.m_timeZoneID = string2;
                this.setAttribute("TimeZoneType", "3");
            }
        }
    }

    private boolean isValidTimeZoneID(String string) {
        block4: {
            if (string == null || string.equals("")) {
                return false;
            }
            String string2 = TimeZone.getTimeZone((String)string).getID();
            try {
                if (string2.equals("Etc/Unknown") && !string2.equals("Custom")) {
                    return false;
                }
            }
            catch (NoSuchFieldError noSuchFieldError) {
                JFDebug.println("An older ICU4J is being used without the TimeZone.UNKNOWN_ZONE_ID defined. Skipping check");
                if (string2.equals(string) || string2.equals("Custom")) break block4;
                return false;
            }
        }
        return true;
    }

    @Override
    public void initFromDefinition(String string) throws JFException {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("DEFN_NULL"));
        }
        this.m_user = null;
        this.m_hours = null;
        this.m_calendarName = null;
        this.m_minutes = null;
        this.m_duration = null;
        this.m_occurrences = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "@");
        if (stringTokenizer.countTokens() < 2) {
            throw new JFException(JFResource.getString("EVENT_DEFN_INC"));
        }
        String string2 = stringTokenizer.nextToken();
        this.m_user = stringTokenizer.nextToken();
        int n = string2.indexOf("+");
        if (n > 0) {
            String string3 = string2.substring(n + 1);
            this.setTimeZoneInfo(string3);
            string2 = string2.substring(0, n);
        } else {
            this.setTimeZoneInfo(null);
        }
        int n2 = string2.indexOf("#");
        if (n2 > 0) {
            this.m_occurrences = string2.substring(n2 + 1);
            string2 = string2.substring(0, n2);
        }
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ":");
        try {
            this.m_calendarName = stringTokenizer2.nextToken();
            this.m_hours = stringTokenizer2.nextToken();
            this.m_minutes = stringTokenizer2.nextToken(":%");
            if (stringTokenizer2.hasMoreTokens()) {
                this.m_duration = stringTokenizer2.nextToken();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new JFException(JFResource.getString("EVENT_DEFN_INC"));
        }
    }

    public void initFromCLIDefinition(String string) throws JFException {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("DEFN_NULL"));
        }
        this.m_user = null;
        this.m_hours = null;
        this.m_calendarName = null;
        this.m_minutes = null;
        this.m_duration = null;
        this.m_occurrences = null;
        String string2 = null;
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (stringTokenizer.countTokens() < 3) {
            string2 = "Daily@Sys";
            string3 = string;
        } else {
            string2 = stringTokenizer.nextToken();
            string3 = stringTokenizer.nextToken("");
        }
        try {
            stringTokenizer = new StringTokenizer(string2, "@");
            this.m_calendarName = stringTokenizer.nextToken();
            this.m_user = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : JFLoginManager.getUserName();
            int n = string3.indexOf("+");
            if (n > 0) {
                String string4 = string3.substring(n + 1);
                this.setTimeZoneInfo(string4);
                string3 = string3.substring(0, n);
            } else {
                this.setTimeZoneInfo(null);
            }
            int n2 = string3.indexOf("#");
            if (n2 > 0) {
                this.m_occurrences = string3.substring(n2 + 1);
                string3 = string3.substring(0, n2);
                try {
                    if (Integer.parseInt(this.m_occurrences, 10) < 1) {
                        throw new JFException(JFResource.getString("EVENT_DEFN_INC"));
                    }
                }
                catch (Exception exception) {
                    throw new JFException(JFResource.getString("EVENT_DEFN_INC"));
                }
            }
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, ":");
            this.m_hours = stringTokenizer2.nextToken();
            if (!JFTimeEvent.isValidExpression(this.m_hours, 0, 23)) {
                throw new JFException(JFResource.getString("EVENT_DEFN_INC"));
            }
            this.m_minutes = stringTokenizer2.nextToken(":%");
            if (!JFTimeEvent.isValidExpression(this.m_minutes, 0, 59)) {
                throw new JFException(JFResource.getString("EVENT_DEFN_INC"));
            }
            if (stringTokenizer2.hasMoreTokens()) {
                this.m_duration = stringTokenizer2.nextToken();
                try {
                    if (Integer.parseInt(this.m_duration, 10) < 1) {
                        throw new JFException(JFResource.getString("EVENT_DEFN_INC"));
                    }
                }
                catch (Exception exception) {
                    throw new JFException(JFResource.getString("EVENT_DEFN_INC"));
                }
            }
            if (stringTokenizer2.hasMoreTokens()) {
                throw new JFException(JFResource.getString("EVENT_DEFN_INC"));
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new JFException(JFResource.getString("EVENT_DEFN_INC"));
        }
    }

    @Override
    public String generateDefinition() {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append(this.m_calendarName + ":" + this.m_hours + ":" + this.m_minutes);
        if (this.m_duration != null && !this.m_duration.equals("")) {
            stringBuffer.append("%" + this.m_duration);
        }
        if (this.m_occurrences != null && !this.m_occurrences.equals("")) {
            stringBuffer.append("#" + this.m_occurrences);
        }
        if (this.m_timeZoneID != null && !this.m_timeZoneID.equals("")) {
            stringBuffer.append("+" + this.m_timeZoneID);
        }
        stringBuffer.append("@" + this.m_user);
        return stringBuffer.toString();
    }

    @Override
    public String toString() {
        String string = this.getAttribute("ClientTZoffset");
        String string2 = this.getAttribute("ServerTZoffset");
        String string3 = this.getAttribute("TimeZone");
        if (string3 == null || string3.length() <= 0) {
            string3 = "";
        }
        if (!(string3.equals("") || string2 != null && string2.length() > 0)) {
            string3 = "";
        }
        if (this.m_timeZoneID != null && this.m_timeZoneID.length() > 0 && !this.m_timeZoneID.equalsIgnoreCase("Server")) {
            string3 = this.m_timeZoneID;
        }
        if (string3.equals("")) {
            return this.m_calendarName + "@" + JFUser.deFormatString(this.m_user) + ", " + this.m_hours + ": " + this.m_minutes;
        }
        return this.m_calendarName + "@" + JFUser.deFormatString(this.m_user) + ", " + this.m_hours + ": " + this.m_minutes + "  " + string3;
    }

    @Override
    public String getTooltip(String string, String string2) {
        String string3 = "";
        if (null != string2) {
            string3 = "If " + this.toString() + " then " + string2;
        }
        return string3;
    }

    static boolean isValidExpression(String string, int n, int n2) {
        if (string == null || string.length() == 0) {
            return false;
        }
        string.trim();
        if (string.equals("*")) {
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = null;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        String string3 = null;
        String string4 = null;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != ',') continue;
            ++n3;
        }
        if (n3 + 1 != stringTokenizer.countTokens()) {
            return false;
        }
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2 == null || string2.length() == 0) {
                return false;
            }
            string2.trim();
            if (string2.indexOf(43) != -1) {
                return false;
            }
            n6 = string2.indexOf(45);
            n5 = string2.length();
            if (n6 == 0 || n6 == n5) {
                return false;
            }
            if (n6 != -1) {
                string3 = string2.substring(0, n6);
                string4 = string2.substring(n6 + 1, n5);
            } else {
                string3 = string2;
                string4 = null;
            }
            try {
                n3 = Integer.parseInt(string3, 10);
                if (n3 < n || n3 > n2) {
                    return false;
                }
                if (string4 == null || (n4 = Integer.parseInt(string4, 10)) > n3 && n4 <= n2) continue;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(JFEvent jFEvent) {
        if (!this.getEventGeneratorType().equals(jFEvent.getEventGeneratorType())) {
            JFDebug.println("Gen: <" + this.getEventGeneratorType() + "> Other Gen: <" + jFEvent.getEventGeneratorType() + ">");
            return false;
        }
        if (!this.generateDefinition().equals(jFEvent.generateDefinition())) {
            JFDebug.println("Def: <" + this.generateDefinition() + "> Other Def: <" + jFEvent.generateDefinition() + ">");
            return false;
        }
        String string = this.getAttribute("TimeDuration");
        String string2 = jFEvent.getAttribute("TimeDuration");
        if (string == null ? string2 != null && !string2.equals("") : (string.equals("") ? string2 != null && !string2.equals("") : !string.equals(string2))) {
            return false;
        }
        String string3 = this.m_timeZoneID;
        String string4 = ((JFTimeEvent)jFEvent).getTimeZoneID();
        if (string3 == null ? string4 != null && !string4.equals("") : (string3.equals("") ? string4 != null && !string4.equals("") : !string3.equals(string4))) {
            return false;
        }
        String string5 = this.getAttribute("Description");
        String string6 = jFEvent.getAttribute("Description");
        JFDebug.println("desc1: <" + string5 + "> desc2: <" + string6 + ">");
        if (string5 == null) {
            return string6 == null || string6.equals("");
        }
        if (string5.equals("")) {
            return string6 == null || string6.equals("");
        }
        return string5.equals(string6);
    }
}

