/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFFlowInstance;
import com.platform.LSFJobFlow.api.JFInstanceManagerPolicy;
import com.platform.LSFJobFlow.api.JFPseudoFlowInstance;
import com.platform.LSFJobFlow.api.JFResource;
import java.text.MessageFormat;
import java.util.Arrays;

public class JFStatisticManager {
    private static final int SEPARATION = 25;
    private JFInstanceManagerPolicy m_policy = null;
    private String m_flowName = "";
    private int m_exitCount = 0;
    private int m_doneCount = 0;
    private int m_runningCount = 0;
    private int m_killedCount = 0;
    private int m_suspendedCount = 0;
    private int m_waitingCount = 0;
    private int m_totalCount = 0;
    private JFPseudoFlowInstance m_exitFlow = null;
    private JFPseudoFlowInstance m_doneFlow = null;
    private JFPseudoFlowInstance m_runningFlow = null;
    private JFPseudoFlowInstance m_killedFlow = null;
    private JFPseudoFlowInstance m_suspendedFlow = null;
    private JFPseudoFlowInstance m_waitingFlow = null;

    public JFStatisticManager(JFInstanceManagerPolicy jFInstanceManagerPolicy, String string) {
        this.m_policy = jFInstanceManagerPolicy;
        this.m_flowName = string;
    }

    public boolean tallyStatistic(JFPseudoFlowInstance jFPseudoFlowInstance) {
        boolean bl = true;
        switch (jFPseudoFlowInstance.getState()) {
            case 3: {
                ++this.m_exitCount;
                ++this.m_totalCount;
                if (this.m_exitFlow != null && jFPseudoFlowInstance.getInstanceId() < this.m_exitFlow.getInstanceId()) break;
                this.m_exitFlow = jFPseudoFlowInstance;
                break;
            }
            case 2: {
                ++this.m_doneCount;
                ++this.m_totalCount;
                if (this.m_doneFlow != null && jFPseudoFlowInstance.getInstanceId() < this.m_doneFlow.getInstanceId()) break;
                this.m_doneFlow = jFPseudoFlowInstance;
                break;
            }
            case 1: {
                ++this.m_runningCount;
                ++this.m_totalCount;
                if (this.m_runningFlow != null && jFPseudoFlowInstance.getInstanceId() < this.m_runningFlow.getInstanceId()) break;
                this.m_runningFlow = jFPseudoFlowInstance;
                break;
            }
            case 5: 
            case 6: {
                ++this.m_suspendedCount;
                ++this.m_totalCount;
                if (this.m_suspendedFlow != null && jFPseudoFlowInstance.getInstanceId() < this.m_suspendedFlow.getInstanceId()) break;
                this.m_suspendedFlow = jFPseudoFlowInstance;
                break;
            }
            case 4: {
                ++this.m_killedCount;
                ++this.m_totalCount;
                if (this.m_killedFlow != null && jFPseudoFlowInstance.getInstanceId() < this.m_killedFlow.getInstanceId()) break;
                this.m_killedFlow = jFPseudoFlowInstance;
                break;
            }
            case 0: {
                ++this.m_waitingCount;
                ++this.m_totalCount;
                if (this.m_waitingFlow != null && jFPseudoFlowInstance.getInstanceId() < this.m_waitingFlow.getInstanceId()) break;
                this.m_waitingFlow = jFPseudoFlowInstance;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public String getStatisticText() {
        String string = JFResource.getString("Summary_for_definition") + " " + this.m_flowName + "\n";
        if (this.m_policy != null) {
            if (this.m_policy.getType().equals("JF_IM_IPolicy")) {
                Object[] objectArray = new Object[]{new Integer(this.m_totalCount)};
                String string2 = JFResource.getString("Last_N_flows");
                MessageFormat messageFormat = new MessageFormat(string2);
                string = string + messageFormat.format(objectArray) + "\n\n";
            } else {
                Object[] objectArray = new Object[]{new Integer(this.m_totalCount), new Integer(this.m_policy.getLife())};
                String string3 = JFResource.getString("Total_T_flows_in_the_last_D_days");
                MessageFormat messageFormat = new MessageFormat(string3);
                string = string + messageFormat.format(objectArray) + "\n\n";
            }
        }
        if (this.m_exitCount > 0 && this.m_exitFlow != null) {
            string = string + this.alignString(JFFlowInstance.getStateStr(3), 25) + ": " + this.m_exitCount + "\n";
            string = string + this.alignString(JFResource.getString("Last_Flow_ID"), 25) + ": " + this.m_exitFlow.getInstanceId() + "\n";
            string = string + this.alignString(JFResource.getString("Start_Time"), 25) + ": " + this.m_exitFlow.getStartTimeString() + "\n";
            string = string + this.alignString(JFResource.getString("Finish_Time"), 25) + ": " + this.m_exitFlow.getFinishTimeString() + "\n\n";
        }
        if (this.m_doneCount > 0 && this.m_doneFlow != null) {
            string = string + this.alignString(JFFlowInstance.getStateStr(2), 25) + ": " + this.m_doneCount + "\n";
            string = string + this.alignString(JFResource.getString("Last_Flow_ID"), 25) + ": " + this.m_doneFlow.getInstanceId() + "\n";
            string = string + this.alignString(JFResource.getString("Start_Time"), 25) + ": " + this.m_doneFlow.getStartTimeString() + "\n";
            string = string + this.alignString(JFResource.getString("Finish_Time"), 25) + ": " + this.m_doneFlow.getFinishTimeString() + "\n\n";
        }
        if (this.m_runningCount > 0 && this.m_runningFlow != null) {
            string = string + this.alignString(JFFlowInstance.getStateStr(1), 25) + ": " + this.m_runningCount + "\n";
            string = string + this.alignString(JFResource.getString("Last_Flow_ID"), 25) + ": " + this.m_runningFlow.getInstanceId() + "\n";
            string = string + this.alignString(JFResource.getString("Start_Time"), 25) + ": " + this.m_runningFlow.getStartTimeString() + "\n\n";
        }
        if (this.m_killedCount > 0 && this.m_killedFlow != null) {
            string = string + this.alignString(JFFlowInstance.getStateStr(4), 25) + ": " + this.m_killedCount + "\n";
            string = string + this.alignString(JFResource.getString("Last_Flow_ID"), 25) + ": " + this.m_killedFlow.getInstanceId() + "\n";
            string = string + this.alignString(JFResource.getString("Start_Time"), 25) + ": " + this.m_killedFlow.getStartTimeString() + "\n";
            string = string + this.alignString(JFResource.getString("Finish_Time"), 25) + ": " + this.m_killedFlow.getFinishTimeString() + "\n\n";
        }
        if (this.m_suspendedCount > 0 && this.m_suspendedFlow != null) {
            string = string + this.alignString(JFFlowInstance.getStateStr(5), 25) + ": " + this.m_suspendedCount + "\n";
            string = string + this.alignString(JFResource.getString("Last_Flow_ID"), 25) + ": " + this.m_suspendedFlow.getInstanceId() + "\n";
            string = string + this.alignString(JFResource.getString("Start_Time"), 25) + ": " + this.m_suspendedFlow.getStartTimeString() + "\n\n";
        }
        if (this.m_waitingCount > 0) {
            string = string + JFFlowInstance.getStateStr(0) + ": " + this.m_waitingCount + "\n\n";
        }
        return string;
    }

    private String alignString(String string, int n) {
        if (string == null) {
            string = "";
        }
        if (string.length() >= n) {
            return "*" + string.substring(string.length() - n + 2) + " ";
        }
        char[] cArray = new char[n];
        Arrays.fill(cArray, ' ');
        return (string + new String(cArray)).substring(0, n - 1) + " ";
    }
}

