/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFFlowInstance;
import com.platform.LSFJobFlow.api.JFFlowManager;
import com.platform.LSFJobFlow.api.JFFlowVersion;
import com.platform.LSFJobFlow.api.JFTime;
import java.util.Date;
import java.util.Properties;
import org.w3c.dom.Node;

public class JFPseudoFlowInstance
implements Comparable {
    private long m_id;
    private String m_instanceName = null;
    private String m_flowName = null;
    private int m_state;
    private int m_statusCode;
    private JFTime m_startTime = null;
    private JFTime m_finishTime = null;
    private JFFlowVersion m_flowVersion = null;
    private String m_owner = null;
    private String m_submitter = null;
    private String m_instanceDescription = "";
    private String m_instanceProject = "";
    private boolean m_isFromOwnFlowDefinition;
    private boolean m_defRemoved;
    private boolean m_draft;
    private static final String JS_FLOW_DESCRIPTION = "JS_FLOW_DESCRIPTION";
    private static final String JS_FLOW_PROJECT = "JS_FLOW_PROJECT";

    public boolean isFromOwnFlowDefinition() {
        return this.m_isFromOwnFlowDefinition;
    }

    JFPseudoFlowInstance() {
        this.m_flowVersion = new JFFlowVersion();
    }

    JFPseudoFlowInstance(long l, String string, String string2, int n, String string3) {
        this.m_id = l;
        this.m_instanceName = string;
        this.m_flowName = string2;
        this.m_state = n;
        this.m_flowVersion = new JFFlowVersion();
        this.m_owner = string3;
    }

    JFPseudoFlowInstance(long l, String string, String string2, int n, String string3, boolean bl) {
        this.m_id = l;
        this.m_instanceName = string;
        this.m_flowName = string2;
        this.m_state = n;
        this.m_flowVersion = new JFFlowVersion();
        this.m_owner = string3;
        this.m_isFromOwnFlowDefinition = bl;
    }

    JFPseudoFlowInstance(long l, String string, String string2, int n, String string3, boolean bl, String string4) {
        this.m_id = l;
        this.m_instanceName = string;
        this.m_flowName = string2;
        this.m_state = n;
        this.m_flowVersion = new JFFlowVersion();
        this.m_owner = string3;
        this.m_isFromOwnFlowDefinition = bl;
        this.m_instanceDescription = string4;
    }

    public JFPseudoFlowInstance(JFFlowInstance jFFlowInstance) {
        this.m_id = jFFlowInstance.getInstanceId();
        this.m_instanceName = jFFlowInstance.getName();
        this.m_flowName = jFFlowInstance.getFlowDefinition().getName();
        this.m_state = jFFlowInstance.getState();
        this.m_statusCode = jFFlowInstance.getStatus();
        this.m_startTime = jFFlowInstance.startTime;
        this.m_finishTime = jFFlowInstance.finishTime;
        this.m_flowVersion = jFFlowInstance.getFlowDefinition().getFlowVersion();
        this.m_owner = jFFlowInstance.getOwner();
        this.m_isFromOwnFlowDefinition = jFFlowInstance.isFromOwnFlowDefinition();
        this.m_draft = jFFlowInstance.isDraft();
        Properties properties = jFFlowInstance.getLocalVariables();
        this.m_instanceDescription = properties.getProperty(JS_FLOW_DESCRIPTION);
        this.m_instanceProject = properties.getProperty(JS_FLOW_PROJECT);
    }

    public long getInstanceId() {
        return this.m_id;
    }

    public String getInstanceName() {
        return this.m_instanceName;
    }

    public String getFlowName() {
        return this.m_flowName;
    }

    public String getOwner() {
        return this.m_owner;
    }

    public String getSubmitter() {
        if (this.m_submitter == null || this.m_submitter == "") {
            try {
                this.m_submitter = new JFFlowManager().getInstance(this.m_id).getTriggerUser().toJSUserName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.m_submitter;
    }

    public int getState() {
        return this.m_state;
    }

    public int getStatus() {
        return this.m_statusCode;
    }

    public Date getStartTime() {
        if (this.m_startTime != null) {
            return this.m_startTime.getTime();
        }
        return null;
    }

    public Date getFinishTime() {
        if (this.m_finishTime != null) {
            return this.m_finishTime.getTime();
        }
        return null;
    }

    public String getStartTimeOnServer() {
        if (this.m_startTime != null) {
            return this.m_startTime.getTimeStringOnServer();
        }
        return null;
    }

    public String getFinishTimeOnServer() {
        if (this.m_finishTime != null) {
            return this.m_finishTime.getTimeStringOnServer();
        }
        return null;
    }

    public String getStartTimeString() {
        if (this.m_startTime != null) {
            return this.m_startTime.getTimeString();
        }
        return null;
    }

    public String getFinishTimeString() {
        if (this.m_finishTime != null) {
            return this.m_finishTime.getTimeString();
        }
        return null;
    }

    public String getInstanceDescription() {
        return this.m_instanceDescription;
    }

    public String getInstanceProject() {
        return this.m_instanceProject;
    }

    public void setState(int n) {
        this.m_state = n;
    }

    public JFFlowVersion getFlowVersion() {
        return this.m_flowVersion;
    }

    public void setFlowVersion(JFFlowVersion jFFlowVersion) {
        this.m_flowVersion = jFFlowVersion;
    }

    public boolean isDefRemoved() {
        return this.m_defRemoved;
    }

    public void setDefRemoved(boolean bl) {
        this.m_defRemoved = bl;
    }

    public boolean isDraft() {
        return this.m_draft;
    }

    public void setDraft(boolean bl) {
        this.m_draft = bl;
    }

    void fromXML(Node node) throws JFException {
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            String string;
            Node node2 = node.getChildNodes().item(i);
            if (node2.getNodeName().equals("id")) {
                this.m_id = Long.parseLong(node2.getFirstChild().getNodeValue());
            }
            if (node2.getNodeName().equals("instanceName")) {
                this.m_instanceName = node2.getFirstChild().getNodeValue();
            }
            if (node2.getNodeName().equals("flowName")) {
                this.m_flowName = node2.getFirstChild().getNodeValue();
            }
            if (node2.getNodeName().equals("state")) {
                this.m_state = Integer.parseInt(node2.getFirstChild().getNodeValue());
            }
            if (node2.getNodeName().equals("statusCode")) {
                this.m_statusCode = Integer.parseInt(node2.getFirstChild().getNodeValue());
            }
            if (node2.getNodeName().equals("startTime")) {
                this.m_startTime = new JFTime(node2.getFirstChild());
            }
            if (node2.getNodeName().equals("finishTime")) {
                this.m_finishTime = new JFTime(node2.getFirstChild());
            }
            if (node2.getNodeName().equals("flowVersion")) {
                this.m_flowVersion.fromXML(node2);
            }
            if (node2.getNodeName().equals("owner")) {
                this.m_owner = node2.getFirstChild().getNodeValue();
            }
            if (node2.getNodeName().equals("triggerUser")) {
                this.m_submitter = node2.getFirstChild().getNodeValue();
            }
            if (node2.getNodeName().equals("isFromOwnFlowDefinition")) {
                string = node2.getFirstChild().getNodeValue();
                boolean bl = this.m_isFromOwnFlowDefinition = string != null && string.equalsIgnoreCase("true");
            }
            if (node2.getNodeName().equals("instanceDescription")) {
                this.m_instanceDescription = node2.getFirstChild().getNodeValue();
            }
            if (node2.getNodeName().equals("instanceProject")) {
                this.m_instanceProject = node2.getFirstChild().getNodeValue();
            }
            if (node2.getNodeName().equals("defRemoved")) {
                string = node2.getFirstChild().getNodeValue();
                boolean bl = this.m_defRemoved = string != null && string.equalsIgnoreCase("true");
            }
            if (!node2.getNodeName().equals("draft")) continue;
            string = node2.getFirstChild().getNodeValue();
            this.m_draft = string != null && string.equalsIgnoreCase("true");
        }
    }

    public int compareTo(Object object) {
        if (!(object instanceof JFPseudoFlowInstance)) {
            return -1;
        }
        long l = ((JFPseudoFlowInstance)object).getInstanceId();
        if (this.m_id == l) {
            return 0;
        }
        if (this.m_id < l) {
            return -1;
        }
        return 1;
    }
}

