/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSF.security.EauthCredentials;
import com.platform.LSF.security.EauthLoginCallbackHandler;
import com.platform.LSF.security.LSFUser;
import com.platform.LSFJobFlow.api.JFAdminManager;
import com.platform.LSFJobFlow.api.JFConfigManager;
import com.platform.LSFJobFlow.api.JFDebug;
import com.platform.LSFJobFlow.api.JFEncryption128;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFLoginInfo;
import com.platform.LSFJobFlow.api.JFPeriodic;
import com.platform.LSFJobFlow.api.JFResource;
import com.platform.LSFJobFlow.api.JFUserSessionManager;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.Principal;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class JFLoginManager {
    private static final String OS_TYPE = System.getProperty("os.name").toLowerCase();
    private static HashMap m_loginContextMap = new HashMap();
    private static HashMap m_oldLoginContextMap = new HashMap();
    private static final String FAILED_LOGIN_MSG = JFResource.getString("FAILED_LOGIN_MSG");
    static boolean m_isPACLogin = false;
    static boolean m_isSSOLogin = false;
    static volatile boolean m_isRefreshed = false;
    private static final long EXPIRE_TIMEOUT = 86400000L;
    private static Thread refreshThread = null;

    private JFLoginManager() {
    }

    public static synchronized void login(boolean bl) throws LoginException {
        m_isPACLogin = false;
        m_isSSOLogin = false;
        JFConfigManager.needRefresh();
        if (JFConfigManager.isExternalLogin()) {
            if (bl) {
                JFLoginManager.login("UsernamePasswordCLI");
            } else {
                JFLoginManager.login("UsernamePasswordGUI");
            }
        } else {
            JFLoginManager.login("eauth");
        }
        JFAdminManager.needRefresh();
    }

    public static synchronized void login(String string) throws LoginException {
        m_isPACLogin = false;
        m_isSSOLogin = false;
        JFConfigManager.needRefresh();
        LoginContext loginContext = null;
        if (string.equals("eauth")) {
            String string2 = JFConfigManager.getConfig("JS_HOST");
            EauthLoginCallbackHandler eauthLoginCallbackHandler = new EauthLoginCallbackHandler(string2);
            loginContext = new LoginContext(string, new Subject(), (CallbackHandler)eauthLoginCallbackHandler);
        } else {
            loginContext = new LoginContext(string, new Subject());
        }
        JFLoginManager.addToMap(loginContext);
        loginContext.login();
        if (string.equals("eauth")) {
            JFLoginManager.refreshCredentials();
        }
        JFAdminManager.needRefresh();
    }

    public static void refreshCredentials() {
        if (!JFConfigManager.isExternalLogin() && !m_isRefreshed) {
            refreshThread = new Thread(){

                @Override
                public void run() {
                    int n = JFConfigManager.getEauthTimeOut();
                    int n2 = n - 5;
                    int n3 = n2 - 1;
                    try {
                        1.sleep(n3);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        m_isRefreshed = false;
                    }
                    while (!this.isInterrupted() && !JFConfigManager.isExternalLogin() && m_isRefreshed) {
                        try {
                            JFLoginManager.login("eauth");
                            1.sleep(n2 * 1000);
                        }
                        catch (LoginException loginException) {
                            m_isRefreshed = false;
                        }
                        catch (InterruptedException interruptedException) {
                            m_isRefreshed = false;
                            Thread.currentThread().interrupt();
                        }
                    }
                }
            };
            m_isRefreshed = true;
            refreshThread.start();
        }
    }

    public static String decrypt(byte[] byArray, byte[] byArray2) {
        String string = null;
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            byte[] byArray3 = new byte[cipher.getBlockSize()];
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray3);
            cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
            string = new String(cipher.doFinal(byArray));
        }
        catch (Exception exception) {
            JFDebug.println("Authentication fails because decryption is failed.");
        }
        return string;
    }

    public static synchronized boolean login(String string, byte[] byArray) throws JFException, LoginException, UnsupportedEncodingException {
        if (string == null || string.equals("")) {
            throw new FailedLoginException(FAILED_LOGIN_MSG);
        }
        JFConfigManager.needRefresh();
        JFEncryption128 jFEncryption128 = new JFEncryption128(byArray);
        String string2 = System.currentTimeMillis() + ":" + string;
        string2 = jFEncryption128.marshallChannel(string2.getBytes("UTF-8"));
        string2 = string2.replace("\r\n", "");
        m_isSSOLogin = true;
        m_isPACLogin = false;
        JFLoginManager.login(string, string2);
        JFAdminManager.needRefresh();
        return true;
    }

    public static synchronized boolean login(byte[] byArray) throws LoginException {
        JFConfigManager.needRefresh();
        byte[] byArray2 = new byte[]{112, 8, 8, 113, 16, 8, -110, 18, 32, -103, 6, 32, -103, -123, 35, -1};
        String string = JFLoginManager.decrypt(byArray, byArray2);
        if (string == null) {
            return false;
        }
        int n = string.indexOf(58);
        if (n < 0) {
            JFDebug.println("Authentication fails because data format is not right.");
            return false;
        }
        m_isPACLogin = true;
        m_isSSOLogin = false;
        String string2 = string.substring(n + 1);
        String string3 = string + ":" + "pac_login_request";
        JFLoginManager.login(string2, string3);
        JFAdminManager.needRefresh();
        return true;
    }

    public static synchronized void login(String string, char[] cArray) throws LoginException {
        String string2;
        String string3;
        if (string == null || string.equals("") || cArray == null) {
            throw new FailedLoginException(FAILED_LOGIN_MSG);
        }
        JFConfigManager.needRefresh();
        int n = string.indexOf(92);
        if (n < 0) {
            string3 = string;
            string2 = null;
        } else {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        if (string3.indexOf(92) >= 0 || string3.indexOf(9) >= 0) {
            throw new FailedLoginException(FAILED_LOGIN_MSG);
        }
        if (OS_TYPE.indexOf("win") < 0 && string3.indexOf(32) >= 0) {
            throw new FailedLoginException(FAILED_LOGIN_MSG);
        }
        LSFUser lSFUser = new LSFUser(string3, 0, 0, string2);
        CharBuffer charBuffer = CharBuffer.allocate(cArray.length);
        charBuffer.put(cArray);
        charBuffer.flip();
        ByteBuffer byteBuffer = Charset.defaultCharset().encode(charBuffer);
        EauthCredentials eauthCredentials = new EauthCredentials(byteBuffer.array());
        if (charBuffer != null) {
            charBuffer.clear();
        }
        if (byteBuffer != null) {
            byteBuffer.clear();
        }
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)lSFUser);
        subject.getPublicCredentials().add(eauthCredentials);
        LoginContext loginContext = new LoginContext("UsernamePassword", subject);
        JFLoginManager.addToMap(loginContext);
        loginContext.login();
        JFAdminManager.needRefresh();
    }

    @Deprecated
    public static synchronized void login(String string, String string2) throws LoginException {
        String string3;
        String string4;
        if (string == null || string.equals("") || string2 == null) {
            throw new FailedLoginException(FAILED_LOGIN_MSG);
        }
        JFConfigManager.needRefresh();
        int n = string.indexOf(92);
        if (n < 0) {
            string4 = string;
            string3 = null;
        } else {
            string3 = string.substring(0, n);
            string4 = string.substring(n + 1);
        }
        if (string4.indexOf(92) >= 0 || string4.indexOf(9) >= 0) {
            throw new FailedLoginException(FAILED_LOGIN_MSG);
        }
        if (OS_TYPE.indexOf("win") < 0 && string4.indexOf(32) >= 0) {
            throw new FailedLoginException(FAILED_LOGIN_MSG);
        }
        LSFUser lSFUser = new LSFUser(string4, 0, 0, string3);
        EauthCredentials eauthCredentials = new EauthCredentials(string2.getBytes());
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)lSFUser);
        subject.getPublicCredentials().add(eauthCredentials);
        LoginContext loginContext = new LoginContext("UsernamePassword", subject);
        JFLoginManager.addToMap(loginContext);
        loginContext.login();
        JFAdminManager.needRefresh();
    }

    public static synchronized String getUserName() {
        Subject subject = JFLoginManager.getSubject();
        if (subject == null) {
            return null;
        }
        Set<Principal> set = subject.getPrincipals();
        if (set == null) {
            return null;
        }
        Iterator<Principal> iterator = set.iterator();
        if (iterator == null) {
            return null;
        }
        Principal principal = iterator.next();
        return principal.getName();
    }

    public static synchronized void backupLoginContext() {
        m_oldLoginContextMap.clear();
        m_oldLoginContextMap.putAll(m_loginContextMap);
    }

    public static synchronized void restoreLoginContext() {
        m_loginContextMap.clear();
        m_loginContextMap.putAll(m_oldLoginContextMap);
    }

    static synchronized Subject getSubject() {
        if (m_loginContextMap == null) {
            return null;
        }
        String string = JFUserSessionManager.getUserSessionManager().getUserSessionId();
        JFLoginInfo jFLoginInfo = (JFLoginInfo)m_loginContextMap.get(string);
        if (jFLoginInfo == null) {
            return null;
        }
        jFLoginInfo.m_timeStamp = new Date().getTime();
        return jFLoginInfo.m_loginContext.getSubject();
    }

    private static synchronized void addToMap(LoginContext loginContext) {
        String string = JFUserSessionManager.getUserSessionManager().getUserSessionId();
        if (string == null) {
            throw new NullPointerException("Null session id");
        }
        JFLoginInfo jFLoginInfo = new JFLoginInfo(new Date().getTime(), loginContext);
        m_loginContextMap.put(string, jFLoginInfo);
    }

    public static synchronized Subject getOldSubject() {
        if (m_oldLoginContextMap == null) {
            return null;
        }
        String string = JFUserSessionManager.getUserSessionManager().getUserSessionId();
        JFLoginInfo jFLoginInfo = (JFLoginInfo)m_oldLoginContextMap.get(string);
        if (jFLoginInfo == null) {
            return null;
        }
        return jFLoginInfo.m_loginContext.getSubject();
    }

    public static synchronized void logout() {
        m_isPACLogin = false;
        m_isSSOLogin = false;
        String string = JFUserSessionManager.getUserSessionManager().getUserSessionId();
        m_loginContextMap.remove(string);
        m_isRefreshed = false;
        if (refreshThread != null) {
            refreshThread.interrupt();
        }
    }

    static synchronized void periodic() {
        if (m_loginContextMap.size() <= 1) {
            return;
        }
        long l = new Date().getTime();
        Iterator iterator = m_loginContextMap.values().iterator();
        while (iterator.hasNext()) {
            JFLoginInfo jFLoginInfo = (JFLoginInfo)iterator.next();
            if (l - jFLoginInfo.m_timeStamp <= 86400000L) continue;
            JFDebug.println("JFLoginManager removing expired session");
            iterator.remove();
        }
    }

    static {
        new Timer().schedule((TimerTask)new JFPeriodic(), 86400000L, 86400000L);
    }
}

