/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFConfigManager;
import com.platform.LSFJobFlow.api.JFDateTimeParser;
import com.platform.LSFJobFlow.api.JFDebug;
import com.platform.LSFJobFlow.api.JFEvent;
import com.platform.LSFJobFlow.api.JFEventInstance;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFFlow;
import com.platform.LSFJobFlow.api.JFFlowArrayEvent;
import com.platform.LSFJobFlow.api.JFFlowArrayExceptionEvent;
import com.platform.LSFJobFlow.api.JFFlowEvent;
import com.platform.LSFJobFlow.api.JFFlowExceptionEvent;
import com.platform.LSFJobFlow.api.JFJob;
import com.platform.LSFJobFlow.api.JFJobArray;
import com.platform.LSFJobFlow.api.JFJobArrayEvent;
import com.platform.LSFJobFlow.api.JFJobArrayExceptionEvent;
import com.platform.LSFJobFlow.api.JFJobEvent;
import com.platform.LSFJobFlow.api.JFJobExceptionEvent;
import com.platform.LSFJobFlow.api.JFLinkEvent;
import com.platform.LSFJobFlow.api.JFLinkEventInstance;
import com.platform.LSFJobFlow.api.JFResource;
import com.platform.LSFJobFlow.api.JFTime;
import com.platform.LSFJobFlow.api.JFVariableEvent;
import com.platform.LSFJobFlow.api.JFVersion;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import org.w3c.dom.Node;

public class JFJobInstance {
    public static final int JOB_UNKNOWN = 0;
    public static final int JOB_INITIALIZING = 1;
    public static final int JOB_INITIALIZING_SUSP = 2;
    public static final int JOB_WAITING = 3;
    public static final int JOB_WAITING_SUSP = 4;
    public static final int JOB_RUNNING = 5;
    public static final int JOB_RUNNING_SUSP = 6;
    public static final int JOB_DONE = 7;
    public static final int JOB_KILLED = 8;
    public static final int JOB_EXIT = 9;
    private JFJob jobDefinition = null;
    LinkedList events = new LinkedList();
    private long id;
    private String name;
    private String owner = null;
    private String detail;
    private int state;
    private int statusCode;
    private JFTime startTime = null;
    private JFTime finishTime = null;
    private double CPUUsage;
    private double userCPUUsage;
    private int submissionPid;
    private double memoryUsage;
    private double swapUsage;
    private String completionDescription = null;
    private boolean m_isPending = true;
    private boolean isStartingPointToRerunFlow = false;
    private boolean isStartingPointInAllFlowArrayElements = false;
    private boolean m_isOnHold = false;
    private String m_inputData;
    private String m_outputData;

    JFJobInstance() {
    }

    public boolean isFinished() {
        return this.state == 7 || this.state == 9 || this.state == 8;
    }

    public JFJob getJobDefinition() {
        return this.jobDefinition;
    }

    public long getInstanceId() {
        return this.id;
    }

    public long getId() {
        return this.id;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setInstanceId(long l) {
        this.id = l;
    }

    public String getName() {
        return this.name;
    }

    public String getInputData() {
        return this.m_inputData;
    }

    public String getOutputData() {
        return this.m_outputData;
    }

    public void setState(int n) {
        this.state = n;
    }

    public int getState() {
        return this.state;
    }

    public int getStatus() {
        return this.statusCode;
    }

    public void setStatus(int n) {
        this.statusCode = n;
    }

    public String getDetail() {
        if (this.detail != null) {
            return this.detail;
        }
        return "";
    }

    public Date getStartTime() {
        if (this.startTime != null) {
            return this.startTime.getTime();
        }
        return null;
    }

    void setStartTime(JFTime jFTime) {
        this.startTime = jFTime;
    }

    public Date getFinishTime() {
        if (this.finishTime != null) {
            return this.finishTime.getTime();
        }
        return null;
    }

    public String getStartTimeOnServer() {
        if (this.startTime != null) {
            return this.startTime.getTimeStringOnServer();
        }
        return null;
    }

    public String getFinishTimeOnServer() {
        if (this.finishTime != null) {
            return this.finishTime.getTimeStringOnServer();
        }
        return null;
    }

    public String getStartTimeString() {
        if (this.startTime != null) {
            return this.startTime.getTimeString();
        }
        return null;
    }

    public String getFinishTimeString() {
        if (this.finishTime != null) {
            return this.finishTime.getTimeString();
        }
        return null;
    }

    void setFinishTime(JFTime jFTime) {
        this.finishTime = jFTime;
    }

    public double getCPUUsage() {
        return this.CPUUsage;
    }

    public void setCPUUsage(double d) {
        this.CPUUsage = d;
    }

    public double getUserCPUUsage() {
        return this.userCPUUsage;
    }

    public void setUserCPUUsage(double d) {
        this.userCPUUsage = d;
    }

    public int getSubmissionPid() {
        return this.submissionPid;
    }

    public void setSubmissionPid(int n) {
        this.submissionPid = n;
    }

    public String getCompletionDescription() {
        return this.completionDescription;
    }

    public JFEventInstance[] getEventInstances() {
        if (this.events == null) {
            return new JFEventInstance[0];
        }
        JFEventInstance[] jFEventInstanceArray = new JFEventInstance[this.events.size()];
        this.events.toArray(jFEventInstanceArray);
        return jFEventInstanceArray;
    }

    public boolean isCompletionRequired() {
        return this.getJobDefinition().getExecutionType().equals("manual") && this.getState() == 5;
    }

    void setStartingPointToRerunFlow(boolean bl) {
        this.isStartingPointToRerunFlow = bl;
    }

    public boolean isStartingPointToRerunFlow() {
        return this.isStartingPointToRerunFlow;
    }

    public boolean isPending() {
        return this.m_isPending;
    }

    void setStartingPointInAllFlowArrayElements(boolean bl) {
        if (!this.isStartingPointToRerunFlow) {
            return;
        }
        this.isStartingPointInAllFlowArrayElements = bl;
    }

    public boolean isStartingPointInAllFlowArrayElements() {
        return this.isStartingPointInAllFlowArrayElements;
    }

    public boolean isOnHold() {
        return this.m_isOnHold;
    }

    void fromXML(Node node, JFFlow jFFlow, boolean bl) throws JFException {
        String string = new String();
        boolean bl2 = false;
        JFVersion jFVersion = JFConfigManager.getServerVersion();
        if (jFVersion != null && jFVersion.compareTo("5.5") < 0) {
            bl2 = true;
        }
        boolean bl3 = true;
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Object object;
            Node node2 = node.getChildNodes().item(i);
            if (node2.getNodeName().equals("id")) {
                this.id = Long.parseLong(node2.getFirstChild().getNodeValue());
            }
            if (node2.getNodeName().equals("name")) {
                this.name = node2.getFirstChild().getNodeValue();
            }
            if (node2.getNodeName().equals("jobDefinitionName")) {
                string = node2.getFirstChild().getNodeValue();
            }
            if (node2.getNodeName().equals("state")) {
                this.state = Integer.parseInt(node2.getFirstChild().getNodeValue());
            }
            if (node2.getNodeName().equals("details")) {
                this.detail = node2.getFirstChild().getNodeValue();
            }
            if (node2.getNodeName().equals("owner")) {
                this.owner = node2.getFirstChild().getNodeValue();
            }
            if (node2.getNodeName().equals("statusCode")) {
                this.statusCode = Integer.parseInt(node2.getFirstChild().getNodeValue());
            }
            if (node2.getNodeName().equals("startTime")) {
                if (bl2) {
                    try {
                        this.startTime = new JFTime(JFDateTimeParser.oldParse(node2.getFirstChild().getNodeValue()));
                    }
                    catch (ParseException parseException) {
                        JFDebug.println("JFFlowInstance::fromXML: wrong format of startTime " + parseException.getMessage());
                    }
                } else {
                    this.startTime = new JFTime(node2.getFirstChild());
                }
            }
            if (node2.getNodeName().equals("finishTime")) {
                if (bl2) {
                    try {
                        this.finishTime = new JFTime(JFDateTimeParser.oldParse(node2.getFirstChild().getNodeValue()));
                    }
                    catch (ParseException parseException) {
                        JFDebug.println("JFFlowInstance::fromXML: wrong format of finishTime " + parseException.getMessage());
                    }
                } else {
                    this.finishTime = new JFTime(node2.getFirstChild());
                }
            }
            if (node2.getNodeName().equals("CPUUsage")) {
                this.CPUUsage = Double.parseDouble(node2.getFirstChild().getNodeValue());
            }
            if (node2.getNodeName().equals("userCPUUsage")) {
                this.userCPUUsage = Double.parseDouble(node2.getFirstChild().getNodeValue());
            }
            if (node2.getNodeName().equals("submissionPid")) {
                this.submissionPid = Integer.parseInt(node2.getFirstChild().getNodeValue());
            }
            if (node2.getNodeName().equals("memoryUsage")) {
                this.memoryUsage = Double.parseDouble(node2.getFirstChild().getNodeValue());
            }
            if (node2.getNodeName().equals("swapUsage")) {
                this.swapUsage = Double.parseDouble(node2.getFirstChild().getNodeValue());
            }
            if (node2.getNodeName().equals("completionDescription")) {
                this.completionDescription = node2.getFirstChild().getNodeValue();
            }
            if (node2.getNodeName().equals("events")) {
                this.eventsFromXML_(node2, jFFlow);
            }
            if (node2.getNodeName().equals("isPending")) {
                this.m_isPending = new Boolean(node2.getFirstChild().getNodeValue());
            }
            if (node2.getNodeName().equals("isStartingPoint")) {
                object = new Boolean(node2.getFirstChild().getNodeValue());
                if (this.state == 7 || this.state == 9 || this.state == 5 || this.state == 3 || this.state == 8) {
                    this.isStartingPointToRerunFlow = (Boolean)object;
                }
            }
            if (node2.getNodeName().equals("isInAllElements")) {
                object = new Boolean(node2.getFirstChild().getNodeValue());
                if (this.isStartingPointToRerunFlow) {
                    this.isStartingPointInAllFlowArrayElements = (Boolean)object;
                }
            }
            if (node2.getNodeName().equals("isOnHold")) {
                this.m_isOnHold = new Boolean(node2.getFirstChild().getNodeValue());
                bl3 = false;
            }
            if (node2.getNodeName().equals("inputData") && (object = node2.getFirstChild()) != null) {
                this.m_inputData = object.getNodeValue();
            }
            if (!node2.getNodeName().equals("outputData") || (object = node2.getFirstChild()) == null) continue;
            this.m_outputData = object.getNodeValue();
        }
        if (bl) {
            JFJobArray jFJobArray = jFFlow.getJobArray(string);
            if (null == jFJobArray) {
                throw new JFException(JFResource.getString("JOB_ARRAY_NULL", new Object[]{string}));
            }
            this.jobDefinition = jFJobArray.getJobDefinition();
        } else {
            this.jobDefinition = jFFlow.getJob(string);
        }
        if (bl3 && "Yes".equals(this.jobDefinition.getAttribute("OnHold"))) {
            this.m_isOnHold = true;
        }
        if (null == this.jobDefinition) {
            throw new JFException(JFResource.getString("DEFN_NULL", new Object[]{string}));
        }
        if (this.jobDefinition.getExecutionType().equals("local")) {
            this.m_isPending = false;
        }
        if (this.owner == null) {
            this.owner = this.jobDefinition.getAttribute("UserName");
        }
        this.initializeEventInstances(jFFlow);
    }

    private void eventsFromXML_(Node node, JFFlow jFFlow) throws JFException {
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            JFEvent jFEvent;
            JFEventInstance jFEventInstance = new JFEventInstance();
            jFEventInstance.fromXML(node.getChildNodes().item(i));
            JFEvent jFEvent2 = jFEventInstance.getEventDefinition();
            String string = jFEvent2.getEventGeneratorType();
            if (string.equals("lsf") || string.equals("manual") || string.equals("otherbatch") || string.equals("local")) {
                jFEvent = (JFJobEvent)jFEvent2;
                jFEvent.m_jobRef = jFFlow.getJob(jFEvent.m_jobName);
            } else if (string.equals("variable")) {
                jFEvent = (JFVariableEvent)jFEvent2;
                ((JFVariableEvent)jFEvent).m_jobRef = jFFlow.getJob(((JFVariableEvent)jFEvent).m_jobName);
            } else if (string.equals("link")) {
                jFEvent = (JFLinkEvent)jFEvent2;
                jFEventInstance = new JFLinkEventInstance();
                jFEventInstance.fromXML(node.getChildNodes().item(i));
                ((JFLinkEvent)jFEventInstance.eventDefinition).m_linkJobRef = jFFlow.getJob(((JFLinkEvent)jFEvent).m_linkJobName);
            } else if (string.equals("flow")) {
                jFEvent = (JFFlowEvent)jFEvent2;
                ((JFFlowEvent)jFEvent).m_flowRef = jFFlow.getFlow(((JFFlowEvent)jFEvent).m_flowName);
            } else if (string.equals("jobarray")) {
                jFEvent = (JFJobArrayEvent)jFEvent2;
                ((JFJobArrayEvent)jFEvent).m_jobArrRef = jFFlow.getJobArray(((JFJobArrayEvent)jFEvent).m_jobArrName);
            } else if (string.equals("job_except")) {
                jFEvent = (JFJobExceptionEvent)jFEvent2;
                ((JFJobExceptionEvent)jFEvent).m_jobRef = jFFlow.getJob(((JFJobExceptionEvent)jFEvent).m_jobName);
            } else if (string.equals("jobarray_except")) {
                jFEvent = (JFJobArrayExceptionEvent)jFEvent2;
                ((JFJobArrayExceptionEvent)jFEvent).m_jobArrRef = jFFlow.getJobArray(((JFJobArrayExceptionEvent)jFEvent).m_jobArrName);
            } else if (string.equals("flow_except")) {
                jFEvent = (JFFlowExceptionEvent)jFEvent2;
                ((JFFlowExceptionEvent)jFEvent).m_flowRef = jFFlow.getFlow(((JFFlowExceptionEvent)jFEvent).m_flowName);
            } else if (string.equals("flowarray")) {
                jFEvent = (JFFlowArrayEvent)jFEvent2;
                ((JFFlowArrayEvent)jFEvent).m_flowArrRef = jFFlow.getFlowArray(((JFFlowArrayEvent)jFEvent).m_flowArrName);
            } else if (string.equals("flowarray_except")) {
                jFEvent = (JFFlowArrayExceptionEvent)jFEvent2;
                ((JFFlowArrayExceptionEvent)jFEvent).m_flowArrRef = jFFlow.getFlowArray(((JFFlowArrayExceptionEvent)jFEvent).m_flowArrName);
            }
            this.events.add(jFEventInstance);
        }
    }

    void initializeEventInstances(JFFlow jFFlow) {
        Iterator iterator = jFFlow.getEvents(this.getJobDefinition().getName());
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            JFEventInstance jFEventInstance;
            JFEvent jFEvent = (JFEvent)iterator.next();
            Iterator iterator2 = this.events.iterator();
            if (iterator2 == null) continue;
            boolean bl = false;
            while (iterator2.hasNext()) {
                jFEventInstance = (JFEventInstance)iterator2.next();
                if (!jFEventInstance.getEventDefinition().equalsWithPosition(jFEvent)) continue;
                if (jFEventInstance instanceof JFLinkEventInstance) {
                    jFEventInstance.eventDefinition = jFEvent;
                }
                bl = true;
                break;
            }
            if (bl) continue;
            jFEventInstance = null;
            jFEventInstance = !jFEvent.getEventGeneratorType().equals("link") ? new JFEventInstance() : new JFLinkEventInstance();
            jFEventInstance.eventDefinition = jFEvent;
            this.events.add(jFEventInstance);
        }
    }

    void addJFEventInstance(JFEventInstance jFEventInstance) {
        this.events.add(jFEventInstance);
    }

    void setOnHold(boolean bl) {
        this.m_isOnHold = bl;
    }

    void setJobDefintion(String string, JFFlow jFFlow, boolean bl, boolean bl2) throws JFException {
        if (bl) {
            JFJobArray jFJobArray = jFFlow.getJobArray(string);
            if (null == jFJobArray) {
                throw new JFException(JFResource.getString("JOB_ARRAY_NULL", new Object[]{string}));
            }
            this.jobDefinition = jFJobArray.getJobDefinition();
        } else {
            this.jobDefinition = jFFlow.getJob(string);
        }
        if (bl2 && "Yes".equals(this.jobDefinition.getAttribute("OnHold"))) {
            this.m_isOnHold = true;
        }
        if (null == this.jobDefinition) {
            throw new JFException(JFResource.getString("DEFN_NULL", new Object[]{string}));
        }
        if (this.jobDefinition.getExecutionType().equals("local")) {
            this.m_isPending = false;
        }
        if (this.owner == null) {
            this.owner = this.jobDefinition.getAttribute("UserName");
        }
    }

    void setJFJobInstanceAttributes(String string, String string2) {
        Boolean bl;
        if (string.equals("id")) {
            this.id = Long.parseLong(string2);
        }
        if (string.equals("name")) {
            this.name = string2;
        }
        if (string.equals("state")) {
            this.state = Integer.parseInt(string2);
        }
        if (string.equals("owner")) {
            this.owner = string2;
        }
        if (string.equals("statusCode")) {
            this.statusCode = Integer.parseInt(string2);
        }
        if (string.equals("CPUUsage")) {
            this.CPUUsage = Double.parseDouble(string2);
        }
        if (string.equals("userCPUUsage")) {
            this.userCPUUsage = Double.parseDouble(string2);
        }
        if (string.equals("submissionPid")) {
            this.submissionPid = Integer.parseInt(string2);
        }
        if (string.equals("memoryUsage")) {
            this.memoryUsage = Double.parseDouble(string2);
        }
        if (string.equals("detail")) {
            this.detail = string2;
        }
        if (string.equals("swapUsage")) {
            this.swapUsage = Double.parseDouble(string2);
        }
        if (string.equals("completionDescription")) {
            this.completionDescription = string2;
        }
        if (string.equals("isPending")) {
            this.m_isPending = new Boolean(string2);
        }
        if (string.equals("isStartingPoint")) {
            bl = new Boolean(string2);
            if (this.state == 7 || this.state == 9 || this.state == 5 || this.state == 3 || this.state == 8) {
                this.isStartingPointToRerunFlow = bl;
            }
        }
        if (string.equals("isInAllElements")) {
            bl = new Boolean(string2);
            if (this.isStartingPointToRerunFlow) {
                this.isStartingPointInAllFlowArrayElements = bl;
            }
        }
        if (string.equals("inputData")) {
            this.m_inputData = string2;
        }
        if (string.equals("outputData")) {
            this.m_outputData = string2;
        }
    }
}

