/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFEvent;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFJobArray;
import com.platform.LSFJobFlow.api.JFResource;
import java.text.MessageFormat;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class JFJobArrayEvent
extends JFEvent {
    public static final String EVENT_GENERATOR_TYPE = "jobarray";
    public static final int JOBARRAY_DONE = 0;
    public static final int JOBARRAY_END = 1;
    public static final int JOBARRAY_EXIT = 2;
    public static final int JOBARRAY_SUBMITTED = 3;
    public static final int JOBARRAY_FAIL = 4;
    public static final int JOBARRAY_NUMDONE = 10;
    public static final int JOBARRAY_NUMEXIT = 11;
    public static final int JOBARRAY_NUMEND = 12;
    public static final int JOBARRAY_NUMSTART = 13;
    public static final int JOBARRAY_ELEMENTDONE = 20;
    public static final int JOBARRAY_ELEMENTEXIT = 21;
    public static final int JOBARRAY_ELEMENTEND = 22;
    public static final int JOBARRAY_ELEMENTSTART = 23;
    public static final String OP_EQ = "==";
    public static final String OP_GT = ">";
    public static final String OP_GTE = ">=";
    public static final String OP_LT = "<";
    public static final String OP_LTE = "<=";
    public static final String OP_NEQ = "!=";
    private int m_eventType = -1;
    private String m_eventParent = "";
    String m_jobArrName = "";
    JFJobArray m_jobArrRef = null;
    String m_comparisonOp = null;
    int m_comparisonValue = 0;

    public JFJobArrayEvent(String string, int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                throw new IllegalArgumentException(JFResource.getString("JOBARREVENT_INIT_TYPE"));
            }
            default: {
                throw new IllegalArgumentException(JFResource.getString("JOBARREVENT_INVALID_TYPE"));
            }
        }
        this.m_jobArrName = string;
        this.m_eventType = n;
        this.setProxy(true);
    }

    public JFJobArrayEvent(String string, int n, String string2, int n2) {
        switch (n) {
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                this.validateOperator(string2, n2, false);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                this.validateOperator(string2, n2, true);
                break;
            }
            default: {
                throw new IllegalArgumentException(JFResource.getString("JOBARREVENT_INVALID_TYPE"));
            }
        }
        this.m_jobArrName = string;
        this.m_eventType = n;
        this.m_comparisonValue = n2;
        this.m_comparisonOp = string2;
        this.setProxy(true);
    }

    public JFJobArrayEvent(JFJobArray jFJobArray, int n) {
        if (jFJobArray == null) {
            throw new NullPointerException(JFResource.getString("EVENT_NULL"));
        }
        switch (n) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 20: 
            case 22: 
            case 23: {
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 21: {
                throw new IllegalArgumentException(JFResource.getString("JOBARREVENT_INIT_TYPE"));
            }
            default: {
                throw new IllegalArgumentException(JFResource.getString("JOBARREVENT_INVALID_TYPE"));
            }
        }
        this.m_eventType = n;
        this.m_jobArrRef = jFJobArray;
        this.setProxy(false);
    }

    public JFJobArrayEvent(JFJobArray jFJobArray, int n, String string, int n2) {
        if (jFJobArray == null) {
            throw new NullPointerException(JFResource.getString("EVENT_NULL"));
        }
        switch (n) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 20: 
            case 22: 
            case 23: {
                break;
            }
            case 2: 
            case 21: {
                this.validateOperator(string, n2, false);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                this.validateOperator(string, n2, true);
                break;
            }
            default: {
                throw new IllegalArgumentException(JFResource.getString("JOBARREVENT_INVALID_TYPE"));
            }
        }
        this.m_comparisonValue = n2;
        this.m_comparisonOp = string;
        this.m_eventType = n;
        this.m_jobArrRef = jFJobArray;
        this.setProxy(false);
    }

    @Override
    public boolean isProxy() {
        String string = this.getAttribute("IsProxy");
        return string != null && string.equals("Yes");
    }

    private void setProxy(boolean bl) {
        if (bl) {
            this.setAttribute("IsProxy", "Yes");
        } else {
            this.setAttribute("IsProxy", "No");
        }
    }

    public int getEventType() {
        return this.m_eventType;
    }

    public JFJobArray getEventJobArray() {
        return this.m_jobArrRef;
    }

    public String getComparisonOp() {
        switch (this.m_eventType) {
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 21: {
                break;
            }
            default: {
                throw new IllegalStateException(JFResource.getString("JOBARREVENT_INCOM_TYPE"));
            }
        }
        return this.m_comparisonOp;
    }

    public int getComparisonValue() {
        switch (this.m_eventType) {
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 21: {
                break;
            }
            default: {
                throw new IllegalStateException(JFResource.getString("JOBARREVENT_INCOM_TYPE"));
            }
        }
        return this.m_comparisonValue;
    }

    public JFJobArrayEvent() {
    }

    @Override
    public String getEventGeneratorType() {
        return EVENT_GENERATOR_TYPE;
    }

    @Override
    public void initFromDefinition(String string) throws JFException {
        block33: {
            if (string == null) {
                throw new NullPointerException(JFResource.getString("EVENT_DEFN_NULL"));
            }
            try {
                int n = string.indexOf(40);
                int n2 = string.lastIndexOf(41);
                String string2 = string.substring(0, n);
                if (string2.equalsIgnoreCase("Done")) {
                    this.m_eventType = 0;
                } else if (string2.equalsIgnoreCase("End")) {
                    this.m_eventType = 1;
                } else if (string2.equalsIgnoreCase("Exit")) {
                    this.m_eventType = 2;
                } else if (string2.equalsIgnoreCase("New")) {
                    this.m_eventType = 3;
                } else if (string2.equalsIgnoreCase("Fail")) {
                    this.m_eventType = 4;
                } else if (string2.equalsIgnoreCase("NumDone")) {
                    this.m_eventType = 10;
                } else if (string2.equalsIgnoreCase("NumExit")) {
                    this.m_eventType = 11;
                } else if (string2.equalsIgnoreCase("NumStart")) {
                    this.m_eventType = 13;
                } else if (string2.equalsIgnoreCase("NumEnd")) {
                    this.m_eventType = 12;
                } else if (string2.equalsIgnoreCase("ElementDone")) {
                    this.m_eventType = 20;
                } else if (string2.equalsIgnoreCase("ElementExit")) {
                    this.m_eventType = 21;
                } else if (string2.equalsIgnoreCase("ElementEnd")) {
                    this.m_eventType = 22;
                } else if (string2.equalsIgnoreCase("ElementStart")) {
                    this.m_eventType = 23;
                }
                String string3 = string.substring(n + 1, n2);
                switch (this.m_eventType) {
                    case 0: 
                    case 1: 
                    case 3: 
                    case 4: 
                    case 20: 
                    case 22: 
                    case 23: {
                        this.m_jobArrName = string3;
                        break;
                    }
                    case 2: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 21: {
                        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                        this.m_jobArrName = stringTokenizer.nextToken().trim();
                        this.m_comparisonOp = stringTokenizer.nextToken().trim();
                        this.m_comparisonValue = Integer.valueOf(stringTokenizer.nextToken().trim());
                        break;
                    }
                    default: {
                        throw new JFException(JFResource.getString("JOBARREVENT_DEFN_TYPE", new Object[]{string2}));
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new JFException(JFResource.getString("JOBARREVENT_DEFN_NAN"));
            }
            catch (NoSuchElementException noSuchElementException) {
                if (this.m_eventType == 2) break block33;
                throw new JFException(JFResource.getString("EVENT_DEFN_INC"));
            }
        }
    }

    public void initFromCLIDefinition(String string) throws JFException {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("EVENT_DEFN_NULL"));
        }
        int n = string.indexOf(40);
        int n2 = string.indexOf(41);
        if (n == -1 || n2 == -1 || n2 - n <= 1) {
            throw new JFException(JFResource.getString("JOBARREVENT_DEFN_NO_NAME"));
        }
        String string2 = string.substring(0, n).trim();
        if (string2.equalsIgnoreCase("Done")) {
            this.m_eventType = 0;
        } else if (string2.equalsIgnoreCase("End")) {
            this.m_eventType = 1;
        } else if (string2.equalsIgnoreCase("New")) {
            this.m_eventType = 3;
        } else if (string2.equalsIgnoreCase("Exit")) {
            this.m_eventType = 2;
        } else if (string2.equalsIgnoreCase("Fail")) {
            this.m_eventType = 4;
        } else if (string2.equalsIgnoreCase("NumDone")) {
            this.m_eventType = 10;
        } else if (string2.equalsIgnoreCase("NumExit")) {
            this.m_eventType = 11;
        } else if (string2.equalsIgnoreCase("NumStart")) {
            this.m_eventType = 13;
        } else if (string2.equalsIgnoreCase("NumEnd")) {
            this.m_eventType = 12;
        } else {
            throw new JFException(JFResource.getString("JOBARREVENT_INVALID_TYPE"));
        }
        this.m_jobArrName = string.substring(n + 1, n2).trim();
        if (this.m_jobArrName.length() == 0) {
            throw new JFException(JFResource.getString("JOBARREVENT_DEFN_NO_NAME"));
        }
        String string3 = string.substring(n2 + 1).trim();
        boolean bl = false;
        switch (this.m_eventType) {
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                if (string3.length() <= 0) break;
                throw new JFException(JFResource.getString("JOBARREVENT_INCOM_TYPE"));
            }
            case 2: {
                bl = true;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                int n3 = this.findFirstNotOf(string3, "!<>=");
                if (n3 == -1) {
                    throw new JFException(JFResource.getString("JOBARREVENT_DEFN_NO_VALUE"));
                }
                this.m_comparisonOp = string3.substring(0, n3).trim();
                String string4 = string3.substring(n3).trim();
                try {
                    this.m_comparisonValue = Integer.valueOf(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JFException(JFResource.getString("JOBARREVENT_DEFN_NAN"));
                }
                this.validateOperator(this.m_comparisonOp, this.m_comparisonValue, !bl);
                break;
            }
            default: {
                throw new JFException(JFResource.getString("JOBARREVENT_INVALID_TYPE"));
            }
        }
        this.setProxy(true);
    }

    private int findFirstNotOf(String string, String string2) {
        if (string == null || string2 == null) {
            return -1;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (string2.indexOf(string.charAt(i)) != -1) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String generateDefinition() {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append(this.eventType());
        stringBuffer.append("(");
        stringBuffer.append(this.getFullWorkItemName());
        switch (this.m_eventType) {
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 21: {
                stringBuffer.append("," + this.m_comparisonOp + "," + this.m_comparisonValue);
            }
        }
        stringBuffer.append(")");
        this.m_eventParent = "";
        return stringBuffer.toString();
    }

    @Override
    String getFullWorkItemName() {
        String string = "";
        if (!this.isProxy()) {
            string = string + this.m_eventParent;
        }
        string = string + this.getJobArrayName();
        return string;
    }

    private String eventType() {
        switch (this.m_eventType) {
            case 0: {
                return "Done";
            }
            case 1: {
                return "End";
            }
            case 3: {
                return "New";
            }
            case 2: {
                return "Exit";
            }
            case 4: {
                return "Fail";
            }
            case 10: {
                return "NumDone";
            }
            case 11: {
                return "NumExit";
            }
            case 13: {
                return "NumStart";
            }
            case 12: {
                return "NumEnd";
            }
            case 20: {
                return "ElementDone";
            }
            case 21: {
                return "ElementExit";
            }
            case 22: {
                return "ElementEnd";
            }
            case 23: {
                return "ElementStart";
            }
        }
        return "";
    }

    private String eventTypeDesc() {
        switch (this.m_eventType) {
            case 0: {
                return JFResource.getString("EVENT_DESC_JOBARRAY_DONE");
            }
            case 1: {
                return JFResource.getString("EVENT_DESC_JOBARRAY_END");
            }
            case 3: {
                return JFResource.getString("EVENT_DESC_JOBARRAY_SUBMITTED");
            }
            case 2: {
                return JFResource.getString("EVENT_DESC_JOBARRAY_EXIT");
            }
            case 4: {
                return JFResource.getString("EVENT_DESC_JOBARRAY_FAIL");
            }
            case 10: {
                return JFResource.getString("EVENT_DESC_JOBARRAY_NUMDONE");
            }
            case 11: {
                return JFResource.getString("EVENT_DESC_JOBARRAY_NUMEXIT");
            }
            case 13: {
                return JFResource.getString("EVENT_DESC_JOBARRAY_NUMSTART");
            }
            case 12: {
                return JFResource.getString("EVENT_DESC_JOBARRAY_NUMEND");
            }
            case 20: {
                return JFResource.getString("EVENT_DESC_JOBARRAY_ELEMENTDONE");
            }
            case 21: {
                return JFResource.getString("EVENT_DESC_JOBARRAY_ELEMENTEXIT");
            }
            case 22: {
                return JFResource.getString("EVENT_DESC_JOBARRAY_ELEMENTEND");
            }
            case 23: {
                return JFResource.getString("EVENT_DESC_JOBARRAY_ELEMENTSTART");
            }
        }
        return "";
    }

    private String opDesc() {
        if (this.m_comparisonOp.equals(OP_EQ)) {
            return JFResource.getString("OP_DESC_EQUAL_TO");
        }
        if (this.m_comparisonOp.equals(OP_GT)) {
            return JFResource.getString("OP_DESC_GREATER_THAN");
        }
        if (this.m_comparisonOp.equals(OP_GTE)) {
            return JFResource.getString("OP_DESC_GREATER_THAN_OR_EQUAL_TO");
        }
        return "";
    }

    public String getJobArrayName() {
        if (this.isProxy()) {
            return this.m_jobArrName;
        }
        if (this.m_jobArrRef != null) {
            return this.m_jobArrRef.getName();
        }
        return this.m_jobArrName;
    }

    void setJobArrayName(String string) {
        if (this.isProxy()) {
            this.m_jobArrName = string;
        } else {
            if (this.m_jobArrRef != null) {
                this.m_jobArrRef.setName(string);
            }
            this.m_jobArrName = string;
        }
    }

    @Override
    void setParentName(String string) {
        if (!string.equals("")) {
            this.m_eventParent = string + ":";
        }
    }

    @Override
    public String toString() {
        return this.getJobArrayName() + " " + this.getExpression();
    }

    @Override
    public String getEventTypeDescription() {
        String string = this.eventTypeDesc();
        String string2 = "";
        String string3 = "";
        switch (this.m_eventType) {
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 21: {
                string2 = string2 + this.opDesc();
                string3 = string3 + this.m_comparisonValue;
                break;
            }
        }
        Object[] objectArray = new Object[]{string, string2, string3};
        String string4 = JFResource.getString("EVENT_TYPE_DESCRIPTION");
        MessageFormat messageFormat = new MessageFormat(string4);
        return messageFormat.format(objectArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateOperator(String string, int n, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException(JFResource.getString("JOBARREVENT_DEFN_INVALID_OP"));
        }
        if (bl) {
            if (string.equals(OP_GT)) {
                if (n >= 0) return;
                throw new IllegalArgumentException(JFResource.getString("JOBARREVENT_DEFN_NEG_VAL"));
            }
            if (!string.equals(OP_GTE) && !string.equals(OP_EQ)) throw new IllegalArgumentException(JFResource.getString("JOBARREVENT_DEFN_INVALID_OP"));
            if (n > 0) return;
            throw new IllegalArgumentException(JFResource.getString("JOBARREVENT_DEFN_NOT_POSITIVE_VAL"));
        }
        if (!string.equals(OP_GT) && !string.equals(OP_GTE) && !string.equals(OP_EQ) && !string.equals(OP_LT) && !string.equals(OP_LTE) && !string.equals(OP_NEQ)) throw new IllegalArgumentException(JFResource.getString("JOBARREVENT_DEFN_INVALID_OP"));
    }

    @Override
    public void setEventObject(Object object) {
        this.m_jobArrRef = (JFJobArray)object;
    }

    @Override
    public String getExpression() {
        String string = "";
        switch (this.m_eventType) {
            case 0: {
                string = "All jobs succeed";
                break;
            }
            case 1: {
                string = "All jobs end";
                break;
            }
            case 3: {
                string = "Submitted";
                break;
            }
            case 2: {
                string = "Sum of exit codes " + (this.m_comparisonOp == null ? "" : this.m_comparisonOp) + " " + this.m_comparisonValue;
                break;
            }
            case 4: {
                string = "Any job fails";
                break;
            }
            case 10: {
                string = "Succeeded jobs " + (this.m_comparisonOp == null ? "" : this.m_comparisonOp) + " " + this.m_comparisonValue;
                break;
            }
            case 11: {
                string = "Failed jobs " + (this.m_comparisonOp == null ? "" : this.m_comparisonOp) + " " + this.m_comparisonValue;
                break;
            }
            case 13: {
                string = "Started jobs " + (this.m_comparisonOp == null ? "" : this.m_comparisonOp) + " " + this.m_comparisonValue;
                break;
            }
            case 12: {
                string = "Ended jobs " + (this.m_comparisonOp == null ? "" : this.m_comparisonOp) + " " + this.m_comparisonValue;
                break;
            }
            case 20: {
                string = "Element succeeds";
                break;
            }
            case 21: {
                string = "Element exit code " + (this.m_comparisonOp == null ? "" : this.m_comparisonOp) + " " + this.m_comparisonValue;
                break;
            }
            case 22: {
                string = "Element ends";
                break;
            }
            case 23: {
                string = "Element starts";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    @Override
    public String getTooltip(String string, String string2) {
        String string3 = "";
        switch (this.m_eventType) {
            case 0: {
                string3 = "If all jobs in " + string + " succeed then " + string2;
                break;
            }
            case 1: {
                string3 = "If all jobs in " + string + " end then " + string2;
                break;
            }
            case 3: {
                string3 = "If " + string + " is submitted then " + string2;
                break;
            }
            case 2: {
                string3 = "If sum of exit codes of all jobs in " + string + " is " + this.opDesc() + " " + this.m_comparisonValue + " then " + string2;
                break;
            }
            case 4: {
                string3 = "Any job in " + string + " fails then " + string2;
                break;
            }
            case 10: {
                string3 = "If jobs succeeded in " + string + " is " + this.opDesc() + " " + this.m_comparisonValue + " then " + string2;
                break;
            }
            case 11: {
                string3 = "If jobs failed in " + string + " is " + this.opDesc() + " " + this.m_comparisonValue + " then " + string2;
                break;
            }
            case 13: {
                string3 = "If jobs started in " + string + " is " + this.opDesc() + " " + this.m_comparisonValue + " then " + string2;
                break;
            }
            case 12: {
                string3 = "If jobs ended in " + string + " is " + this.opDesc() + " " + this.m_comparisonValue + " then " + string2;
                break;
            }
            case 20: {
                string3 = "If all elements in " + string + " succeed then " + string2;
                break;
            }
            case 21: {
                string3 = "If an element in " + string + " exits with exit code " + this.opDesc() + " " + this.m_comparisonValue + " then " + string2;
                break;
            }
            case 22: {
                string3 = "If all elements in " + string + " end then " + string2;
                break;
            }
            case 23: {
                string3 = "If all elements in " + string + " start then " + string2;
                break;
            }
            default: {
                string3 = "";
            }
        }
        return string3;
    }
}

