/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFAdminManager;
import com.platform.LSFJobFlow.api.JFConfigManager;
import com.platform.LSFJobFlow.api.JFDateTimeParser;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFResource;
import com.platform.LSFJobFlow.api.JFVersion;
import java.text.MessageFormat;
import java.util.Date;
import java.util.TimeZone;

public class JFFilter {
    private String m_user = null;
    private int m_numOfHours = -1;
    private String m_startTimeStr = null;
    private String m_finishTimeStr = null;
    private Date m_startTime = null;
    private Date m_finishTime = null;
    private boolean m_isEmpty = true;

    public boolean isEmpty() {
        return this.m_isEmpty;
    }

    public void setUser(String string) {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("USER_NULL"));
        }
        this.m_user = string;
        this.m_isEmpty = false;
    }

    public void setTimeRange(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(JFResource.getString("HOURS_NOT_POSITIVE"));
        }
        this.m_numOfHours = n;
        this.m_isEmpty = false;
    }

    public void setTimeRange(String string, String string2) throws JFException {
        if (string == null || string2 == null) {
            throw new NullPointerException(JFResource.getString("START_OR_FINISH_NULL"));
        }
        JFDateTimeParser jFDateTimeParser = new JFDateTimeParser("yyyy/MM/dd HH:mm:ss");
        int n = JFConfigManager.getTimeZoneFlag();
        TimeZone timeZone = null;
        if (n == 1) {
            JFVersion jFVersion = JFConfigManager.getServerVersion();
            if (jFVersion == null || jFVersion.compareTo("5.5") >= 0) {
                timeZone = TimeZone.getTimeZone(new JFAdminManager().getServerTimeZone());
            }
        } else if (n == 2) {
            timeZone = TimeZone.getTimeZone("GMT");
        }
        jFDateTimeParser.setTimeZone(timeZone);
        try {
            this.m_startTime = jFDateTimeParser.parse(string);
            this.m_startTimeStr = string;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{string};
            String string3 = JFResource.getString("time_T_invalid");
            MessageFormat messageFormat = new MessageFormat(string3);
            throw new JFException(messageFormat.format(objectArray));
        }
        try {
            this.m_finishTime = jFDateTimeParser.parse(string2);
            this.m_finishTimeStr = string2;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{string2};
            String string4 = JFResource.getString("time_T_invalid");
            MessageFormat messageFormat = new MessageFormat(string4);
            throw new JFException(messageFormat.format(objectArray));
        }
        this.m_isEmpty = false;
    }

    public String getUser() {
        return this.m_user;
    }

    public String getStartTime() {
        return this.m_startTimeStr;
    }

    public String getFinishTime() {
        return this.m_finishTimeStr;
    }

    public int getNumOfHours() {
        return this.m_numOfHours;
    }

    String toJMSUserSelector() {
        if (this.m_user == null || this.m_user.equals("")) {
            return null;
        }
        return "UserName IS NULL OR UserName = '" + this.m_user + "'";
    }

    public String toString() {
        if (this.m_isEmpty) {
            return null;
        }
        String string = "Filter:";
        if (this.m_user != null) {
            string = string + "<user>=" + this.m_user;
        }
        if (this.m_numOfHours > 0) {
            string = string + "  <timerange>=last " + String.valueOf(this.m_numOfHours) + " hours";
        } else if (this.m_startTimeStr != null && this.m_finishTimeStr != null) {
            string = string + "  <timerange>=[" + this.m_startTimeStr + "," + this.m_finishTimeStr + "]";
        }
        return string;
    }

    public boolean includingCurrentRunningFlow() {
        if (this.m_isEmpty) {
            return true;
        }
        if (this.m_numOfHours > 0) {
            return true;
        }
        if (this.m_finishTime == null) {
            return true;
        }
        Date date = new Date();
        return date.compareTo(this.m_finishTime) <= 0;
    }

    String toXML() {
        boolean bl = false;
        JFVersion jFVersion = JFConfigManager.getServerVersion();
        if (jFVersion != null && jFVersion.compareTo("5.5") < 0) {
            bl = true;
        }
        String string = null;
        if (this.m_user != null) {
            string = "user=" + this.m_user;
        }
        if (this.m_numOfHours != -1) {
            string = string != null ? string + ";range=" + this.m_numOfHours : "range=" + this.m_numOfHours;
        } else if (this.m_startTime != null && this.m_finishTime != null) {
            string = string != null ? string + ";range=" : "range=";
            string = bl ? string + this.m_startTimeStr + "-" + this.m_finishTimeStr : string + String.valueOf(this.m_startTime.getTime() / 1000L) + "-" + String.valueOf(this.m_finishTime.getTime() / 1000L);
        }
        return string;
    }
}

