/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.CommBrokerINF;
import com.platform.LSFJobFlow.api.HTTPcommBroker;
import java.io.IOException;
import java.util.LinkedList;

class ConnectionFactory {
    private static final int DEFAULT_POOL_SIZE = 5;
    private static ConnectionFactory curObj = null;
    private LinkedList brokersPool = null;
    private int maxPoolSize = 0;

    private ConnectionFactory() {
        this.maxPoolSize = 5;
        this.brokersPool = new LinkedList();
    }

    private ConnectionFactory(int n) {
        this.maxPoolSize = n;
        this.brokersPool = new LinkedList();
    }

    public static synchronized ConnectionFactory getInstance() {
        if (curObj == null) {
            curObj = new ConnectionFactory();
        }
        return curObj;
    }

    public static synchronized ConnectionFactory getInstance(int n) {
        if (curObj == null) {
            curObj = new ConnectionFactory(n);
        }
        return curObj;
    }

    public synchronized CommBrokerINF getCommBroker(int n, String string, int n2, boolean bl) throws IOException {
        CommBrokerINF commBrokerINF = null;
        if (this.brokersPool != null) {
            for (int i = 0; i < this.brokersPool.size(); ++i) {
                commBrokerINF = (CommBrokerINF)this.brokersPool.get(i);
                if (!commBrokerINF.equal(string, n)) continue;
                this.brokersPool.remove(i);
                commBrokerINF.setTimeout(n2);
                return commBrokerINF;
            }
        }
        switch (n) {
            case 1: {
                commBrokerINF = new HTTPcommBroker(string, n2);
                commBrokerINF.setEncrypt(bl);
                break;
            }
        }
        return commBrokerINF;
    }

    public synchronized void releaseCommBroker(CommBrokerINF commBrokerINF) {
        if (this.brokersPool.size() < this.maxPoolSize) {
            this.brokersPool.add(commBrokerINF);
        }
    }
}

