/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.GlobalInfoTable;
import com.sas.codepolicy.SASScope;
import com.sas.security.BaseSecuritySupport;
import com.sas.text.Message;
import com.sas.visuals.RB;
import com.sas.visuals.SASIcons;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.PropertyResourceBundle;
import javax.swing.ImageIcon;

@SASScope(value="ALL")
public class Resources
extends PropertyResourceBundle {
    public static final String RB_KEY = "Resources.";
    static final Class resClass = GlobalInfoTable._loadClass("com.sas.visuals.Resources");
    public static final String PREFIX = "res/";
    public static final String SUFFIX = ".gif";
    private static Hashtable images;
    private static Hashtable imageIcons;
    private static final int BLOCK_SIZE = 1024;
    public static final int ICON_16 = 16;
    public static final int ICON_24 = 24;
    public static final int ICON_32 = 32;
    public static final int ICON_48 = 48;

    public Resources() throws IOException {
        super(BaseSecuritySupport.securitySupport.getResourceAsStream(resClass, "Resources.properties"));
    }

    public Resources(InputStream stream) throws IOException {
        super(stream);
    }

    public static synchronized Image getImageFromStream(InputStream iStrm) throws IOException {
        byte[] accumulator = new byte[]{0};
        byte[] tmpBuffer = new byte[1024];
        int count = 0;
        int numRead = 0;
        while ((numRead = iStrm.read(tmpBuffer, 0, 1024)) != -1) {
            byte[] oldAcc = accumulator;
            accumulator = new byte[numRead + count];
            System.arraycopy(oldAcc, 0, accumulator, 0, count);
            System.arraycopy(tmpBuffer, 0, accumulator, count, numRead);
            count += numRead;
        }
        return Toolkit.getDefaultToolkit().createImage(accumulator);
    }

    private static Image loadImage(Class loadClass, String imageName) {
        try {
            InputStream is = BaseSecuritySupport.securitySupport.getResourceAsStream(loadClass, imageName);
            if (is != null) {
                Image image = Resources.getImageFromStream(is);
                images.put(loadClass.getName() + imageName, image);
                return image;
            }
        }
        catch (IOException e) {
            String msg = Message.format(RB.getStringResource(RB_KEY, "imageLoadError.ex.txt"), (Object)imageName, (Object)loadClass.getName());
            throw new IllegalArgumentException(msg);
        }
        return null;
    }

    private static Image loadImage(Class loadClass, String imageName, int size) {
        try {
            InputStream is = BaseSecuritySupport.securitySupport.getResourceAsStream(loadClass, imageName);
            if (is != null) {
                Image image = Resources.getImageFromStream(is);
                images.put(loadClass.getName() + imageName + "#" + size, image);
                return image;
            }
        }
        catch (IOException e) {
            String msg = Message.format(RB.getStringResource(RB_KEY, "imageLoadError.ex.txt"), (Object)imageName, (Object)loadClass.getName());
            throw new IllegalArgumentException(msg);
        }
        return null;
    }

    public static synchronized Image getImage(String imageName) {
        return Resources.getImage(SASIcons.class, imageName);
    }

    public static synchronized Image getImage(Class loadClass, String imageName) {
        int i;
        if (images == null) {
            images = new Hashtable();
        }
        Image image = null;
        String[] possibleImageNames = Resources.getValidImageNameKeys(imageName);
        for (i = 0; i < possibleImageNames.length; ++i) {
            image = (Image)images.get(loadClass.getName() + possibleImageNames[i]);
            if (image == null) continue;
            return image;
        }
        for (i = 0; i < possibleImageNames.length; ++i) {
            image = Resources.loadImage(loadClass, possibleImageNames[i]);
            if (image == null) continue;
            return image;
        }
        String msg = Message.format(RB.getStringResource(RB_KEY, "noSuchImage.ex.txt"), (Object)imageName, (Object)loadClass.getName());
        throw new IllegalArgumentException(msg);
    }

    public static synchronized Image getImage(String imageName, int size) {
        return Resources.getImage(SASIcons.class, imageName, size);
    }

    public static synchronized Image getImage(Class loadClass, String imageName, int size) {
        int i;
        if (images == null) {
            images = new Hashtable();
        }
        Image image = null;
        String[] possibleImageNames = Resources.getValidImageNameKeys(imageName, size);
        for (i = 0; i < possibleImageNames.length; ++i) {
            image = (Image)images.get(loadClass.getName() + possibleImageNames[i] + "#" + size);
            if (image == null) continue;
            return image;
        }
        for (i = 0; i < possibleImageNames.length; ++i) {
            image = Resources.loadImage(loadClass, possibleImageNames[i], size);
            if (image == null) continue;
            return image;
        }
        String msg = Message.format(RB.getStringResource(RB_KEY, "noSuchImage.ex.txt"), (Object)imageName, (Object)loadClass.getName());
        throw new IllegalArgumentException(msg);
    }

    public static synchronized void reset() {
        images = new Hashtable();
        imageIcons = new Hashtable();
    }

    public static synchronized ImageIcon getImageIcon(String imageName) {
        return Resources.getImageIcon(SASIcons.class, imageName);
    }

    public static synchronized ImageIcon getImageIcon(Class loadClass, String imageName) {
        if (imageIcons == null) {
            imageIcons = new Hashtable();
        }
        ImageIcon imageIcon = null;
        String[] possibleImageNames = Resources.getValidImageNameKeys(imageName);
        for (int i = 0; i < possibleImageNames.length; ++i) {
            imageIcon = (ImageIcon)imageIcons.get(loadClass.getName() + possibleImageNames[i]);
            if (imageIcon == null) continue;
            return imageIcon;
        }
        Image image = Resources.getImage(loadClass, imageName);
        if (image != null) {
            imageIcon = new ImageIcon(image);
            imageIcons.put(loadClass.getName() + imageName, imageIcon);
        }
        return imageIcon;
    }

    public static synchronized ImageIcon getImageIcon(String imageName, int size) {
        return Resources.getImageIcon(SASIcons.class, imageName, size);
    }

    public static synchronized ImageIcon getImageIcon(Class loadClass, String imageName, int size) {
        if (imageIcons == null) {
            imageIcons = new Hashtable();
        }
        ImageIcon imageIcon = null;
        String[] possibleImageNames = Resources.getValidImageNameKeys(imageName, size);
        for (int i = 0; i < possibleImageNames.length; ++i) {
            imageIcon = (ImageIcon)imageIcons.get(loadClass.getName() + possibleImageNames[i] + "#" + size);
            if (imageIcon == null) continue;
            return imageIcon;
        }
        Image image = Resources.getImage(loadClass, imageName, size);
        if (image != null) {
            imageIcon = new ImageIcon(image);
            imageIcons.put(loadClass.getName() + imageName + "#" + size, imageIcon);
        }
        return imageIcon;
    }

    public static synchronized ImageIcon getImageIconFromStream(InputStream iStrm) throws IOException {
        Image image = Resources.getImageFromStream(iStrm);
        ImageIcon imageIcon = null;
        if (image != null) {
            imageIcon = new ImageIcon(image);
        }
        return imageIcon;
    }

    private static String[] getValidImageNameKeys(String imageName) {
        return Resources.getValidImageNameKeys(imageName, -1);
    }

    private static String[] getValidImageNameKeys(String imageName, int size) {
        if (imageName != null) {
            String altName;
            ArrayList<String> names = new ArrayList<String>();
            names.add(imageName);
            boolean suffixAdded = false;
            if (!imageName.endsWith(SUFFIX) && imageName.indexOf(".") < 0) {
                altName = imageName + SUFFIX;
                names.add(altName);
                suffixAdded = true;
            }
            if (size == -1) {
                if (!imageName.startsWith(PREFIX)) {
                    altName = PREFIX + imageName;
                    names.add(altName);
                    if (suffixAdded) {
                        names.add(altName + SUFFIX);
                    }
                }
            } else if (!imageName.startsWith("res/GIF_" + size + "/")) {
                altName = "res/GIF_" + size + "/" + imageName;
                names.add(altName);
                if (suffixAdded) {
                    names.add(altName + SUFFIX);
                }
            }
            return names.toArray(new String[0]);
        }
        return new String[0];
    }

    @SASScope
    public static synchronized InputStream getImageStream(String imageName) {
        return Resources.getImageStream(imageName, -1);
    }

    @SASScope
    public static synchronized InputStream getImageStream(String imageName, int size) {
        Class<SASIcons> loadClass = SASIcons.class;
        return Resources.getImageStream(loadClass, imageName, size);
    }

    @SASScope
    public static synchronized InputStream getImageStream(Class loaderClass, String imageName, int size) {
        Class loadClass = loaderClass;
        String[] possibleImageNames = Resources.getValidImageNameKeys(imageName, size);
        for (int i = 0; i < possibleImageNames.length; ++i) {
            InputStream is = BaseSecuritySupport.securitySupport.getResourceAsStream(loadClass, possibleImageNames[i]);
            if (is == null) continue;
            return is;
        }
        String msg = Message.format(RB.getStringResource(RB_KEY, "noSuchImage.ex.txt"), (Object)imageName, (Object)loadClass.getName());
        throw new IllegalArgumentException(msg);
    }
}

