/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.login;

import com.sas.util.login.LoginBeanActionInterface;
import com.sas.util.login.LoginBeanValidateInterface;
import com.sas.util.login.RB;

public class LoginBean {
    public static String RB_KEY = "LoginBean.";
    protected String title;
    protected String username = null;
    protected String password = null;
    protected String usernameLabel = RB.getStringResource(RB_KEY, "usernameLabel.txt");
    protected String passwordLabel = RB.getStringResource(RB_KEY, "passwordLabel.txt");
    protected String okButtonLabel;
    protected String cancelButtonLabel;
    protected String closeButtonLabel;
    protected int attemptsCurrent = 0;
    protected int attempts = 3;
    protected String retryMessage = RB.getStringResource(RB_KEY, "tryAgainMessage.txt");
    protected LoginBeanActionInterface actionHandler;
    protected LoginBeanValidateInterface validateHandler;
    public static final int BUTTON_OK = 0;
    public static final int BUTTON_CANCEL = 1;
    public static final int BUTTON_CLOSE = 2;
    protected int failureType = 0;
    protected String failureMessageUnknown = RB.getStringResource(RB_KEY, "failureUnknownMessage.txt");
    protected String failureMessageInvalidHost = RB.getStringResource(RB_KEY, "failureInvalidHostMessage.txt");
    protected String failureMessageInvalidLogin = RB.getStringResource(RB_KEY, "failureInvalidLoginMessage.txt");
    protected String failureMessageConnectionRefused = RB.getStringResource(RB_KEY, "failureConnectRefusedMessage.txt");
    protected String failureMessageNotAvailable = RB.getStringResource(RB_KEY, "failureNotAvailableMessage.txt");
    public static final int FAILURE_TYPE_NONE = 0;
    public static final int FAILURE_TYPE_UNKNOWN = 1;
    public static final int FAILURE_TYPE_INVALID_LOGIN = 2;
    public static final int FAILURE_TYPE_INVALID_HOST = 3;
    public static final int FAILURE_TYPE_CONNECTION_REFUSED = 4;
    public static final int FAILURE_TYPE_NOT_AVAILABLE = 5;

    public LoginBean() {
        this.okButtonLabel = RB.getStringResource(RB_KEY, "okButtonLabel.txt");
        this.cancelButtonLabel = RB.getStringResource(RB_KEY, "cancelButtonLabel.txt");
        this.closeButtonLabel = RB.getStringResource(RB_KEY, "closeButtonLabel.txt");
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public String getTitle() {
        return this.title;
    }

    public void setUsername(String value) {
        this.username = value;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String value) {
        this.password = value;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUsernameLabel(String label) {
        this.usernameLabel = label;
    }

    public String getUsernameLabel() {
        return this.usernameLabel;
    }

    public void setPasswordLabel(String label) {
        this.passwordLabel = label;
    }

    public String getPasswordLabel() {
        return this.passwordLabel;
    }

    public void setOKButtonLabel(String label) {
        this.okButtonLabel = label;
    }

    public String getOKButtonLabel() {
        return this.okButtonLabel;
    }

    public void setCancelButtonLabel(String label) {
        this.cancelButtonLabel = label;
    }

    public String getCancelButtonLabel() {
        return this.cancelButtonLabel;
    }

    public void setCloseButtonLabel(String label) {
        this.closeButtonLabel = label;
    }

    public String getCloseButtonLabel() {
        return this.closeButtonLabel;
    }

    public void setRetryMessage(String value) {
        this.retryMessage = value;
    }

    public String getRetryMessage() {
        return this.retryMessage;
    }

    public void setActionHandler(LoginBeanActionInterface handler) {
        this.actionHandler = handler;
    }

    public LoginBeanActionInterface getActionHandler() {
        return this.actionHandler;
    }

    public void setValidateHandler(LoginBeanValidateInterface handler) {
        this.validateHandler = handler;
    }

    public LoginBeanValidateInterface getValidateHandler() {
        return this.validateHandler;
    }

    public void setAttempts(int value) {
        this.attempts = value;
    }

    public int getAttempts() {
        return this.attempts;
    }

    public void setFailureType(int value) {
        this.failureType = value;
    }

    public int getFailureType() {
        return this.failureType;
    }

    public void setFailureMessage(int type, String msg) {
        switch (type) {
            case 1: {
                this.failureMessageUnknown = msg;
                break;
            }
            case 3: {
                this.failureMessageInvalidHost = msg;
                break;
            }
            case 2: {
                this.failureMessageInvalidLogin = msg;
                break;
            }
            case 4: {
                this.failureMessageConnectionRefused = msg;
                break;
            }
            case 5: {
                this.failureMessageNotAvailable = msg;
            }
        }
    }

    public String getFailureMessage(int type) {
        switch (type) {
            case 1: {
                return this.failureMessageUnknown;
            }
            case 3: {
                return this.failureMessageInvalidHost;
            }
            case 2: {
                return this.failureMessageInvalidLogin;
            }
            case 4: {
                return this.failureMessageConnectionRefused;
            }
            case 5: {
                return this.failureMessageNotAvailable;
            }
        }
        return null;
    }

    public String getCurrentFailureMessage() {
        return this.getFailureMessage(this.getFailureType());
    }

    public boolean validate() {
        if (this.validateHandler == null) {
            return false;
        }
        boolean valid = this.validateHandler.validate(this.getUsername(), this.getPassword());
        ++this.attemptsCurrent;
        if (this.actionHandler != null) {
            if (valid) {
                this.actionHandler.successAction();
                this.attemptsCurrent = 0;
            } else if (this.attemptsCurrent == this.attempts) {
                this.actionHandler.failureAction();
                this.attemptsCurrent = 0;
            } else {
                this.actionHandler.retryAction();
            }
        }
        return valid;
    }
}

