/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.codepolicy.SASScope;
import com.sas.util.RB;
import com.sas.util.Util;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Hashtable;

@SASScope(value="ALL")
public class Strings {
    public static final String RB_KEY = "Strings.";
    private static final char[] specialChars = new char[]{'\"', '\'', '\\', '\b', '\n', '\t', '\f', '\r'};
    private static final String[] replacementChars = new String[]{"\\\"", "\\'", "\\\\", "\\b", "\\n", "\\t", "\\f", "\\r"};
    public static final Character SPACE = new Character(' ');
    private static int POSITION_CACHE_SIZE = 10;
    private static char[] xmlSpecial = new char[]{'&', '\"', '<', '>'};
    private static String[] xmlReplacements = new String[]{"&amp;", "&quot;", "&lt;", "&gt;"};
    private static Hashtable ht = new Hashtable();
    private static final String ENCODED_AMPERSAND = "&amp;";
    private static final String ENCODED_LT = "&lt;";
    private static final String ENCODED_GT = "&gt;";
    private static final String ENCODED_SINGLE_QUOTE = "&apos;";
    private static final String ENCODED_DOUBLE_QUOTE = "&quot;";
    private static String END_TAG_BEGIN = "</";
    private static String SCRIPT = "script";

    private Strings() {
    }

    public static boolean match(String string, String pattern, boolean ignoreCase) {
        return Strings.match(string.toCharArray(), 0, string.length(), pattern.toCharArray(), 0, pattern.length(), ignoreCase, 92);
    }

    public static boolean match(String string, String pattern, boolean ignoreCase, int escapeChar) {
        return Strings.match(string.toCharArray(), 0, string.length(), pattern.toCharArray(), 0, pattern.length(), ignoreCase, escapeChar);
    }

    public static boolean match(char[] string, int sStart, int sEnd, char[] pattern, int pStart, int pEnd, boolean ignoreCase) {
        return Strings.match(string, sStart, sEnd, pattern, pStart, pEnd, ignoreCase, 92);
    }

    public static boolean match(char[] string, int sStart, int sEnd, char[] pattern, int pStart, int pEnd, boolean ignoreCase, int escapeChar) {
        int sIndex = sStart;
        int pIndex = pStart;
        while (pIndex < pEnd) {
            char pChar = pattern[pIndex];
            boolean special = true;
            if (pChar == escapeChar && pIndex + 1 < pEnd && (pattern[pIndex + 1] == '*' || pattern[pIndex + 1] == '?')) {
                special = false;
                pChar = pattern[++pIndex];
            }
            if (pChar == '?' && special) {
                if (sIndex == sEnd) {
                    return false;
                }
                return Strings.match(string, sIndex + 1, sEnd, pattern, pIndex + 1, pEnd, ignoreCase, escapeChar);
            }
            if (pChar == '*' && special) {
                while (sIndex < sEnd) {
                    if (Strings.match(string, sIndex, sEnd, pattern, pIndex + 1, pEnd, ignoreCase, escapeChar)) {
                        return true;
                    }
                    ++sIndex;
                }
                return Strings.match(string, sIndex, sEnd, pattern, pIndex + 1, pEnd, ignoreCase, escapeChar);
            }
            if (sIndex < sEnd) {
                char sChar = string[sIndex];
                if (ignoreCase) {
                    sChar = Character.toUpperCase(sChar);
                    pChar = Character.toUpperCase(pChar);
                }
                if (pChar != sChar) {
                    return false;
                }
            }
            ++pIndex;
            ++sIndex;
        }
        return sIndex == sEnd;
    }

    public static int count(String inputString, int startPos, int endPos, char c) {
        int count = 0;
        if (endPos == -1) {
            endPos = inputString.length() - 1;
        }
        if (startPos < 0) {
            startPos = 0;
        }
        while (startPos <= endPos) {
            if (c != inputString.charAt(startPos++)) continue;
            ++count;
        }
        return count;
    }

    public static int count(String inputString, int startPos, int endPos, String searchString, boolean allowOverlap) {
        int index;
        int count = 0;
        int searchStringLength = searchString.length();
        if (searchStringLength == 0) {
            return 0;
        }
        if (searchStringLength == 1) {
            return Strings.count(inputString, startPos, endPos, searchString.charAt(0));
        }
        if (endPos == -1) {
            endPos = inputString.length() - 1;
        }
        int last = endPos + 1 - searchStringLength;
        while (startPos <= last && (index = inputString.indexOf(searchString, startPos)) != -1) {
            startPos = allowOverlap ? index + 1 : index + searchStringLength;
            ++count;
        }
        return count;
    }

    public static int[] positions(String inputString, int startPos, int endPos, char c) {
        int count = Strings.count(inputString, startPos, endPos, c);
        if (count == 0) {
            return new int[0];
        }
        int[] positions = new int[count];
        if (endPos == -1) {
            endPos = inputString.length() - 1;
        }
        int index = 0;
        while (index < count) {
            if (c == inputString.charAt(startPos)) {
                positions[index++] = startPos;
            }
            ++startPos;
        }
        return positions;
    }

    public static int[] positions(String inputString, int startPos, int endPos, String searchString, boolean allowOverlap) {
        int index;
        int searchStringLength = searchString.length();
        if (searchStringLength == 0) {
            return new int[0];
        }
        if (searchStringLength == 1) {
            return Strings.positions(inputString, startPos, endPos, searchString.charAt(0));
        }
        if (endPos == -1) {
            endPos = inputString.length() - 1;
        }
        int last = endPos + 1 - searchStringLength;
        ArrayList<Integer> positions = null;
        while (startPos <= last && (index = inputString.indexOf(searchString, startPos)) != -1 && index < endPos) {
            startPos = allowOverlap ? index + 1 : index + searchStringLength;
            if (positions == null) {
                positions = new ArrayList<Integer>((last - startPos + 1) / searchString.length());
            }
            positions.add(new Integer(index));
        }
        if (positions == null) {
            return new int[0];
        }
        int[] v = new int[positions.size()];
        for (int i = positions.size() - 1; i >= 0; --i) {
            v[i] = (Integer)positions.get(i);
        }
        return v;
    }

    public static int[] positions(String source, char delim) {
        int[] posCache = null;
        int count = 0;
        int last = -1;
        int i = 0;
        while ((i = source.indexOf(delim, i)) != -1) {
            if (count < POSITION_CACHE_SIZE) {
                if (count == 1) {
                    posCache = new int[POSITION_CACHE_SIZE];
                    posCache[0] = last;
                }
                if (posCache != null) {
                    posCache[count] = i;
                }
            }
            last = i++;
            ++count;
        }
        if (count == 0) {
            return new int[0];
        }
        if (count == 1) {
            return new int[]{last};
        }
        if (count == POSITION_CACHE_SIZE) {
            return posCache;
        }
        if (count < POSITION_CACHE_SIZE) {
            int[] output = new int[count];
            System.arraycopy(posCache, 0, output, 0, count);
            return output;
        }
        int[] output = new int[count];
        System.arraycopy(posCache, 0, output, 0, POSITION_CACHE_SIZE);
        count -= POSITION_CACHE_SIZE;
        int index = POSITION_CACHE_SIZE;
        int i2 = posCache[POSITION_CACHE_SIZE - 1] + 1;
        while (count > 0) {
            i2 = source.indexOf(delim, i2);
            output[index++] = i2++;
            --count;
        }
        return output;
    }

    public static StringBuffer replace(StringBuffer buffer, String search, String replace) {
        int start = 0;
        int searchLength = search.length();
        while (start < buffer.length()) {
            int index = buffer.indexOf(search, start);
            if (index == -1) {
                return buffer;
            }
            buffer.replace(index, index + searchLength, replace);
            start = index + replace.length();
        }
        return buffer;
    }

    public static String[] replace(String[] inputStrings, int startPos, int endPos, int firstString, int lastString, String searchString, String replaceString) {
        String[] result = new String[inputStrings.length];
        if (lastString == -1) {
            lastString = inputStrings.length - 1;
        }
        for (int i = firstString; i <= lastString; ++i) {
            result[i] = i < firstString || i > lastString ? inputStrings[i] : Strings.replace(inputStrings[i], startPos, endPos, searchString, replaceString);
        }
        return result;
    }

    public static String replace(String inputString, int startPos, int endPos, String searchString, String replaceString) {
        int[] positions;
        if (searchString == null) {
            return inputString;
        }
        if (replaceString == null) {
            replaceString = "";
        }
        if (searchString.length() == 0 || searchString.equals(replaceString)) {
            return inputString;
        }
        if (endPos == -1) {
            endPos = inputString.length() - 1;
        }
        if ((positions = Strings.positions(inputString, startPos, endPos, searchString, false)).length == 0) {
            return inputString;
        }
        int searchStringLength = searchString.length();
        int replaceStringLength = replaceString.length();
        int numReplacements = positions.length;
        int targetPos = 0;
        int inputPos = 0;
        int resultLength = inputString.length() - numReplacements * searchStringLength + numReplacements * replaceStringLength;
        char[] buffer = new char[resultLength];
        for (int subStringCount = 0; subStringCount < numReplacements; ++subStringCount) {
            int subStringStartPos = positions[subStringCount];
            if (subStringStartPos > inputPos) {
                inputString.getChars(inputPos, subStringStartPos, buffer, targetPos);
                int copiedStringLength = subStringStartPos - inputPos;
                targetPos += copiedStringLength;
                inputPos += copiedStringLength;
            }
            if (replaceStringLength > 0) {
                replaceString.getChars(0, replaceStringLength, buffer, targetPos);
                targetPos += replaceStringLength;
            }
            inputPos += searchStringLength;
        }
        if (targetPos < resultLength) {
            inputString.getChars(inputPos, inputString.length(), buffer, targetPos);
        }
        return new String(buffer);
    }

    public static boolean lookingAt(String s, int pos, String charSet) {
        return charSet.indexOf(s.charAt(pos)) >= 0;
    }

    public static final boolean equals(String[] a, String[] b) {
        return Strings.equal(a, b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean equal(String[] a, String[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        String[] stringArray = a;
        synchronized (a) {
            String[] stringArray2 = b;
            synchronized (b) {
                int length = a.length;
                if (length != b.length) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return false;
                }
                for (int i = 0; i < length; ++i) {
                    String stringA = a[i];
                    String stringB = b[i];
                    if (stringA == stringB) continue;
                    if (stringA == null || stringB == null) {
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return false;
                    }
                    if (stringA.equals(stringB)) continue;
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return false;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
            return true;
        }
    }

    public static String quoteForSAS(String string, char quoteChar, boolean embed) {
        int len = string.length();
        if (quoteChar != '\'' && quoteChar != '\"') {
            throw new IllegalArgumentException(MessageFormat.format(RB.getStringResource(RB_KEY, "notQuoteChar.ex.txt"), new Character(quoteChar)));
        }
        int count = Strings.count(string, 0, -1, quoteChar);
        if (!embed && count == 0) {
            return string;
        }
        StringBuffer buffer = new StringBuffer(len + count + 2);
        if (embed) {
            buffer.append(quoteChar);
        }
        if (count > 0) {
            for (int i = 0; i < len; ++i) {
                char c = string.charAt(i);
                if (c == quoteChar) {
                    buffer.append(quoteChar);
                }
                buffer.append(c);
            }
        } else {
            buffer.append(string);
        }
        if (embed) {
            buffer.append(quoteChar);
        }
        return buffer.toString();
    }

    public static String quoteForXML(String string) {
        return Strings.replace(string, xmlSpecial, xmlReplacements);
    }

    public static String replace(String string, char[] specialCharacters, String[] replacementStrings) {
        if (!Strings.containsCharacters(string, specialCharacters)) {
            return string;
        }
        int len = string.length();
        StringBuffer buffer = new StringBuffer(len * 11 / 10);
        int numChars = specialCharacters.length;
        int numReplacements = 0;
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            boolean replaced = false;
            for (int j = 0; j < numChars; ++j) {
                char special = specialCharacters[j];
                if (c != special) continue;
                replaced = true;
                buffer.append(replacementStrings[j]);
                ++numReplacements;
                break;
            }
            if (replaced) continue;
            buffer.append(c);
        }
        if (numReplacements == 0) {
            return string;
        }
        return buffer.toString();
    }

    private static boolean containsCharacters(String string, char[] specialCharacters) {
        int numChars = specialCharacters.length;
        for (int i = 0; i < numChars; ++i) {
            if (string.indexOf(specialCharacters[i]) == -1) continue;
            return true;
        }
        return false;
    }

    public static String quoteForSAS(String string) {
        return Strings.quoteForSAS(string, '\"', true);
    }

    public static String quote(String string) {
        if (string == null) {
            return "null";
        }
        int length = string.length();
        StringBuffer buffer = new StringBuffer(length + 4);
        buffer.append('\"');
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            if (c == '\"' || c == '\\') {
                buffer.append('\\');
                buffer.append(c);
                continue;
            }
            if (c == '\b') {
                buffer.append("\\b");
                continue;
            }
            if (c == '\f') {
                buffer.append("\\f");
                continue;
            }
            if (c == '\n') {
                buffer.append("\\n");
                continue;
            }
            if (c == '\r') {
                buffer.append("\\r");
                continue;
            }
            if (c == '\t') {
                buffer.append("\\t");
                continue;
            }
            if (Character.isISOControl(c) || c > '\u00ff') {
                String hex = Integer.toHexString(c);
                buffer.append("\\u");
                buffer.append("000".substring(hex.length() - 1));
                buffer.append(hex);
                continue;
            }
            buffer.append(c);
        }
        buffer.append('\"');
        return buffer.toString();
    }

    public static boolean needsQuoting(String string) {
        if (string == null) {
            return false;
        }
        int length = string.length();
        if (length > 0 && (Character.isWhitespace(string.charAt(0)) || Character.isWhitespace(string.charAt(length - 1)))) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            if (c != '\"' && c != '\\' && c != '\b' && c != '\f' && c != '\n' && c != '\r' && c != '\t' && !Character.isISOControl(c) && c <= '\u00ff') continue;
            return true;
        }
        return false;
    }

    public static String removeWhitespace(String string) {
        int len = string.length();
        StringBuffer newString = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) continue;
            newString.append(c);
        }
        return newString.toString();
    }

    public static int trimmedLength(String string) {
        int left;
        if (string == null) {
            return 0;
        }
        int right = string.length() - 1;
        for (left = 0; left < right && Character.isWhitespace(string.charAt(left)); ++left) {
        }
        while (right >= left && Character.isWhitespace(string.charAt(right))) {
            --right;
        }
        return right - left + 1;
    }

    @SASScope
    public static String trimRight(String input) {
        if (input == null) {
            return null;
        }
        int length = input.length();
        for (int i = length - 1; i >= 0; --i) {
            if (Character.isWhitespace(input.charAt(i))) continue;
            if (i == length - 1) {
                return input;
            }
            if (i == length - 1) continue;
            return input.substring(0, i + 1);
        }
        return "";
    }

    public static boolean equal(String a, String b, boolean trimStrings, boolean ignoreCase) {
        int startA;
        int len;
        if (a == null || b == null) {
            return a == b;
        }
        int lenA = a.length();
        int lenB = b.length();
        int startB = 0;
        if (trimStrings) {
            int trimmedLenB;
            int trimmedLenA = Strings.trimmedLength(a);
            if (trimmedLenA != (trimmedLenB = Strings.trimmedLength(b))) {
                return false;
            }
            len = trimmedLenA;
            for (startA = 0; startA < lenA && Character.isWhitespace(a.charAt(startA)); ++startA) {
            }
            while (startB < lenB && Character.isWhitespace(b.charAt(startB))) {
                ++startB;
            }
        } else {
            if (lenA != lenB) {
                return false;
            }
            len = lenA;
        }
        return a.regionMatches(ignoreCase, startA, b, startB, len);
    }

    public static String intern(String string) {
        String interned = (String)ht.get(string);
        if (interned != null) {
            return interned;
        }
        ht.put(string, string);
        return string;
    }

    public boolean interned(String string) {
        return ht.get(string) != null;
    }

    public static String concatenate(String[] strings, String prefix, String delimiter, String suffix) {
        if (strings == null || strings.length == 0) {
            return "";
        }
        int numStrings = strings.length;
        if (delimiter == null) {
            delimiter = "";
        }
        if (prefix == null) {
            prefix = "";
        }
        if (suffix == null) {
            suffix = "";
        }
        int len = prefix.length() + numStrings * delimiter.length() + suffix.length();
        for (int i = 0; i < numStrings; ++i) {
            String s = strings[i];
            len += s == null ? 0 : s.length();
        }
        StringBuffer b = new StringBuffer(len);
        b.append(prefix);
        int numStrings_1 = numStrings - 1;
        for (int i = 0; i < numStrings; ++i) {
            String s = strings[i];
            b.append(s == null ? "" : s);
            if (i >= numStrings_1) continue;
            b.append(delimiter);
        }
        b.append(suffix);
        return b.toString();
    }

    public static String[] split(String string, String prefix, String delimiter, String suffix) {
        int start = 0;
        int end = string.length() - 1;
        int delimLen = delimiter.length();
        if (delimLen == 0) {
            throw new IllegalArgumentException("\"" + delimiter + "\".length() == 0");
        }
        if (prefix == null || prefix.length() == 0) {
            start = 0;
        } else if (string.startsWith(prefix)) {
            start = prefix.length();
        }
        if (suffix != null && suffix.length() != 0 && string.endsWith(suffix)) {
            end -= suffix.length();
        }
        if (end < start) {
            return new String[0];
        }
        int[] positions = Strings.positions(string, start, end, delimiter, false);
        int n = positions.length;
        for (int i = 0; i < n; ++i) {
            int n2 = positions[i];
        }
        String[] result = new String[n + 1];
        if (n == 0) {
            result[0] = string.substring(start, end + 1);
        } else {
            int[] indices = new int[n + 2];
            indices[0] = start;
            System.arraycopy(positions, 0, indices, 1, n);
            indices[n + 1] = end + 1;
            int offset = 0;
            for (int i = 0; i <= n; ++i) {
                result[i] = string.substring(indices[i] + offset, indices[i + 1]);
                offset = delimLen;
            }
        }
        return result;
    }

    public static String[] split(String string, int segmentLength, Character padChar) {
        if (segmentLength < 1) {
            throw new IllegalArgumentException("segmentLength " + segmentLength + " < 1");
        }
        int len = string.length();
        int numSegments = len / segmentLength + (len % segmentLength == 0 ? 0 : 1);
        String[] result = new String[numSegments];
        int i = 0;
        int start = 0;
        int end = segmentLength;
        while (i < numSegments) {
            result[i] = string.substring(start, Math.min(end, len));
            ++i;
            start += segmentLength;
            end += segmentLength;
        }
        if (padChar != null) {
            StringBuffer buffer = new StringBuffer(result[numSegments - 1]);
            for (int i2 = buffer.length(); i2 < segmentLength; ++i2) {
                buffer.append(padChar.charValue());
            }
            result[numSegments - 1] = buffer.toString();
        }
        return result;
    }

    public static int indexOf(String string, String[] strings) {
        return Strings.indexOf(string, strings, 0, strings.length, null);
    }

    public static int indexOf(String string, String[] strings, int startPos, int endPos, Comparator comparator) {
        if (comparator == null) {
            for (int i = startPos; i < endPos; ++i) {
                if (!Util.equal(string, strings[i])) continue;
                return i;
            }
        } else {
            for (int i = startPos; i < endPos; ++i) {
                if (0 != comparator.compare(string, strings[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @SASScope
    public static String quoteForXMLComplete(String input) {
        String out = input;
        if (input != null) {
            int inlen = input.length();
            boolean needsEncoding = false;
            block11: for (int i = 0; i < inlen && !needsEncoding; ++i) {
                char c = input.charAt(i);
                switch (c) {
                    case '\u0000': 
                    case '\u0001': 
                    case '\u0002': 
                    case '\u0003': 
                    case '\u0004': 
                    case '\u0005': 
                    case '\u0006': 
                    case '\u0007': 
                    case '\b': 
                    case '\t': 
                    case '\n': 
                    case '\u000b': 
                    case '\f': 
                    case '\r': 
                    case '\u000e': 
                    case '\u000f': 
                    case '\u0010': 
                    case '\u0011': 
                    case '\u0012': 
                    case '\u0013': 
                    case '\u0014': 
                    case '\u0015': 
                    case '\u0016': 
                    case '\u0017': 
                    case '\u0018': 
                    case '\u0019': 
                    case '\u001a': 
                    case '\u001b': 
                    case '\u001c': 
                    case '\u001d': 
                    case '\u001e': 
                    case '\u001f': 
                    case '\"': 
                    case '&': 
                    case '\'': 
                    case '<': 
                    case '>': 
                    case '\\': 
                    case '\ufffe': 
                    case '\uffff': {
                        needsEncoding = true;
                        continue block11;
                    }
                }
            }
            if (needsEncoding) {
                StringBuffer buf = new StringBuffer(inlen + 25);
                block12: for (int i = 0; i < inlen; ++i) {
                    char c = input.charAt(i);
                    switch (c) {
                        case '\u0000': 
                        case '\u0001': 
                        case '\u0002': 
                        case '\u0003': 
                        case '\u0004': 
                        case '\u0005': 
                        case '\u0006': 
                        case '\u0007': 
                        case '\b': 
                        case '\t': 
                        case '\n': 
                        case '\u000b': 
                        case '\f': 
                        case '\r': 
                        case '\u000e': 
                        case '\u000f': 
                        case '\u0010': 
                        case '\u0011': 
                        case '\u0012': 
                        case '\u0013': 
                        case '\u0014': 
                        case '\u0015': 
                        case '\u0016': 
                        case '\u0017': 
                        case '\u0018': 
                        case '\u0019': 
                        case '\u001a': 
                        case '\u001b': 
                        case '\u001c': 
                        case '\u001d': 
                        case '\u001e': 
                        case '\u001f': 
                        case '\\': 
                        case '\ufffe': 
                        case '\uffff': {
                            buf.append("&#");
                            buf.append(Integer.toString(c));
                            buf.append(';');
                            continue block12;
                        }
                        case '\"': {
                            buf.append(ENCODED_DOUBLE_QUOTE);
                            continue block12;
                        }
                        case '&': {
                            buf.append(ENCODED_AMPERSAND);
                            continue block12;
                        }
                        case '\'': {
                            buf.append(ENCODED_SINGLE_QUOTE);
                            continue block12;
                        }
                        case '<': {
                            buf.append(ENCODED_LT);
                            continue block12;
                        }
                        case '>': {
                            buf.append(ENCODED_GT);
                            continue block12;
                        }
                        default: {
                            buf.append(c);
                        }
                    }
                }
                out = buf.toString();
            }
        }
        return out;
    }

    @SASScope
    public static String escapeForJavaScript(String str, boolean escapeAll) {
        int i;
        int length;
        if (str == null) {
            return null;
        }
        StringBuilder buff = null;
        int[] pos = new int[specialChars.length + 1];
        int offset = 0;
        int startPos = 0;
        int min = length = str.length();
        int index = -1;
        for (i = 0; i < pos.length; ++i) {
            int n = pos[i] = i < specialChars.length ? str.indexOf(specialChars[i]) : str.indexOf(END_TAG_BEGIN);
            if (pos[i] < 0 || pos[i] >= min) continue;
            min = pos[i];
            index = i;
        }
        while (index >= 0) {
            int idx;
            startPos = pos[index] + 1;
            if (index == 0 || index == 1) {
                if (pos[index] == 0 || str.charAt(pos[index] - 1) != '\\' || escapeAll) {
                    if (buff == null) {
                        buff = new StringBuilder(str);
                    }
                    idx = pos[index] + offset;
                    buff.insert(idx, '\\');
                    ++offset;
                }
            } else if (index == 2) {
                boolean insert = false;
                if (pos[index] == length - 1) {
                    insert = true;
                } else {
                    char ch = str.charAt(pos[index] + 1);
                    if (!(ch != '\'' && ch != '\"' && ch != '\\' && ch != 'b' && ch != 'n' && ch != 't' && ch != 'f' && ch != 'r' || escapeAll)) {
                        ++startPos;
                    } else {
                        insert = true;
                    }
                }
                if (insert) {
                    if (buff == null) {
                        buff = new StringBuilder(str);
                    }
                    int idx2 = pos[index] + offset;
                    buff.replace(idx2, idx2 + 1, replacementChars[index]);
                    ++offset;
                }
            } else if (index == pos.length - 1) {
                int whiteSpaceScanPos;
                for (whiteSpaceScanPos = startPos + 1; whiteSpaceScanPos < length && Character.isWhitespace(str.charAt(whiteSpaceScanPos)); ++whiteSpaceScanPos) {
                }
                String sub = str.substring(whiteSpaceScanPos, whiteSpaceScanPos + SCRIPT.length() > length ? length : whiteSpaceScanPos + SCRIPT.length());
                if (sub.toLowerCase().equals(SCRIPT)) {
                    if (buff == null) {
                        buff = new StringBuilder(str);
                    }
                    int idx3 = pos[index] + offset;
                    buff.replace(idx3 + 1, idx3 + 2, "\\/");
                    ++offset;
                }
            } else {
                if (buff == null) {
                    buff = new StringBuilder(str);
                }
                idx = pos[index] + offset;
                buff.replace(idx, idx + 1, replacementChars[index]);
                ++offset;
            }
            pos[index] = index < specialChars.length ? str.indexOf(specialChars[index], startPos) : str.indexOf(END_TAG_BEGIN, startPos);
            min = length;
            index = -1;
            for (i = 0; i < pos.length; ++i) {
                if (pos[i] < 0 || pos[i] >= min) continue;
                min = pos[i];
                index = i;
            }
        }
        if (buff != null) {
            return buff.toString();
        }
        return str;
    }

    @SASScope
    public static String escapeForJavaScript(String str) {
        return Strings.escapeForJavaScript(str, true);
    }

    @SASScope
    public static String padSingleQuotesForMessage(String s) {
        if (s != null) {
            return s.replaceAll("'", "''");
        }
        return "";
    }
}

