/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.codepolicy.SASScope;
import com.sas.util.ChainedException;
import com.sas.util.ExceptionCodeInterface;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

@SASScope
public class ExceptionUtil {
    private static String lineSeparator = System.getProperty("line.separator");
    public static final String[] DEFAULT_EXCLUDED_PACKAGES = new String[]{"org.apache.", "javax.servlet.", "junit."};
    public static final int GENERATESTACKTRACE_TOP = 0;
    public static final int GENERATESTACKTRACE_AUTHORITATIVE = 1;
    public static final int GENERATESTACKTRACE_ROOT = 2;
    public static final int GENERATESTACKTRACE_ALL = 3;

    public static StringBuffer generateStackTrace(StringBuffer buffer, Throwable t, String[] excludedPackages, boolean trim) {
        StringBuffer buf = buffer == null ? new StringBuffer() : buffer;
        Throwable rootCause = ExceptionUtil.locateAuthoritativeOrLastException(t);
        if (rootCause != null && rootCause != t) {
            buf.append("Root Cause:   ");
            ExceptionUtil.generateTrimmedStackTrace(buf, rootCause, excludedPackages, trim);
            buf.append("Which Caused: ");
        }
        ExceptionUtil.generateTrimmedStackTrace(buf, t, excludedPackages, trim);
        return buf;
    }

    public static StringBuffer generateCustomStackTrace(StringBuffer buffer, Throwable t, String[] excludedPackages, boolean trim, int stackTraceLevel) {
        StringBuffer buf = buffer == null ? new StringBuffer() : buffer;
        Throwable rootCause = null;
        Throwable authoritativeCause = null;
        if (stackTraceLevel == 1 || stackTraceLevel == 3) {
            authoritativeCause = ExceptionUtil.locateAuthoritativeOrLastException(t);
        }
        if (stackTraceLevel == 2 || stackTraceLevel == 3) {
            rootCause = ChainedException.getRootException(t);
        }
        if (rootCause != null && rootCause != t) {
            buf.append("Root Cause:   ");
            ExceptionUtil.generateTrimmedStackTrace(buf, rootCause, excludedPackages, trim);
            buf.append("Which Caused: ");
        }
        if (authoritativeCause != null && authoritativeCause != t && authoritativeCause != rootCause) {
            ExceptionUtil.generateTrimmedStackTrace(buf, authoritativeCause, excludedPackages, trim);
            buf.append("Which Caused: ");
        }
        ExceptionUtil.generateTrimmedStackTrace(buf, t, excludedPackages, trim);
        return buf;
    }

    public static void generateTrimmedStackTrace(StringBuffer buffer, Throwable t, String[] excludedPackages, boolean trim) {
        buffer.append(t).append(lineSeparator);
        StackTraceElement[] elements = t.getStackTrace();
        boolean processElements = true;
        block0: for (int j = 0; processElements && j < elements.length; ++j) {
            buffer.append("\tat ").append(elements[j]).append(lineSeparator);
            if (!trim) continue;
            String classname = elements[j].getClassName();
            for (int k = 0; k < excludedPackages.length; ++k) {
                if (!classname.startsWith(excludedPackages[k])) continue;
                processElements = false;
                int unprocessedLineCount = elements.length - j - 1;
                if (unprocessedLineCount <= 0) continue block0;
                buffer.append("\t[ ").append(unprocessedLineCount);
                buffer.append(" line");
                if (unprocessedLineCount != 1) {
                    buffer.append("s");
                }
                buffer.append(" suppressed ]").append(lineSeparator);
                continue block0;
            }
        }
    }

    public static String getMessage(Exception e, ResourceBundle rbOverride, Locale locale) {
        if (e instanceof ExceptionCodeInterface) {
            String code = ((ExceptionCodeInterface)((Object)e)).getGenericExceptionCode();
            String message = code != null && code.length() > 0 && rbOverride != null ? ExceptionUtil.getResourceString(rbOverride, code) : ((ExceptionCodeInterface)((Object)e)).getLocalizedMessage(locale);
            return message;
        }
        return e.getLocalizedMessage();
    }

    public static String getAuthoritativeMessage(Exception e, ResourceBundle rbOverride, Locale locale) {
        String code = ExceptionUtil.getAuthoritativeCode(e);
        String message = null;
        if (code != null && code.length() > 0 && rbOverride != null) {
            message = ExceptionUtil.getResourceString(rbOverride, code);
        } else {
            ExceptionCodeInterface ec = ExceptionUtil.locateAuthoritativeException(e);
            if (ec != null) {
                message = ec.getLocalizedMessage(locale);
            }
        }
        return message;
    }

    public static String getAuthoritativeOrLastMessage(Exception e, ResourceBundle rbOverride, Locale locale) {
        Throwable ex;
        String code = ExceptionUtil.getAuthoritativeCode(e);
        String message = null;
        message = code != null && code.length() > 0 && rbOverride != null ? ExceptionUtil.getResourceString(rbOverride, code) : ((ex = ExceptionUtil.locateAuthoritativeOrLastException(e)) instanceof ExceptionCodeInterface ? ((ExceptionCodeInterface)((Object)ex)).getLocalizedMessage(locale) : ex.getLocalizedMessage());
        return message;
    }

    public static String getCode(Exception e) {
        if (e instanceof ExceptionCodeInterface) {
            return ((ExceptionCodeInterface)((Object)e)).getGenericExceptionCode();
        }
        return "";
    }

    public static String getAuthoritativeCode(Exception e) {
        ExceptionCodeInterface ec = ExceptionUtil.locateAuthoritativeException(e);
        if (ec != null) {
            return ec.getGenericExceptionCode();
        }
        return "";
    }

    public static ExceptionCodeInterface locateAuthoritativeException(Exception e) {
        if (e instanceof ExceptionCodeInterface && ((ExceptionCodeInterface)((Object)e)).isAuthoritative()) {
            return (ExceptionCodeInterface)((Object)e);
        }
        if (ChainedException.getTargetException(e) != null) {
            return ExceptionUtil.locateAuthoritativeException((Exception)ChainedException.getTargetException(e));
        }
        return null;
    }

    public static Throwable locateAuthoritativeOrLastException(Throwable e) {
        if (e instanceof ExceptionCodeInterface && ((ExceptionCodeInterface)((Object)e)).isAuthoritative()) {
            return e;
        }
        if (ChainedException.getTargetException(e) != null) {
            return ExceptionUtil.locateAuthoritativeOrLastException(ChainedException.getTargetException(e));
        }
        return e;
    }

    public static Exception locateRootException(Exception e) {
        if (e != null && ChainedException.getTargetException(e) != null) {
            return ExceptionUtil.locateRootException((Exception)ChainedException.getTargetException(e));
        }
        return e;
    }

    public static String getResourceString(ResourceBundle rb, String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        String rval = key;
        try {
            rval = rb.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return rval;
    }
}

