/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.beans.PropertyEditor;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public abstract class Enum {
    private int _value;
    protected Enum next;
    private String _name;

    protected Enum() {
    }

    public final String toString() {
        return this.toString(false);
    }

    public abstract Enum getNextEnum();

    public final String toString(boolean withPackageName) {
        if (withPackageName) {
            return this.getClass().getName() + "." + this._name;
        }
        return this._name;
    }

    protected final int getIndex(Enum target, Enum first) {
        int i = 0;
        Enum enumer = first;
        while (enumer != null) {
            if (enumer == target) {
                return i;
            }
            enumer = enumer.getNextEnum();
            ++i;
        }
        return -1;
    }

    public abstract int getIndex();

    protected static final Enum getEnum(int value, Enum first) {
        for (Enum enumer = first; enumer != null; enumer = enumer.getNextEnum()) {
            if (enumer._value != value) continue;
            return enumer;
        }
        return null;
    }

    public static final Enum get(String name, Enum first) {
        for (Enum enumer = first; enumer != null; enumer = enumer.getNextEnum()) {
            if (!enumer._name.equals(name)) continue;
            return enumer;
        }
        return null;
    }

    public static final Enum get(int index, Enum first) {
        Enum enumer;
        for (enumer = first; index > 0 && enumer != null; enumer = enumer.getNextEnum(), --index) {
        }
        return enumer;
    }

    public static final Enum getAt(String name, Enum first) {
        for (Enum enumer = first; enumer != null; enumer = enumer.getNextEnum()) {
            if (!enumer._name.equals(name)) continue;
            return enumer;
        }
        return null;
    }

    public static final Enum getAt(int index, Enum first) {
        Enum enumer;
        for (enumer = first; index > 0 && enumer != null; enumer = enumer.getNextEnum(), --index) {
        }
        return enumer;
    }

    public int getValue() {
        return this._value;
    }

    protected void setValue(int value) {
        this._value = value;
    }

    protected Enum(String name, int value) {
        this._name = name;
        this._value = value;
    }

    public static Enum[] getEnums(Enum first) {
        Enum e;
        int count = 0;
        for (e = first; e != null; e = e.getNextEnum()) {
            ++count;
        }
        Enum[] enums = new Enum[count];
        count = 0;
        while (e != null) {
            enums[count++] = e;
            e = e.getNextEnum();
        }
        return enums;
    }

    public static abstract class Editor
    extends PropertyEditor {
        protected boolean displayTags;
        protected boolean displayDescriptions;
        protected boolean listNull;
        protected static boolean nextDisplayTags = true;
        protected static boolean nextDisplayDescriptions = false;
        protected static boolean nextListNull = true;

        public Editor() {
            this.setDisplayOptions(nextDisplayTags, nextDisplayDescriptions, nextListNull);
            Editor.setNextEnumEditorDisplayOptions(true, false, true);
        }

        protected abstract ResourceBundle resources();

        protected abstract String classKey();

        protected abstract Enum first();

        public void setDisplayOptions(boolean displayTags, boolean displayDescriptions, boolean listNull) {
            this.displayTags = displayTags;
            this.displayDescriptions = displayDescriptions;
            if (!(displayTags | displayDescriptions)) {
                displayTags = true;
            }
            this.listNull = listNull;
        }

        public static void setNextEnumEditorDisplayOptions(boolean displayTags, boolean displayDescriptions, boolean listNull) {
            nextDisplayTags = displayTags;
            nextDisplayDescriptions = displayDescriptions;
            if (!displayTags && !displayDescriptions) {
                nextDisplayTags = true;
            }
            nextListNull = listNull;
        }

        void displayDescriptions(boolean displayDescriptions) {
            this.displayDescriptions = displayDescriptions;
            if (!displayDescriptions) {
                this.displayTags = true;
            }
        }

        @Override
        public void setAsText(String text) throws IllegalArgumentException {
            if ((text == null || (text = text.trim()).length() == 0 || text.equals("null")) && this.getValue() != null) {
                this.setValue(null);
                this.firePropertyChange();
            }
            ResourceBundle bundle = this.resources();
            String desc = "";
            String resourcePrefix = this.classKey();
            for (Enum enumer = this.first(); enumer != null; enumer = enumer.getNextEnum()) {
                desc = Editor.getDescription(enumer, resourcePrefix, bundle);
                if (null == desc || !text.equalsIgnoreCase(desc) && !text.equalsIgnoreCase(Editor.getTag(enumer, resourcePrefix, bundle, this.displayTags, this.displayDescriptions))) continue;
                if (this.getValue() != enumer) {
                    this.setValue(enumer);
                    this.firePropertyChange();
                }
                return;
            }
            String word = new StringTokenizer(text).nextToken();
            for (Enum enumer = this.first(); enumer != null; enumer = enumer.getNextEnum()) {
                if (!word.equalsIgnoreCase(enumer.toString())) continue;
                if (this.getValue() != enumer) {
                    this.setValue(enumer);
                    this.firePropertyChange();
                }
                return;
            }
            throw new IllegalArgumentException();
        }

        @Override
        public String[] getTags() {
            Enum enumer;
            int count = 0;
            for (enumer = this.first(); enumer != null; enumer = enumer.getNextEnum()) {
                ++count;
            }
            if (this.listNull) {
                ++count;
            }
            String[] tags = new String[count];
            int i = 0;
            if (this.listNull) {
                tags[i++] = "null";
            }
            String classKey = this.classKey();
            ResourceBundle resources = this.resources();
            for (enumer = this.first(); enumer != null; enumer = enumer.getNextEnum()) {
                tags[i++] = Editor.getTag(enumer, classKey, resources, this.displayTags, this.displayDescriptions);
            }
            return tags;
        }

        public static String getTag(Enum enumer, String resourcePrefix, ResourceBundle bundle, boolean displayTags, boolean displayDescriptions) {
            String desc;
            String tag = "";
            if (displayTags) {
                tag = enumer.toString();
            }
            if (displayDescriptions && (desc = Editor.getDescription(enumer, resourcePrefix, bundle)) != null) {
                tag = tag + (displayTags ? " : " : "") + desc;
            }
            if ("".equals(tag)) {
                tag = enumer.toString();
            }
            return tag;
        }

        static String getDescription(Enum enumer, String resourcePrefix, ResourceBundle bundle) {
            if (bundle != null) {
                try {
                    return bundle.getString(resourcePrefix + enumer.toString() + ".txt");
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        public String getAsText() {
            Enum enumer = (Enum)this.value;
            if (enumer == null) {
                return null;
            }
            return Editor.getTag(enumer, this.classKey(), this.resources(), this.displayTags, this.displayDescriptions);
        }

        @Override
        public String getJavaInitializationString() {
            Enum enumer = (Enum)this.value;
            if (enumer == null) {
                return "null";
            }
            return enumer.toString(true);
        }
    }
}

