/*
 * Decompiled with CFR 0.152.
 */
package com.sas.text;

import com.sas.text.SASFormatEntry;
import com.sas.text.SASNumericFormat;
import com.sas.text.SingleEntry;
import com.sas.text.SwapSeparators;
import com.sas.text.TableEntry;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Currency;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

class Pattern
extends SASNumericFormat {
    protected char decimalSeparator;
    protected char groupingSeparator;
    protected char percent;
    protected String positivePrefix = "";
    protected String positiveSuffix = "";
    protected String negativePrefix = "-";
    protected String negativeSuffix = "";
    protected final DecimalFormat formatter;
    protected boolean isPercent = false;
    protected boolean isNLFormat = false;
    private StringBuffer result;
    private final DecimalFormat decimalFormat;
    protected final FieldPosition position;
    private static final String[] IntCurrencies = new String[]{"AUD", "CAD", "CHF", "CNY", "DKK", "EUR", "GBP", "HKD", "ILS", "JPY", "KRW", "MYR", "NOK", "NZD", "PLN", "RUR", "SEK", "SGD", "TWD", "USD", "ZAR", "AED", "BGN", "BRL", "CZK", "EEK", "EGP", "HRK", "HUF", "IDR", "INR", "LTL", "LVL", "MOP", "MXN", "ROL", "RUB", "SKK", "THB", "TRY"};
    private static final double MINUS_ZERO = -0.0;
    boolean isDFormat = false;
    private boolean infoHasSingleEntry;
    private String baseFormat;
    char factionalPatternChar = (char)35;
    private TableEntry tableEntry;
    private boolean isPercentWithParen;
    private boolean isPercentWithMinus;
    private boolean isPVALUE;
    private boolean isRSTD;
    private boolean isBEST;
    private boolean isNLBEST;
    private boolean isLOGPROB;
    private boolean isStartWithNLMNY;
    private boolean isNLMNY;
    private boolean isNLMNYI;
    private boolean isNLPCTP = false;
    private boolean isNLPCTN = false;
    private boolean isNLPCTX = false;
    private boolean isNLMoneyWithParen = false;
    private static final String NEGPAREN = "NEGPAREN";
    private static final String PERCENTN = "PERCENTN";
    private static final String PVALUE = "PVALUE";
    private static final String LOGPROB = "LOGPROB";
    private static final String NLPCT = "NLPCT";
    private static final String NLPCTI = "NLPCTI";
    private static final String PERCENT = "PERCENT";
    private static final String RSTDONYN = "RSTDONYN";
    private static final String RSTDOPYN = "RSTDOPYN";
    private static final String RSTDOCYY = "RSTDOCYY";
    private static final String RSTDOPYY = "RSTDOPYY";
    private static final String RSTDOCNY = "RSTDOCNY";
    private static final String RSTDOPNY = "RSTDOPNY";
    private static final String NLBEST = "NLBEST";
    private final StringBuffer nfactionalPart = new StringBuffer(32);
    private StringBuffer newValue = new StringBuffer(30);
    private StringBuffer wholePart = new StringBuffer(30);
    StringBuffer pattern = new StringBuffer(32);
    private static Object[] patternFormats;

    public Pattern() {
        this.formatter = new DecimalFormat();
        this.decimalSeparator = (char)46;
        this.groupingSeparator = (char)44;
        this.percent = (char)37;
        this.result = new StringBuffer(30);
        this.decimalFormat = new DecimalFormat("0;-0");
        this.position = new FieldPosition(0);
    }

    @Override
    protected void init() {
        super.init();
        this.tableEntry = this.info.getEntry();
        this.infoHasSingleEntry = this.tableEntry instanceof SingleEntry;
        this.baseFormat = this.info.getBaseFormat();
        this.isPercentWithParen = this.baseFormat.equals(NEGPAREN) || this.baseFormat.equals(RSTDONYN) || this.baseFormat.equals(RSTDOPYN);
        this.isPercentWithMinus = this.baseFormat.equals(PERCENTN) || this.baseFormat.equals(NLPCT) || this.baseFormat.equals(NLPCTI) || this.baseFormat.equals(RSTDOCNY) || this.baseFormat.equals(RSTDOPNY);
        this.isPVALUE = this.baseFormat.equals(PVALUE) || this.baseFormat.equals("NLPVALUE");
        this.isRSTD = this.baseFormat.equals(PERCENT) || this.baseFormat.equals(RSTDOCYY) || this.baseFormat.equals(RSTDOPYY) || this.baseFormat.equals("NLPCTP");
        this.isBEST = this.baseFormat.equals("BEST") || this.baseFormat.equals(NLBEST);
        this.isNLBEST = this.baseFormat.equals(NLBEST);
        this.isLOGPROB = this.baseFormat.equals(LOGPROB);
        this.isStartWithNLMNY = this.baseFormat.startsWith("NLMNY");
        this.isNLMNY = this.baseFormat.equals("NLMNY");
        this.isNLMNYI = this.baseFormat.equals("NLMNYI");
        if (this.baseFormat.length() >= 2 && this.baseFormat.substring(0, 2).equals("NL")) {
            this.isNLFormat = true;
        }
        this.isNLPCTP = this.baseFormat.equals("NLPCTP");
        this.isNLPCTN = this.baseFormat.equals("NLPCTN");
        this.isNLPCTX = this.isNLPCTP || this.isNLPCTN;
        this.formatter.setDecimalFormatSymbols(this.getSupportedDFS(this.info.getFormatLocale()));
        if (this.info.isDecimalWidthSupported()) {
            this.factionalPatternChar = (char)48;
        }
        if (this.info.getDValue() < 0 && (this.baseFormat.startsWith("NLMNI") || this.baseFormat.startsWith("NLMNL"))) {
            String symbol = this.baseFormat.substring(5, 8);
            Currency currency = Currency.getInstance(symbol);
            this.info.setDValue(currency.getDefaultFractionDigits());
        }
    }

    @Override
    public StringBuffer format(double value) {
        String sv;
        StringBuffer formatValue = new StringBuffer();
        if (value == 0.0 && (sv = Double.toString(value)).charAt(0) == '-') {
            value = -value;
        }
        if (this.info.isPattern()) {
            double minval;
            int width;
            int w;
            int d = this.info.getDValue();
            if (this.isPVALUE && d <= 0) {
                w = this.info.getWidth();
                d = Math.min(4, w - 2);
            }
            if (this.isBEST && value < 1.0 && value > -1.0) {
                try {
                    width = this.info.getWidth();
                    BestFormatForSmallValues bestFormat = new BestFormatForSmallValues();
                    String formattedString = bestFormat.format(width, value);
                    formatValue.append(formattedString);
                    if (this.isDFormat && formatValue.indexOf("E") < 0 && formatValue.indexOf(".") > 0) {
                        formatValue = new StringBuffer(formatValue.toString().trim());
                        int width1 = this.formatInfo.getWidth();
                        int numOfSpaces = width1 - formatValue.length();
                        if (numOfSpaces > 0) {
                            formatValue.ensureCapacity(width);
                            for (int i = 0; i < numOfSpaces; ++i) {
                                formatValue.append("0");
                            }
                        }
                    } else {
                        this.insertLeadingBlanks(formatValue);
                    }
                    if (this.isNLBEST) {
                        formatValue = this.nlbestForSmallValues(formatValue);
                    }
                    return formatValue;
                }
                catch (NumberFormatException e) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("0");
                    this.insertLeadingBlanks(sb);
                    return sb;
                }
            }
            if (this.isLOGPROB) {
                double minval2;
                if (value < 0.0) {
                    formatValue.setLength(0);
                    formatValue.append("*");
                    return formatValue;
                }
                w = this.info.getWidth();
                d = (int)Math.min(Math.ceil(value) + 2.0, (double)(w - 1));
                if ((value = Math.exp(-value * Math.log(10.0)) * 1.00000001) < (minval2 = Math.pow(10.0, -d))) {
                    value = minval2;
                }
            }
            this.applyPattern(this.modifyPattern(this.info.getPattern(), d));
            width = this.info.getWidth();
            if (this.isNLPCTN && value < 0.0) {
                this.info.setWidth(width - 1);
            } else if ((this.isPercent && !this.isNLFormat || this.isNLPCTX) && value >= 0.0) {
                this.info.setWidth(width - 2);
            } else if (value >= 0.0 && this.infoHasSingleEntry && this.isNLMoneyWithParen) {
                this.info.setWidth(width - 1);
            }
            this.formatter.format(this.round(value, d), formatValue, this.position);
            if ((double)formatValue.length() != 0.0) {
                if (this.isNLMNY) {
                    formatValue = this.replaceCurrencySymbol(formatValue);
                    if (value == 0.0) {
                        FormatZeroValues fzv = new FormatZeroValues();
                        formatValue = fzv.formatZeroValueForMNY(formatValue);
                    }
                }
                formatValue = this.isNLPCTX && this.isUseExponent(value * 100.0, width - 3, this.info.getDValue()) ? this.fmteForNLPCTX(value, width, this.info.getDValue()) : this.best(formatValue, value);
            } else {
                formatValue.append('0');
            }
            width = this.info.getWidth();
            if (this.isNLPCTN && value < 0.0) {
                this.info.setWidth(width + 1);
                if (formatValue.indexOf("*") >= 0) {
                    formatValue.setCharAt(0, '(');
                    formatValue.append(')');
                } else {
                    formatValue.append(' ');
                }
            } else if ((this.isPercent && !this.isNLFormat || this.isNLPCTX) && value >= 0.0) {
                this.info.setWidth(width + 2);
                formatValue.append(' ');
            } else if (value >= 0.0 && this.infoHasSingleEntry && this.isNLMoneyWithParen) {
                this.info.setWidth(width + 1);
                formatValue.append(' ');
            }
            if (this.isPercentWithParen) {
                int length = formatValue.length();
                if (value >= 0.0) {
                    if (width > length + 1) {
                        formatValue.append(' ');
                    }
                } else if (width > length && formatValue.charAt(0) == '-') {
                    formatValue.setCharAt(0, '(');
                    formatValue.append(')');
                }
            } else if (this.isPercentWithMinus) {
                if (formatValue.charAt(0) == '(') {
                    formatValue.setCharAt(0, '-');
                    formatValue.setCharAt(formatValue.length() - 1, ' ');
                }
            } else if (this.isPVALUE && value < (minval = Math.pow(10.0, -d))) {
                int w2 = this.info.getWidth();
                if (d > w2 - 2) {
                    d = w2 - 2;
                    minval = Math.pow(10.0, -d);
                }
                String pvalPattern = ".###############################";
                DecimalFormat pvalFormatter = null;
                pvalFormatter = this.baseFormat.equals(PVALUE) ? new DecimalFormat(".###############################".substring(0, d + 1)) : new DecimalFormat(".###############################".substring(0, d + 1), new DecimalFormatSymbols(this.info.getFormatLocale()));
                formatValue.setLength(0);
                formatValue.append("<" + pvalFormatter.format(minval));
            }
            if (this.isRSTD && formatValue.charAt(0) == '(') {
                this.insertLeadingBlanks(formatValue, 1);
            } else if ("Z".equalsIgnoreCase(this.origFormat) && "F".equalsIgnoreCase(this.getBaseFormatName())) {
                this.insertLeadingCharacter(formatValue, 0, '0');
                int negIndex = formatValue.indexOf("-");
                if (negIndex > 0) {
                    formatValue.replace(negIndex, negIndex + 1, "0");
                    formatValue.replace(0, 1, "-");
                }
            } else {
                this.insertLeadingBlanks(formatValue, 0);
            }
        }
        if (this.isNLBEST && value < 0.0 && formatValue.indexOf("*") == -1) {
            formatValue = this.moveMinussign(formatValue);
        }
        if (this.infoHasSingleEntry) {
            formatValue = ((SingleEntry)this.info.getEntry()).restore(formatValue);
        }
        return formatValue;
    }

    private void applyPattern(String pattern) {
        this.formatter.applyPattern(pattern);
        this.formatter.setDecimalSeparatorAlwaysShown(false);
        DecimalFormatSymbols dfs = this.formatter.getDecimalFormatSymbols();
        this.decimalSeparator = dfs.getDecimalSeparator();
        this.groupingSeparator = dfs.getGroupingSeparator();
        this.percent = dfs.getPercent();
        this.positivePrefix = this.formatter.getPositivePrefix();
        this.positiveSuffix = this.formatter.getPositiveSuffix();
        this.negativePrefix = this.formatter.getNegativePrefix();
        this.negativeSuffix = this.formatter.getNegativeSuffix();
        if (this.isNLMNY && dfs.getCurrencySymbol() != null && dfs.getCurrencySymbol().indexOf(46) > -1 && this.infoHasSingleEntry) {
            SingleEntry se = (SingleEntry)this.tableEntry;
            se.setCurrencySymbol(dfs.getCurrencySymbol());
            se.replaceLocalCurrencySymbol(dfs.getCurrencySymbol());
            this.positivePrefix = this.positivePrefix.replace(dfs.getCurrencySymbol(), se.getCurrecnySymbol());
            this.positiveSuffix = this.positiveSuffix.replace(dfs.getCurrencySymbol(), se.getCurrecnySymbol());
            this.negativePrefix = this.negativePrefix.replace(dfs.getCurrencySymbol(), se.getCurrecnySymbol());
            this.negativeSuffix = this.negativeSuffix.replace(dfs.getCurrencySymbol(), se.getCurrecnySymbol());
        }
        this.isPercent = this.positiveSuffix.indexOf(this.percent) != -1;
        if (this.negativePrefix.indexOf(40) > -1 && this.negativeSuffix.indexOf(41) > -1) {
            this.isNLMoneyWithParen = this.isNLMNY || this.isStartWithNLMNY || this.baseFormat.startsWith("NLMNI") || this.baseFormat.startsWith("NLMNL");
        }
    }

    private String modifyPattern(String pattern, int dValue) {
        if (this.isNLFormat && this.isStartWithNLMNY) {
            pattern = this.replaceE(pattern);
        }
        StringTokenizer st = new StringTokenizer(pattern, ";");
        this.result.setLength(0);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int decimalIndex = token.indexOf(46);
            if (decimalIndex >= 0) {
                int i;
                String wholePart = token.substring(0, decimalIndex);
                this.nfactionalPart.setLength(0);
                int count = 0;
                int insertIndex = 1;
                boolean inQuote = false;
                for (i = decimalIndex; i < token.length(); ++i) {
                    char c = token.charAt(i);
                    if (c == '\'') {
                        boolean bl = inQuote = !inQuote;
                    }
                    if (!inQuote) {
                        if (c == '#') continue;
                        if (c == '0') {
                            ++count;
                            insertIndex = this.nfactionalPart.length() + 1;
                        }
                        this.nfactionalPart.append(c);
                        continue;
                    }
                    this.nfactionalPart.append(c);
                }
                for (i = 0; i < dValue - count; ++i) {
                    this.nfactionalPart.insert(insertIndex, this.factionalPatternChar);
                }
                if (this.isPVALUE) {
                    this.result.append(wholePart + this.nfactionalPart.substring(0, dValue + 1));
                } else {
                    this.result.append(wholePart + this.nfactionalPart);
                }
            } else {
                this.result.append(token);
            }
            if (!st.hasMoreTokens()) continue;
            this.result.append(';');
        }
        if (this.isNLFormat && this.result.indexOf(";") <= 0) {
            this.result.append(";");
        }
        return this.result.toString();
    }

    @Override
    protected double round(double value, int decimalCount) {
        if (this.isPercent) {
            decimalCount += 2;
        }
        BigDecimal bd = BigDecimal.valueOf(value);
        double rValue = (bd = bd.setScale(decimalCount, 4)).doubleValue();
        if (rValue == 0.0 && value < 0.0 || 1.0 / value == Double.NEGATIVE_INFINITY) {
            rValue = -0.0;
        }
        return rValue;
    }

    protected StringBuffer best(StringBuffer sValue, double value) {
        int infoWidth = this.info.getWidth();
        int length = sValue.length();
        if (length > infoWidth) {
            int ipiont;
            char[] oldValue;
            if (this.isPercentWithParen && !this.isPercent && value < 0.0 && sValue.charAt(0) == '(') {
                oldValue = new char[length - 1];
                for (int i = 0; i < length; ++i) {
                    char c = sValue.charAt(i);
                    if (c == '(') {
                        oldValue[i] = 45;
                        continue;
                    }
                    if (c == ')') continue;
                    oldValue[i] = c;
                }
                sValue.setLength(0);
                sValue.append(oldValue);
            } else if (this.baseFormat.equals("F") && !this.isNLFormat && (sValue.toString().startsWith("0") && infoWidth >= 2 || sValue.toString().startsWith(this.negativePrefix + "0") && infoWidth >= 3) || this.isPercent && !this.isNLFormat && (sValue.toString().startsWith("0") && (infoWidth == 2 || infoWidth == 3) || sValue.toString().startsWith(this.negativePrefix + "0") && (infoWidth == 4 || infoWidth == 5))) {
                ipiont = sValue.indexOf(String.valueOf(this.decimalSeparator));
                sValue.deleteCharAt(ipiont - 1);
                oldValue = new char[length - 1];
                sValue.getChars(0, length - 1, oldValue, 0);
            } else if (this.isPercent && value == 0.0) {
                ipiont = sValue.indexOf(String.valueOf(this.decimalSeparator));
                if (infoWidth > 2) {
                    sValue.deleteCharAt(ipiont - 1);
                    while (sValue.length() > infoWidth) {
                        sValue.deleteCharAt(ipiont + 1);
                    }
                } else {
                    String tmp = new String(this.positivePrefix + "0" + this.positiveSuffix + ";" + this.negativePrefix + "0" + this.negativeSuffix);
                    this.decimalFormat.applyPattern(tmp);
                    this.decimalFormat.setDecimalSeparatorAlwaysShown(false);
                    this.decimalFormat.setDecimalFormatSymbols(this.formatter.getDecimalFormatSymbols());
                    sValue = this.decimalFormat.format(value, new StringBuffer(), this.position);
                }
                oldValue = new char[sValue.length()];
                sValue.getChars(0, sValue.length(), oldValue, 0);
            } else {
                oldValue = new char[length];
                sValue.getChars(0, length, oldValue, 0);
            }
            if (oldValue.length > infoWidth) {
                StringBuffer wholeValue = new StringBuffer();
                this.wholePart.setLength(0);
                this.newValue.setLength(0);
                int fractionWidth = 0;
                boolean inWholePart = true;
                boolean isDollar = false;
                int minWidth = 0;
                for (int i = 0; i < oldValue.length; ++i) {
                    if (oldValue[i] == this.groupingSeparator) continue;
                    if (oldValue[i] == this.decimalSeparator) {
                        inWholePart = false;
                    }
                    if (inWholePart) {
                        this.wholePart.append(oldValue[i]);
                        if (Character.isDigit(oldValue[i])) {
                            ++minWidth;
                            wholeValue.append(oldValue[i]);
                        }
                    } else if (Character.isDigit(oldValue[i])) {
                        ++fractionWidth;
                    }
                    if (oldValue[i] == '$') {
                        isDollar = true;
                    }
                    this.newValue.append(oldValue[i]);
                }
                if ((this.isPercent && !this.isNLFormat || this.isNLPCTX) && value >= 0.0) {
                    this.newValue.insert(0, ' ');
                    this.newValue.append(' ');
                }
                if (this.newValue.length() > infoWidth && (this.baseFormat.startsWith("NLMNI") || this.baseFormat.startsWith("NLMNL"))) {
                    SingleEntry entry = (SingleEntry)this.tableEntry;
                    StringBuffer strbuf = new StringBuffer(this.newValue.toString().replace(entry.getCurrecnySymbol(), ""));
                    if (strbuf.length() <= infoWidth) {
                        this.newValue = strbuf;
                    } else {
                        this.wholePart = new StringBuffer(this.wholePart.toString().replace(entry.getCurrecnySymbol(), ""));
                        minWidth -= this.newValue.length() - strbuf.length();
                    }
                }
                if (this.newValue.length() <= infoWidth) {
                    sValue = this.newValue;
                } else {
                    minWidth = value > 0.0 ? (minWidth += this.positivePrefix.length() + this.positiveSuffix.length()) : (minWidth += this.negativePrefix.length() + this.negativeSuffix.length());
                    String pattern = null;
                    if (this.isPercent && this.isNLFormat && value > -1.0 && value < 1.0 && value != 0.0) {
                        double dwholeValue = 0.0;
                        try {
                            dwholeValue = Double.parseDouble(wholeValue.toString());
                        }
                        catch (NumberFormatException nfe) {
                            dwholeValue = -99.0;
                        }
                        if (dwholeValue == 0.0) {
                            if (fractionWidth >= this.info.getDValue()) {
                                pattern = new String(this.positivePrefix + "#." + this.positiveSuffix + ";" + this.negativePrefix + "#." + this.negativeSuffix);
                                --minWidth;
                                this.wholePart.deleteCharAt(0);
                            } else {
                                pattern = new String(this.positivePrefix + "0." + this.positiveSuffix + ";" + this.negativePrefix + "0." + this.negativeSuffix);
                            }
                        } else {
                            pattern = new String(this.positivePrefix + "0." + this.positiveSuffix + ";" + this.negativePrefix + "0." + this.negativeSuffix);
                        }
                    } else {
                        pattern = new String(this.positivePrefix + "0." + this.positiveSuffix + ";" + this.negativePrefix + "0." + this.negativeSuffix);
                    }
                    if (this.isNLFormat && this.isStartWithNLMNY) {
                        pattern = this.replaceE(pattern);
                    }
                    if (isDollar && !this.isNLMNY && !this.isNLMNYI) {
                        StringBuffer temp = new StringBuffer();
                        for (int i = 0; i < pattern.length(); ++i) {
                            char c = pattern.charAt(i);
                            if (c == '$') continue;
                            temp.append(c);
                        }
                        pattern = temp.toString();
                        --minWidth;
                    }
                    sValue.setLength(0);
                    if (minWidth > infoWidth) {
                        sValue = value == 0.0 ? this.asteriskArray() : this.best_exp(value);
                    } else if (minWidth == infoWidth) {
                        double roundedValue = this.round(value, 0);
                        this.decimalFormat.applyPattern(pattern);
                        this.decimalFormat.setDecimalSeparatorAlwaysShown(false);
                        this.decimalFormat.setDecimalFormatSymbols(this.formatter.getDecimalFormatSymbols());
                        StringBuffer str = this.decimalFormat.format(roundedValue, sValue, this.position);
                        sValue = this.best(str, value);
                    } else if (this.wholePart.length() > infoWidth) {
                        double roundedValue = this.round(value, 0);
                        this.decimalFormat.applyPattern(pattern);
                        this.decimalFormat.setDecimalSeparatorAlwaysShown(false);
                        this.decimalFormat.setDecimalFormatSymbols(this.formatter.getDecimalFormatSymbols());
                        sValue = this.best(this.decimalFormat.format(roundedValue, sValue, this.position), value);
                    } else if (this.wholePart.length() == infoWidth) {
                        double roundedValue = this.round(value, 0);
                        this.formatter.applyPattern(this.modifyPattern(this.info.getPattern(), 0));
                        this.formatter.setDecimalSeparatorAlwaysShown(false);
                        sValue = this.best(this.formatter.format(roundedValue, sValue, this.position), value);
                    } else {
                        int diff = infoWidth - minWidth;
                        if (diff >= 2) {
                            double roundedValue = this.round(value, diff - 1);
                            this.decimalFormat.applyPattern(this.modifyPattern(pattern.toString(), diff - 1));
                            this.decimalFormat.setDecimalSeparatorAlwaysShown(false);
                            this.decimalFormat.setDecimalFormatSymbols(this.formatter.getDecimalFormatSymbols());
                            sValue = this.best(this.decimalFormat.format(roundedValue, sValue, this.position), value);
                        } else {
                            double roundedValue = this.round(value, 0);
                            this.decimalFormat.applyPattern(pattern);
                            this.decimalFormat.setDecimalSeparatorAlwaysShown(false);
                            this.decimalFormat.setDecimalFormatSymbols(this.formatter.getDecimalFormatSymbols());
                            sValue = this.best(this.decimalFormat.format(roundedValue, sValue, this.position), value);
                        }
                    }
                }
            }
        }
        return sValue;
    }

    private StringBuffer best_exp(double value) {
        int e = 0;
        this.result.setLength(0);
        double nValue = this.round(Math.abs(value), 0);
        if (this.isPercent) {
            nValue *= 100.0;
        }
        while (nValue >= 10.0) {
            nValue /= 10.0;
            ++e;
        }
        this.result.append("E" + e);
        int diff = this.info.getWidth() - this.result.length();
        if (this.isNLMNY || this.isNLMNYI) {
            diff = value >= 0.0 ? diff - this.positivePrefix.length() - this.positiveSuffix.length() : diff - this.negativePrefix.length() - this.negativeSuffix.length();
        }
        this.result.setLength(0);
        String negaPre = null;
        String negaSuf = null;
        if (value < 0.0) {
            if (this.isNLPCTP || this.isPercent && !this.isNLFormat) {
                this.result.append('(');
                diff -= 2;
            } else if (this.baseFormat.startsWith("NLMNI") || this.baseFormat.startsWith("NLMNL")) {
                negaPre = this.removeCurrencySymbol(new StringBuffer(this.negativePrefix)).toString();
                negaSuf = this.removeCurrencySymbol(new StringBuffer(this.negativeSuffix)).toString();
                diff -= negaPre.length() + negaSuf.length();
            } else if (this.isNLMNY || this.isNLMNYI) {
                this.result.append(this.negativePrefix);
            } else {
                this.result.append('-');
                --diff;
            }
        } else if (this.isNLMNY || this.isNLMNYI) {
            this.result.append(this.positivePrefix);
        }
        if (this.isPercent) {
            --diff;
        }
        if (diff > 0) {
            int i;
            this.pattern.setLength(0);
            this.pattern.append("0.");
            for (i = 2; i < diff; ++i) {
                this.pattern.append('#');
            }
            if (diff <= 3) {
                i = 1;
                if (e == 10 && diff == 1) {
                    i = 0;
                }
                while (i < diff) {
                    nValue *= 10.0;
                    --e;
                    ++i;
                }
                if ((this.isPercent || this.isDFormat) && e == 10) {
                    nValue *= 10.0;
                    --e;
                }
                while ((int)nValue % 10 == 0) {
                    nValue /= 10.0;
                    ++e;
                }
                nValue = this.round(nValue, 0);
                this.decimalFormat.applyPattern("#");
            } else {
                nValue = this.round(nValue, diff - 2);
                this.decimalFormat.applyPattern(this.pattern.toString());
                this.decimalFormat.setDecimalSeparatorAlwaysShown(false);
            }
            while (nValue % 10.0 == 0.0) {
                nValue /= 10.0;
                ++e;
            }
            DecimalFormatSymbols dfs = this.formatter.getDecimalFormatSymbols();
            this.decimalFormat.setDecimalFormatSymbols(dfs);
            String fmt = this.decimalFormat.format(nValue, new StringBuffer(), this.position).toString();
            if (this.decimalFormat.getDecimalFormatSymbols().getDecimalSeparator() != '.') {
                fmt = fmt.replace(this.decimalFormat.getDecimalFormatSymbols().getDecimalSeparator(), '.');
            }
            double dtmp = 0.0;
            try {
                dtmp = this.decimalFormat.parse(fmt).doubleValue();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (this.isPercent && dtmp % 10.0 == 0.0) {
                while (dtmp % 10.0 == 0.0) {
                    ++e;
                    dtmp /= 10.0;
                }
                this.result.append(this.decimalFormat.format(dtmp, new StringBuffer(), this.position));
            } else {
                this.result.append(this.decimalFormat.format(nValue, new StringBuffer(), this.position));
            }
            this.result.append("E" + e);
            if (this.isNLMNY || this.isNLMNYI) {
                if (value > 0.0) {
                    this.result.append(this.positiveSuffix);
                } else {
                    this.result.append(this.negativeSuffix);
                }
            }
            if (this.isPercent) {
                this.result.append('%');
                if (value < 0.0 && (!this.isNLFormat || this.isNLPCTP)) {
                    this.result.append(')');
                }
            } else if (this.baseFormat.startsWith("NLMNI") || this.baseFormat.startsWith("NLMNL")) {
                if (value >= 0.0) {
                    int l = this.positivePrefix.length() + this.positiveSuffix.length();
                    if (this.result.length() + l <= this.info.getWidth()) {
                        this.result.insert(0, this.positivePrefix);
                        this.result.append(this.positiveSuffix);
                    }
                } else {
                    int l = this.negativePrefix.length() + this.negativeSuffix.length();
                    if (this.result.length() + l <= this.info.getWidth()) {
                        this.result.insert(0, this.negativePrefix);
                        this.result.append(this.negativeSuffix);
                    } else {
                        this.result.insert(0, negaPre);
                        this.result.append(negaSuf);
                    }
                }
            }
        } else {
            this.result = this.asteriskArray();
            if (this.isPercent && (!this.isNLFormat || this.isNLPCTX) && this.info.getWidth() >= 2) {
                int percentAt = 1;
                if (value < 0.0 && this.info.getWidth() >= 4 && !this.isNLPCTN) {
                    this.result.setCharAt(this.result.length() - 1, ')');
                    this.result.setCharAt(0, '(');
                    ++percentAt;
                }
                this.result.setCharAt(this.result.length() - percentAt, '%');
            }
        }
        return this.result;
    }

    @Override
    public double informat(String value) {
        char c;
        boolean negative = false;
        boolean applyPercent = false;
        boolean valid = false;
        this.decimalSeparator = this.formatter.getDecimalFormatSymbols().getDecimalSeparator();
        int decimalCount = 0;
        this.result.setLength(0);
        for (int index = 0; index < value.length(); ++index) {
            c = value.charAt(index);
            if (Character.isDigit(c)) {
                this.result.append(c);
                valid = true;
                continue;
            }
            if (c == '-' || c == '(') {
                negative = true;
                continue;
            }
            if (c == this.decimalSeparator) {
                if (index < value.length() - 1 && value.charAt(index + 1) == ' ') continue;
                this.result.append('.');
                ++decimalCount;
                continue;
            }
            if (c != this.percent) continue;
            applyPercent = true;
            this.isPercent = true;
        }
        if (decimalCount > 0) {
            String resultStr = this.result.toString();
            char ch = resultStr.charAt(resultStr.length() - 1);
            if (ch == '.') {
                resultStr = resultStr.substring(0, resultStr.length() - 1);
                --decimalCount;
            }
            this.result.setLength(0);
            int length = resultStr.length();
            for (int j = 0; j < length; ++j) {
                c = resultStr.charAt(j);
                if (c == '.' && decimalCount > 1) {
                    --decimalCount;
                    continue;
                }
                this.result.append(c);
            }
        }
        double rValue = 0.0;
        if (this.result.length() > 0 && valid) {
            rValue = Double.valueOf(this.result.toString());
            if (applyPercent && this.isPercent) {
                rValue /= 100.0;
            }
            if (negative) {
                rValue *= -1.0;
            }
        }
        return rValue;
    }

    static Object[] getDefinedFormats(Locale locale) {
        Vector<SingleEntry> temp = new Vector<SingleEntry>(20, 5);
        String className = Pattern.class.getName();
        SingleEntry entry = new SingleEntry("BESTw", className);
        ((SASFormatEntry)entry).addPattern(12, 32, "#0.##;-#0.##", true);
        ((SASFormatEntry)entry).addPattern(4, 11, "#0.##;-#0.##");
        ((SASFormatEntry)entry).addPattern(1, 3, "#.##;-#.##");
        entry.setFormatLocale(Locale.US);
        temp.addElement(entry);
        entry = new SingleEntry("Fw.d", className);
        ((SASFormatEntry)entry).addPattern(1, 32, "#0.##;-#0.##", true);
        entry.setFormatLocale(Locale.US);
        temp.addElement(entry);
        entry = new SingleEntry("COMMAw.d", className);
        ((SASFormatEntry)entry).addPattern(6, 32, "#,##0.##;-#,##0.##", true);
        ((SASFormatEntry)entry).addPattern(2, 5, "#,##0.##;-#,##0.##");
        entry.setFormatLocale(Locale.US);
        temp.addElement(entry);
        entry = new SingleEntry("COMMAXw.d", className);
        ((SASFormatEntry)entry).addPattern(6, 32, "#,##0.##;-#,##0.##", true);
        ((SASFormatEntry)entry).addPattern(2, 5, "#,##0.##;-#,##0.##");
        entry.setFormatLocale(Locale.GERMAN);
        temp.addElement(entry);
        entry = new SingleEntry("DOLLARw.d", className);
        ((SASFormatEntry)entry).addPattern(6, 32, "$#,##0.##;$-#,##0.##", true);
        ((SASFormatEntry)entry).addPattern(2, 5, "$#,##0.##;$-#,##0.##");
        entry.setFormatLocale(Locale.US);
        temp.addElement(entry);
        entry = new SingleEntry("NEGPARENw.d", className);
        ((SASFormatEntry)entry).addPattern(6, 32, "#,##0.##;(#,##0.##)", true);
        ((SASFormatEntry)entry).addPattern(1, 5, "#,##0.##;(#,##0.##)");
        entry.setFormatLocale(Locale.US);
        temp.addElement(entry);
        entry = new SingleEntry("PERCENTw.d", className);
        ((SASFormatEntry)entry).addPattern(6, 32, "#0.##%;(#0.##%)", true);
        ((SASFormatEntry)entry).addPattern(4, 5, "#0.##%;(#0.##%)");
        entry.setFormatLocale(Locale.US);
        temp.addElement(entry);
        entry = new SingleEntry("PERCENTNw.d", className);
        ((SASFormatEntry)entry).addPattern(6, 32, "#0.##%;(#0.##%)", true);
        ((SASFormatEntry)entry).addPattern(4, 5, "#0.##%;(#0.##%)");
        entry.setFormatLocale(Locale.US);
        temp.addElement(entry);
        entry = new SingleEntry("PVALUEw.d", className);
        ((SASFormatEntry)entry).addPattern(3, 32, "#0.0000000000000000;-#0.0000000000000000", true);
        entry.setFormatLocale(Locale.US);
        temp.addElement(entry);
        entry = new SingleEntry("LOGPROBw.d", className);
        ((SASFormatEntry)entry).addPattern(4, 32, ".##;-.##", true);
        entry.setFormatLocale(Locale.US);
        temp.addElement(entry);
        entry = new SingleEntry("NLMNYw.d", className);
        entry.setFormatLocale(locale);
        ((SASFormatEntry)entry).addResourceString(9, 32, "cr_l", true);
        ((SASFormatEntry)entry).addResourceString(1, 8, "cr_l");
        temp.addElement(entry);
        entry = new SingleEntry("NLMNYIw.d", className);
        entry.setFormatLocale(locale);
        ((SASFormatEntry)entry).addResourceString(9, 32, "cr_i", true);
        ((SASFormatEntry)entry).addResourceString(1, 8, "cr_i");
        temp.addElement(entry);
        entry = new SingleEntry("NLNUMw.d", className);
        entry.setFormatLocale(locale);
        ((SASFormatEntry)entry).addPattern(6, 32, "#,##0.###", true);
        ((SASFormatEntry)entry).addPattern(1, 5, "#,##0.###");
        temp.addElement(entry);
        entry = new SingleEntry("NLNUMIw.d", className);
        ((SASFormatEntry)entry).addPattern(6, 32, "#,##0.###", true);
        ((SASFormatEntry)entry).addPattern(1, 5, "#,##0.###");
        entry.setFormatLocale(Locale.US);
        temp.addElement(entry);
        entry = new SingleEntry("NLPCTw.d", className);
        entry.setFormatLocale(locale);
        ((SASFormatEntry)entry).addResourceString(6, 32, "pt_l", true);
        ((SASFormatEntry)entry).addResourceString(4, 5, "pt_l");
        temp.addElement(entry);
        entry = new SingleEntry("NLPCTPw.d", className);
        ((SASFormatEntry)entry).addPattern(6, 32, "#0.##%;(#0.##%)", true);
        ((SASFormatEntry)entry).addPattern(4, 5, "#0.##%;(#0.##%)");
        entry.setFormatLocale(locale);
        temp.addElement(entry);
        entry = new SingleEntry("NLPCTNw.d", className);
        ((SASFormatEntry)entry).addPattern(6, 32, "#0.##%;-#0.##%", true);
        ((SASFormatEntry)entry).addPattern(4, 5, "#0.##%;-#0.##%");
        entry.setFormatLocale(locale);
        temp.addElement(entry);
        entry = new SingleEntry("NLPCTIw.d", className);
        entry.setFormatLocale(Locale.US);
        ((SASFormatEntry)entry).addResourceString(6, 32, "pt_i", true);
        ((SASFormatEntry)entry).addResourceString(4, 5, "pt_i");
        temp.addElement(entry);
        entry = new SingleEntry("EUROw.d", className);
        ((SASFormatEntry)entry).addPattern(6, 32, "\u20ac#,##0.##;\u20ac-#,##0.##", true);
        ((SASFormatEntry)entry).addPattern(2, 5, "\u20ac#,##0.##;\u20ac-#,##0.##");
        ((SASFormatEntry)entry).addPattern(1, 1, "0");
        entry.setFormatLocale(Locale.US);
        temp.addElement(entry);
        entry = new SingleEntry("EUROXw.d", className);
        ((SASFormatEntry)entry).addPattern(6, 32, "\u20ac#,##0.##;\u20ac-#,##0.##", true);
        ((SASFormatEntry)entry).addPattern(2, 5, "\u20ac#,##0.##;\u20ac-#,##0.##");
        ((SASFormatEntry)entry).addPattern(1, 1, "0");
        entry.setFormatLocale(Locale.GERMAN);
        temp.addElement(entry);
        entry = new SingleEntry("YENw.d", className);
        ((SASFormatEntry)entry).addPattern(6, 32, "\uffe5#,##0.##;\uffe5-#,##0.##", true);
        ((SASFormatEntry)entry).addPattern(2, 5, "\uffe5#,##0.##;\uffe5-#,##0.##");
        entry.setFormatLocale(Locale.JAPANESE);
        temp.addElement(entry);
        entry = new SingleEntry("YENw.d", className);
        ((SASFormatEntry)entry).addPattern(6, 32, "\uffe5#,##0.##;\uffe5-#,##0.##", true);
        ((SASFormatEntry)entry).addPattern(2, 5, "\uffe5#,##0.##;\uffe5-#,##0.##");
        entry.setFormatLocale(Locale.JAPANESE);
        temp.addElement(entry);
        entry = new SingleEntry("RSTDONYNw.d", className);
        ((SASFormatEntry)entry).addPattern(6, 32, "###0.##;(###0.##)", true);
        ((SASFormatEntry)entry).addPattern(1, 5, "###0.##;(###0.##)");
        entry.setFormatLocale(Locale.US);
        temp.addElement(entry);
        entry = new SingleEntry("RSTDOPYNw.d", className);
        ((SASFormatEntry)entry).addPattern(6, 32, "#,##0.##;(#,##0.##)", true);
        ((SASFormatEntry)entry).addPattern(1, 5, "#,##0.##;(#,##0.##)");
        entry.setFormatLocale(Locale.GERMAN);
        temp.addElement(entry);
        entry = new SingleEntry("RSTDOCYYw.d", className);
        ((SASFormatEntry)entry).addPattern(6, 32, "#,##0.##%;(#,##0.##%)", true);
        ((SASFormatEntry)entry).addPattern(4, 5, "#,##0.##%;(#,##0.##%)");
        entry.setFormatLocale(Locale.US);
        temp.addElement(entry);
        entry = new SingleEntry("RSTDOPYYw.d", className);
        ((SASFormatEntry)entry).addPattern(6, 32, "#,##0.##%;(#,##0.##%)", true);
        ((SASFormatEntry)entry).addPattern(4, 5, "#,##0.##%;(#,##0.##%)");
        entry.setFormatLocale(Locale.GERMAN);
        temp.addElement(entry);
        entry = new SingleEntry("RSTDOCNYw.d", className);
        ((SASFormatEntry)entry).addPattern(6, 32, "#,##0.##%;(#,##0.##%)", true);
        ((SASFormatEntry)entry).addPattern(4, 5, "#,##0.##%;(#,##0.##%)");
        entry.setFormatLocale(Locale.US);
        temp.addElement(entry);
        entry = new SingleEntry("RSTDOPNYw.d", className);
        ((SASFormatEntry)entry).addPattern(6, 32, "#,##0.##%;(#,##0.##%)", true);
        ((SASFormatEntry)entry).addPattern(4, 5, "#,##0.##%;(#,##0.##%)");
        entry.setFormatLocale(Locale.GERMAN);
        temp.addElement(entry);
        entry = new SingleEntry("NLBESTw", className);
        entry.setFormatLocale(locale);
        ((SASFormatEntry)entry).addPattern(12, 32, "#0.##", true);
        ((SASFormatEntry)entry).addPattern(4, 11, "#0.##");
        ((SASFormatEntry)entry).addPattern(1, 3, "#.##");
        temp.addElement(entry);
        entry = new SingleEntry("NLPVALUEw.d", className);
        ((SASFormatEntry)entry).addPattern(6, 32, "#0.0000000000000000;-#0.0000000000000000", true);
        ((SASFormatEntry)entry).addPattern(3, 5, "#0.0000000000000000;-#0.0000000000000000", false);
        entry.setFormatLocale(locale);
        temp.addElement(entry);
        for (int i = 0; i < IntCurrencies.length; ++i) {
            entry = new SingleEntry("NLMNI" + IntCurrencies[i] + "w.d", className);
            entry.setFormatLocale(locale);
            ((SASFormatEntry)entry).setCurrencyPatterns(IntCurrencies[i], false);
            temp.addElement(entry);
            entry = new SingleEntry("NLMNL" + IntCurrencies[i] + "w.d", className);
            entry.setFormatLocale(locale);
            ((SASFormatEntry)entry).setCurrencyPatterns(IntCurrencies[i], true);
            temp.addElement(entry);
        }
        Object[] separators = SwapSeparators.getDefinedFormats();
        patternFormats = new Object[temp.size() + separators.length];
        temp.copyInto(patternFormats);
        System.arraycopy(separators, 0, patternFormats, temp.size(), separators.length);
        return patternFormats;
    }

    private StringBuffer moveMinussign(StringBuffer formatted) {
        int i;
        DecimalFormat dfer = (DecimalFormat)NumberFormat.getInstance(this.info.getFormatLocale());
        String negPre = dfer.getNegativePrefix();
        String negSuf = dfer.getNegativeSuffix();
        if (negPre.equals("") && negSuf.equals("-") && (i = formatted.indexOf("-")) >= 0) {
            formatted.deleteCharAt(i);
            formatted.append('-');
        }
        return formatted;
    }

    private StringBuffer removeCurrencySymbol(StringBuffer strValue) {
        SingleEntry entry = (SingleEntry)this.tableEntry;
        strValue = new StringBuffer(strValue.toString().replace(entry.getCurrecnySymbol(), ""));
        return strValue;
    }

    private String replaceE(String pattern) {
        if (this.isNLFormat && this.isStartWithNLMNY) {
            if (pattern.indexOf("0EUR") >= 0 || pattern.indexOf("#EUR") >= 0 || pattern.indexOf(".EUR") >= 0 || pattern.indexOf(",EUR") >= 0) {
                pattern = pattern.replace("EUR", "'EUR'");
            } else if (pattern.indexOf("0EGP") >= 0 || pattern.indexOf("#EGP") >= 0 || pattern.indexOf(".EGP") >= 0 || pattern.indexOf(",EGP") >= 0) {
                pattern = pattern.replace("EGP", "'EGP'");
            } else if (pattern.indexOf("0EEK") >= 0 || pattern.indexOf("#EEK") >= 0 || pattern.indexOf(".EEK") >= 0 || pattern.indexOf(",EEK") >= 0) {
                pattern = pattern.replace("EEK", "'EEK'");
            }
        }
        return pattern;
    }

    private DecimalFormatSymbols getSupportedDFS(Locale locale) {
        if (locale.getCountry().equalsIgnoreCase("BE") && locale.getLanguage().equalsIgnoreCase("en")) {
            return new DecimalFormatSymbols(new Locale("fr", "BE"));
        }
        return new DecimalFormatSymbols(locale);
    }

    private StringBuffer replaceCurrencySymbol(StringBuffer fmtValue) {
        if (this.infoHasSingleEntry) {
            String realSymbol;
            int start;
            SingleEntry se = (SingleEntry)this.tableEntry;
            if (se.m_isReplaced && (start = fmtValue.indexOf(realSymbol = this.formatter.getDecimalFormatSymbols().getCurrencySymbol())) > -1 && realSymbol.length() > 0) {
                fmtValue = fmtValue.replace(start, start + realSymbol.length(), se.getCurrecnySymbol());
            }
        }
        return fmtValue;
    }

    @Override
    protected boolean isDFormat() {
        return this.isDFormat;
    }

    @Override
    protected void setDFormat(boolean value) {
        this.isDFormat = value;
        this.factionalPatternChar = (char)48;
    }

    @Override
    public boolean isPercent() {
        return this.isRSTD || this.isNLPCTX || this.isPercentWithMinus;
    }

    private StringBuffer nlbestForSmallValues(StringBuffer best) {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(this.info.getFormatLocale());
        char dp = dfs.getDecimalSeparator();
        int idx_dp = best.indexOf(".");
        if (idx_dp > -1) {
            best = best.replace(idx_dp, idx_dp + 1, dp + "");
        }
        best = this.moveMinussign(best);
        return best;
    }

    private boolean isUseExponent(double value, int width, int dvalue) {
        int logBase2_int;
        int logBase10_int;
        return value != 0.0 && width - dvalue < 0 && (logBase10_int = (logBase2_int = (int)(Math.log(Math.abs(value)) / Math.log(2.0))) * 77 / 256) < -1;
    }

    private StringBuffer fmteForNLPCTX(double value, int width, int dvalue) {
        int idx_dp;
        StringBuffer fmtted = new StringBuffer();
        boolean useAsterisk = false;
        if (width < 7) {
            useAsterisk = true;
        } else {
            int widthOfMantissa;
            int r;
            double mantissa;
            double absoluteValue = Math.abs(value * 100.0);
            int PO10E = 14;
            int validWidth = width - 3;
            int validDValue = Math.min(dvalue, 13);
            StringBuffer str_mantissa = new StringBuffer(16);
            boolean nodec = false;
            String tmp = Double.toString(absoluteValue).toUpperCase();
            if (tmp.indexOf("E") > -1) {
                String[] ss = tmp.split("E");
                mantissa = Double.valueOf(ss[0]);
            } else {
                for (mantissa = absoluteValue; mantissa < 1.0; mantissa *= 10.0) {
                }
            }
            mantissa += 0.5 * Math.pow(10.0, -14.0);
            mantissa *= 0.1;
            int p = -((int)((77.0 * ((double)((int)(-Math.log(absoluteValue))) / Math.log(2.0)) + 255.0) / 256.0));
            if (absoluteValue * Math.pow(10.0, -p) >= 1.0) {
                ++p;
            }
            if ((r = (widthOfMantissa = validWidth - String.valueOf(--p).length() - 1) - 1) < 0) {
                useAsterisk = true;
            } else if (r < 3) {
                p -= r;
                nodec = true;
                if (++r + String.valueOf(p).length() + 1 > validWidth) {
                    --r;
                    ++p;
                }
                if (String.valueOf(p).length() > String.valueOf(p - 1).length()) {
                    ++r;
                    --p;
                }
                if (r > 0 && (mantissa += 0.5 * Math.pow(10.0, -r)) >= 1.0) {
                    mantissa *= 0.1;
                    if (String.valueOf(++p - 1).length() > String.valueOf(p).length()) {
                        ++r;
                        if (nodec) {
                            --p;
                        }
                    }
                }
                BigInteger LOW60 = new BigInteger(new byte[]{15, -1, -1, -1, -1, -1, -1, -1});
                int d = -1;
                int e = (int)(Double.doubleToRawLongBits(mantissa) >>> 52) - 1023 + 1;
                byte[] uint64 = new byte[8];
                for (int i = 0; i < uint64.length; ++i) {
                    uint64[i] = (byte)(Double.doubleToRawLongBits(mantissa) >>> 56 - i * 8);
                }
                BigInteger m = new BigInteger(uint64);
                m = m.and(new BigInteger(new byte[]{0, 15, -1, -1, -1, -1, -1, -1}));
                m = m.or(new BigInteger(new byte[]{0, 16, 0, 0, 0, 0, 0, 0}));
                m = m.shiftLeft(e + 7).and(LOW60);
                str_mantissa.setLength(0);
                for (int i = 0; i < r; ++i) {
                    m = m.multiply(BigInteger.TEN);
                    d = m.shiftRight(60).intValue();
                    str_mantissa = str_mantissa.append(d);
                    m = m.and(LOW60);
                }
            } else {
                if (r > 0 && (mantissa += 0.5 * Math.pow(10.0, -r)) >= 1.0) {
                    mantissa *= 0.1;
                    if (String.valueOf(++p - 1).length() > String.valueOf(p).length()) {
                        ++r;
                        if (nodec) {
                            --p;
                        }
                    }
                }
                String s = Double.valueOf(mantissa).toString();
                str_mantissa = r > str_mantissa.length() - 2 ? str_mantissa.append(s.substring(2)) : str_mantissa.append(s.substring(2, 2 + r));
                str_mantissa.insert(1, '.');
                int w = Math.min(str_mantissa.length(), Math.min(validDValue + 2, widthOfMantissa));
                str_mantissa.setLength(w);
            }
            if (!useAsterisk) {
                while (str_mantissa.charAt(str_mantissa.length() - 1) == '0') {
                    str_mantissa.setLength(str_mantissa.length() - 1);
                    if (!nodec) continue;
                    ++p;
                }
                if (str_mantissa.charAt(str_mantissa.length() - 1) == '.') {
                    str_mantissa.setLength(str_mantissa.length() - 1);
                }
                fmtted.append(str_mantissa);
                fmtted.append("E");
                fmtted.append(p);
            }
        }
        if (useAsterisk) {
            for (int i = 0; i < width - 3; ++i) {
                fmtted.append("*");
            }
        }
        fmtted.append("%");
        if (value < 0.0) {
            if (this.isNLPCTP) {
                fmtted.insert(0, "(");
                fmtted.append(")");
            } else if (this.isNLPCTN) {
                fmtted.insert(0, "-");
            }
        }
        if ((idx_dp = fmtted.indexOf(".")) > -1) {
            fmtted.setCharAt(idx_dp, this.formatter.getDecimalFormatSymbols().getDecimalSeparator());
        }
        return fmtted;
    }

    private class FormatZeroValues {
        private FormatZeroValues() {
        }

        public StringBuffer formatZeroValueForMNY(StringBuffer fmtValue) {
            if (fmtValue.length() > Pattern.this.info.getWidth()) {
                int wholeLen = fmtValue.length() - (Pattern.this.info.getDValue() == 0 ? 0 : Pattern.this.info.getDValue() + 1);
                if (wholeLen > Pattern.this.info.getWidth()) {
                    ((SingleEntry)((Pattern)Pattern.this).tableEntry).m_isReplaced = false;
                    return Pattern.this.asteriskArray();
                }
                String p = Pattern.this.info.getPattern();
                int scale = Pattern.this.info.getDValue() - (fmtValue.length() - Pattern.this.info.getWidth());
                StringBuffer sb = fmtValue;
                Pattern.this.formatter.applyPattern(Pattern.this.modifyPattern(p, scale <= 0 ? 0 : scale));
                Pattern.this.formatter.setDecimalSeparatorAlwaysShown(false);
                sb.setLength(0);
                Pattern.this.formatter.format(0L, sb, Pattern.this.position);
                return sb;
            }
            return fmtValue;
        }
    }

    private class BestFormatForSmallValues {
        private BestFormatForSmallValues() {
        }

        public String format(int width, double value) {
            boolean negativeValue = false;
            if (value < 0.0) {
                --width;
                value *= -1.0;
                negativeValue = true;
            } else if (value == 0.0) {
                return "0";
            }
            if (value >= 1.0) {
                return Double.toString(value);
            }
            if (width <= 1) {
                if ((value = Pattern.this.round(value, 0)) == 0.0) {
                    if (!negativeValue || width == 0) {
                        return "0";
                    }
                    if (negativeValue) {
                        return "-0";
                    }
                }
                if (negativeValue && width > 0) {
                    return "-" + Double.toString(value).substring(0, 1);
                }
                if (negativeValue) {
                    return "*";
                }
                if (!negativeValue) {
                    return Double.toString(value).substring(0, 1);
                }
            }
            double logBase10 = Math.log(value) / Math.log(10.0);
            int logBase10_int = (int)logBase10;
            int zeroCount = Math.abs(logBase10_int);
            String result = null;
            if (width > 3 && zeroCount >= width - 2 && zeroCount > 2) {
                result = this.formatScientificNotation(width, value, zeroCount);
            }
            if (result == null) {
                result = this.formattingType5Or6(width, value);
            }
            if (!result.equals("0") && result.indexOf("E") < 0) {
                result = this.removeTrailingZero(result);
            }
            if (result.length() <= width && result.indexOf(69) > -1) {
                BigDecimal bg = new BigDecimal(result);
                String strTemp = bg.toString();
                result = this.removeTrailingZero(result);
                if (Pattern.this.isDFormat && strTemp.length() < width) {
                    result = strTemp;
                } else if (strTemp.length() <= width) {
                    result = strTemp;
                } else if (strTemp.length() == width + 1 && strTemp.startsWith("0.")) {
                    result = strTemp.substring(1, strTemp.length());
                }
            }
            if (negativeValue) {
                double d = Double.parseDouble(result);
                result = d != 0.0 ? "-" + result : "-0";
            }
            if (result.length() < width) {
                int spaceCount = width - result.length();
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < spaceCount; ++i) {
                    sb.append(" ");
                }
                result = sb.toString() + result;
            }
            return result;
        }

        private String formattingType5Or6(int width, double value) {
            String type5;
            String valStr = Double.toString(value);
            String[] ss = valStr.split("E");
            if (ss[0].endsWith(".0")) {
                ss[0] = ss[0].substring(0, ss[0].length() - 2);
                valStr = ss[0] + 'E' + ss[1];
            }
            if (valStr.length() <= width) {
                return valStr;
            }
            String type6 = type5 = this.type5a(width, value);
            if (type5.startsWith("1") && type5.toUpperCase().indexOf("E") < 0) {
                type6 = "1";
            }
            if ((type6 = this.removeTrailingZero(type6)).startsWith("0.") && type6.length() > width) {
                type6 = type6.substring(1, type6.length());
            }
            if (type6.indexOf(69) >= 0 && (ss = type6.split("E"))[0].endsWith(".0")) {
                ss[0] = ss[0].substring(0, ss[0].length() - 2);
                type6 = ss[0] + 'E' + ss[1];
            }
            if (type6.length() > width) {
                return "0";
            }
            return type6;
        }

        private String type5a(int width, double value) {
            int decimalCount = this.getMantissaCount(value);
            BigDecimal bd = new BigDecimal(new Double(value).toString());
            BigDecimal bdtemp = null;
            double lastDecimalvalue = value;
            for (int i = decimalCount; i > 0; --i) {
                bdtemp = bd.setScale(i, 4);
                if (bdtemp.doubleValue() == 0.0) {
                    return Double.toString(lastDecimalvalue);
                }
                lastDecimalvalue = bdtemp.doubleValue();
                if (width <= 3 && bdtemp.toString().length() <= width + 1) {
                    String s = bdtemp.toString();
                    s = bdtemp.doubleValue() < 1.0 ? s.substring(1, s.length()) : (width == 3 ? s.substring(0, 3) : s.substring(0, 1));
                    return s;
                }
                if (this.removeTrailingZero(bdtemp.doubleValue() + "").length() > width) continue;
                return bdtemp.doubleValue() + "";
            }
            return lastDecimalvalue + "";
        }

        private String removeTrailingZero(String s) {
            if (s.indexOf(69) < 0 && s.indexOf(46) >= 0) {
                while (s.endsWith("0")) {
                    s = s.substring(0, s.length() - 1);
                }
            }
            return s;
        }

        private String formatScientificNotation(int width, double value, int zeroCount) {
            int decimalCount = this.getMantissaCount(value);
            String t2 = Double.toString(Pattern.this.round(value, decimalCount));
            if ((t2 = t2.toUpperCase()).indexOf(69) < 0) {
                return Double.toString(value);
            }
            String[] ss = t2.split("E");
            if (ss[0].endsWith(".0")) {
                ss[0] = ss[0].substring(0, ss[0].length() - 2);
                t2 = ss[0] + 'E' + ss[1];
            }
            if ((t2 = this.fitValueInWidth(t2, width, zeroCount)).length() <= width) {
                return t2;
            }
            String t3 = this.removePeriodFromScientificNotation(value);
            return this.clipExtraZeroInCoffecient(t3, width);
        }

        private String fitValueInWidth(String t2, int width, int zeroCount) {
            int MIN_WIDTH;
            if (t2.length() <= width) {
                return t2;
            }
            String[] ss1 = t2.split("\\.");
            if (ss1.length < 2) {
                return t2;
            }
            String[] ss2 = ss1[1].split("E");
            if (ss2.length < 2) {
                return t2;
            }
            int expLen = ss2[1].length() + 1;
            int remainingWidth = width - 2 - expLen;
            if (remainingWidth >= (MIN_WIDTH = 1) && ss2[0].length() > remainingWidth) {
                double d = Double.parseDouble(ss1[0] + "." + ss2[0]);
                d = Pattern.this.round(d, remainingWidth);
                if (Pattern.this.isDFormat()) {
                    if (width > 7) {
                        t2 = d + "E" + ss2[1];
                    }
                } else {
                    t2 = d + "E" + ss2[1];
                }
                if ((d + "").endsWith(".0")) {
                    t2 = this.clipExtraZeroInCoffecient(t2, width);
                }
            }
            return t2;
        }

        private String clipExtraZeroInCoffecient(String t3, int width) {
            t3 = t3.toUpperCase();
            String[] ss = t3.split("E");
            String coff = ss[0];
            String base = ss[1];
            int baseVal = Integer.parseInt(base);
            StringBuffer sb = new StringBuffer(coff);
            if (coff.endsWith(".0")) {
                coff = coff.substring(0, coff.length() - 2);
                t3 = coff + "E" + baseVal;
                return t3;
            }
            while (t3.length() > width && baseVal < 0) {
                coff = coff.substring(0, coff.length() - 1);
                t3 = coff + "E" + ++baseVal;
                if (coff.length() >= 1) continue;
                return "0";
            }
            int x = coff.length();
            String s = sb.insert(x, '.').toString();
            double d = Double.parseDouble(s);
            d = Pattern.this.round(d, 0);
            coff = (long)d + "";
            t3 = coff + "E" + baseVal;
            while (coff.endsWith("0")) {
                coff = coff.substring(0, coff.length() - 1);
                t3 = coff + "E" + ++baseVal;
                if (coff.length() >= 1) continue;
                return "0";
            }
            return t3;
        }

        private String removePeriodFromScientificNotation(double value) {
            int decimalCount = this.getMantissaCount(value);
            String type2 = Double.toString(Pattern.this.round(value, decimalCount));
            type2 = type2.toUpperCase();
            int indexPeriod = type2.indexOf(46);
            int indexE = type2.indexOf(69);
            int increamentEBy = indexE - 1 - indexPeriod;
            String[] ss = type2.split("-");
            int i = Integer.parseInt(ss[1]);
            type2 = ss[0] + "-" + (i += increamentEBy);
            int index = type2.indexOf(".");
            String s = new StringBuffer(type2).replace(index, index + 1, "").toString();
            return s;
        }

        private int getMantissaCount(double value) {
            double logBase10 = Math.log(value) / Math.log(10.0);
            int logBase10_int = (int)logBase10;
            int zeroCount = Math.abs(logBase10_int);
            BigDecimal operand1 = new BigDecimal(Math.pow(10.0, zeroCount + 1) + "");
            BigDecimal operand2 = new BigDecimal(value + "");
            double d = operand1.multiply(operand2).doubleValue();
            String number = Double.toString(d);
            int numberLen = number.length();
            if (number.indexOf(".") > -1) {
                --numberLen;
            }
            int decimalCount = zeroCount + numberLen;
            return decimalCount;
        }
    }
}

