/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.util;

import com.sas.codepolicy.SASScope;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

@SASScope
public class VerySimpleFormatter
extends Formatter {
    private boolean insertLineBreaks;
    private PrintWriter pw;
    private StringWriter sw = new StringWriter();
    private StringBuffer sb;

    public VerySimpleFormatter() {
        this(true);
    }

    public VerySimpleFormatter(boolean insertLineBreaks) {
        this.pw = new PrintWriter(this.sw);
        this.sb = this.sw.getBuffer();
        this.insertLineBreaks = insertLineBreaks;
    }

    @Override
    public String format(LogRecord logRecord) {
        String message = this.formatMessage(logRecord);
        Throwable thrown = logRecord.getThrown();
        if (thrown == null && !this.insertLineBreaks) {
            return message;
        }
        this.pw.print(message);
        if (thrown != null) {
            this.pw.println();
            thrown.printStackTrace(this.pw);
        }
        if (this.insertLineBreaks) {
            this.pw.println();
        }
        message = this.sw.toString();
        this.sb.setLength(0);
        return message;
    }
}

