/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.crypto;

import com.sas.codepolicy.SASScope;
import com.sas.net.crypto.CipherInterface;
import com.sas.net.crypto.CryptoException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
public abstract class Crypto {
    private static final Logger _logger = LogManager.getLogger(Crypto.class);
    private static final String _sasCryptoName = "com.sas.net.crypto.sas.SasCrypto";
    private static final String _rsaCryptoName = "com.sas.net.crypto.rsa.RsaCrypto";
    private static final String _jceCryptoName = "com.sas.net.crypto.jce.JceCrypto";
    private static final String _defaultProviders = "com.sas.net.crypto.sas.SasCrypto,com.sas.net.crypto.rsa.RsaCrypto,com.sas.net.crypto.jce.JceCrypto";
    private static final String _defaultProvidersJcePreferred = "com.sas.net.crypto.sas.SasCrypto,com.sas.net.crypto.jce.JceCrypto,com.sas.net.crypto.rsa.RsaCrypto";
    private String name = null;

    public abstract CipherInterface openCipher() throws CryptoException;

    public abstract String getSupportedNames();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.toUpperCase();
    }

    public static Crypto getCrypto(String algorithm, Properties properties) {
        if (algorithm == null) {
            return null;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("seeking provider for algortihm " + algorithm);
            _logger.debug("properties: " + properties);
        }
        String preferJceCryptoKey = "com.sas.net.crypto.preferJceCrypto";
        boolean preferJceCrypto = Boolean.getBoolean(preferJceCryptoKey);
        if (_logger.isDebugEnabled()) {
            _logger.debug(preferJceCryptoKey + " is " + preferJceCrypto);
        }
        String defaultProviders = preferJceCrypto ? _defaultProvidersJcePreferred : _defaultProviders;
        String providerList = properties.getProperty("encryptionProviders", defaultProviders);
        if (_logger.isDebugEnabled()) {
            _logger.debug("providers: " + providerList);
        }
        String providerName = null;
        int index = 0;
        Class[] argt = new Class[1];
        Object[] argv = new Object[1];
        do {
            if ((providerName = Crypto.getNameFromList(providerList, ',', index)) != null) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("trying provider " + providerName);
                }
                try {
                    Class<?> providerClass = Class.forName(providerName);
                    argt[0] = Properties.class;
                    Constructor<?> providerConstructor = providerClass.getConstructor(argt);
                    argv[0] = properties;
                    Crypto provider = (Crypto)providerConstructor.newInstance(argv);
                    String supportedNames = provider.getSupportedNames();
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("supported names: " + supportedNames);
                    }
                    String supportedName = null;
                    int j = 0;
                    do {
                        if ((supportedName = Crypto.getNameFromList(supportedNames, ',', j)) != null && algorithm.equalsIgnoreCase(supportedName)) {
                            if (_logger.isDebugEnabled()) {
                                _logger.debug("found provider for " + algorithm);
                            }
                            provider.setName(supportedName);
                            return provider;
                        }
                        ++j;
                    } while (supportedName != null);
                }
                catch (ClassNotFoundException e) {
                    if (!providerName.equals(_rsaCryptoName)) {
                        if (_logger.isDebugEnabled()) {
                            _logger.debug("com.sas.net.crypto.rsa.RsaCrypto not found in classpath");
                        }
                    } else {
                        _logger.warn(providerName + " not found in classpath");
                    }
                }
                catch (NoSuchMethodException e) {
                    _logger.warn(providerName + " is missing a required constructor");
                }
                catch (InstantiationException e) {
                    _logger.warn(providerName + " could not be instantiated");
                }
                catch (IllegalAccessException e) {
                    _logger.warn(providerName + " could not be accessed");
                }
                catch (InvocationTargetException e) {
                    _logger.warn(providerName + " constructor threw an exception", e.getCause());
                }
            }
            ++index;
        } while (providerName != null);
        return null;
    }

    private static String getNameFromList(String list, char delim, int index) {
        char c;
        if (list == null) {
            return null;
        }
        int offset = 0;
        int end = 0;
        int listLength = list.length();
        block0: for (int i = 0; i < index; ++i) {
            while (offset < listLength) {
                char c2 = list.charAt(offset);
                if (c2 == delim) {
                    ++offset;
                    continue block0;
                }
                ++offset;
            }
        }
        if (offset >= listLength) {
            return null;
        }
        for (end = offset; end < listLength && (c = list.charAt(end)) != delim; ++end) {
        }
        if (end - offset == 0) {
            return null;
        }
        return list.substring(offset, end);
    }
}

