/*
 * Decompiled with CFR 0.152.
 */
package com.sas.io;

import com.sas.io.EncoderInterface;

public class LookupEncoder
implements EncoderInterface {
    private String encoding;
    private char[] toUnicode;
    private char[] fromUnicode;
    private static final int CODE_TABLE_SIZE = 256;
    public static boolean DEBUG = false;
    private byte[] byteArray;

    public LookupEncoder(String name, char[] toUnicode, char[] fromUnicode) {
        this.encoding = name;
        this.setUnicodeArrays(fromUnicode, toUnicode);
    }

    protected void setToUnicodeArray(char[] toUnicode) {
        this.toUnicode = toUnicode;
        if (this.fromUnicode == null) {
            this.fromUnicode = this.invert(toUnicode);
        }
    }

    protected void setFromUnicodeArray(char[] fromUnicode) {
        this.fromUnicode = fromUnicode;
        this.toUnicode = this.invert(fromUnicode);
    }

    private char[] invert(char[] chars) {
        int i;
        int max = 0;
        for (int i2 = 0; i2 < chars.length; ++i2) {
            int c = chars[i2] & 0xFF;
            max = Math.max(max, c);
        }
        char[] inverse = new char[max + 1];
        for (i = max - 1; i >= 0; --i) {
            inverse[i] = (char)i;
        }
        for (i = 0; i < max; ++i) {
            int c = chars[i] & 0xFF;
            inverse[c] = (char)i;
        }
        return inverse;
    }

    protected void setUnicodeArrays(char[] fromUnicode, char[] toUnicode) {
        if (fromUnicode == null && toUnicode == null) {
            throw new IllegalArgumentException();
        }
        if (fromUnicode == null) {
            this.setToUnicodeArray(toUnicode);
        } else if (toUnicode == null) {
            this.setFromUnicodeArray(fromUnicode);
        } else {
            this.fromUnicode = fromUnicode;
            this.toUnicode = toUnicode;
        }
    }

    @Override
    public String toString(byte[] bytes, int offset, int length) {
        return new String(this.toCharArray(bytes, offset, length));
    }

    @Override
    public char[] toCharArray(byte[] bytes, int offset, int length) {
        char[] chars = new char[length];
        int here = 0;
        int end = offset + length;
        for (int there = offset; there < end; ++there) {
            chars[here] = this.toChar(bytes[there]);
            ++here;
        }
        return chars;
    }

    public char toChar(byte b) {
        int index = b & 0xFF;
        char c = index <= this.toUnicode.length ? this.toUnicode[index] : (char)index;
        if (DEBUG) {
            System.out.println(this.getClass().getName() + "_DEBUG_: byte " + Integer.toHexString(b & 0xFF) + " ==> char " + Integer.toHexString(c & 0xFF) + " == '" + c + "'");
        }
        return c;
    }

    public byte toByte(char c) {
        int index = c & 0xFF;
        byte b = index <= this.fromUnicode.length ? (byte)this.fromUnicode[index] : (byte)index;
        if (DEBUG) {
            System.out.println(this.getClass().getName() + "_DEBUG_: char " + Integer.toHexString(c & 0xFF) + " == '" + c + "' ==> byte " + Integer.toHexString(b & 0xFF));
        }
        return b;
    }

    @Override
    public final byte[] toByteArray(String string, int offset, int length) {
        return this.toByteArray(string.substring(0, length).toCharArray(), 0, length);
    }

    @Override
    public byte[] toByteArray(char[] chars, int offset, int length) {
        byte[] bytes = new byte[length];
        int here = 0;
        int end = offset + length;
        for (int there = offset; there < end; ++there) {
            bytes[here] = this.toByte(chars[there]);
            ++here;
        }
        return bytes;
    }

    @Override
    public byte[] getByteArray(int nBytes) {
        if (this.byteArray == null || this.byteArray.length <= nBytes) {
            this.byteArray = new byte[nBytes];
        }
        return this.byteArray;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    public String toString() {
        return "(" + this.getEncoding() + ")";
    }

    public boolean equals(LookupEncoder other) {
        if (other == null) {
            return false;
        }
        if (this.getEncoding() == other.getEncoding() || this.getEncoding() != null && this.getEncoding().equals(other.getEncoding())) {
            char[] otherTo = other.toUnicode;
            char[] otherFrom = other.fromUnicode;
            return LookupEncoder.arrayEqual(otherTo, this.toUnicode) && LookupEncoder.arrayEqual(otherFrom, this.fromUnicode);
        }
        return false;
    }

    private static boolean arrayEqual(char[] charArrayA, char[] charArrayB) {
        if (charArrayA.length != charArrayB.length) {
            return false;
        }
        for (int i = charArrayA.length - 1; i >= 0; --i) {
            if (charArrayA[i] == charArrayB[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof LookupEncoder) {
            return this.equals((LookupEncoder)object);
        }
        return false;
    }

    public int hashCode() {
        return this.getEncoding() != null ? this.getEncoding().hashCode() : 1963;
    }

    public Object clone() throws CloneNotSupportedException {
        LookupEncoder clone = (LookupEncoder)super.clone();
        return clone;
    }
}

