/*
 * Decompiled with CFR 0.152.
 */
package com.sas.datatypes;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.codepolicy.SASScope;
import com.sas.datatypes.BaseDateType;
import com.sas.datatypes.DataTypeUtil;
import com.sas.datatypes.RB;
import com.sas.text.NLFormats;
import com.sas.util.CalendarUtil;
import com.sas.util.DatePeriod;
import com.sas.util.DateTypes;
import com.sas.util.Util;
import com.sas.util.ValueItem;
import com.sas.util.macrovar.MacroVariableOptionInterface;
import com.sas.util.transforms.StringToMissingValuesTransform;
import java.sql.Time;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

@SASScope
public class WeekType
extends BaseDateType {
    public static final String RB_KEY = "WeekType.";
    public static final WeekType DEFAULT_INSTANCE = new WeekType();
    public static final WeekType DEFAULT_LOCAL_INSTANCE = new WeekType(TimeZone.getDefault());

    public WeekType() {
    }

    public WeekType(TimeZone timeZone) {
        super(timeZone);
    }

    @Override
    public Object coerceValue(Object inputValue, Locale inputLocale) throws IllegalArgumentException {
        if (inputValue instanceof List && ((List)inputValue).size() == 1) {
            inputValue = ((List)inputValue).get(0);
        }
        if (inputValue instanceof DatePeriod) {
            DatePeriod dp = (DatePeriod)inputValue;
            if (dp.getPeriodType() == DateTypes.WEEK && Util.equal(dp.getTimeZone(), this.getTimeZone())) {
                return dp;
            }
            return this.coerceValue(dp.toString(null, inputLocale), inputLocale);
        }
        if (inputValue instanceof Calendar) {
            DatePeriod datePeriod = new DatePeriod(((Calendar)inputValue).getTime(), DateTypes.WEEK, this.getTimeZone(), inputLocale);
            return datePeriod;
        }
        if (inputValue instanceof Date) {
            if (!(inputValue instanceof Time)) {
                DatePeriod datePeriod = new DatePeriod((Date)inputValue, DateTypes.WEEK, this.getTimeZone(), inputLocale);
                return datePeriod;
            }
        } else {
            if (inputValue instanceof ValueItem) {
                return this.coerceValue(((ValueItem)inputValue).getValue(), inputLocale);
            }
            if (inputValue instanceof String[] && ((String[])inputValue).length == 1) {
                return this.coerceValue(((String[])inputValue)[0], inputLocale);
            }
            if (inputValue instanceof String) {
                String value = (String)inputValue;
                if (value.trim().length() == 0) {
                    return null;
                }
                MissingValues missingValue = MissingValues.getNumericMissingValues((String)inputValue);
                if (missingValue != null) {
                    return missingValue;
                }
                SpecialValues specialValue = SpecialValues.valueOf((String)inputValue);
                if (specialValue != null) {
                    return specialValue;
                }
                try {
                    DateTypes[] dateTypes = new DateTypes[]{DateTypes.WEEK};
                    DatePeriod dp = DatePeriod.parseDatePeriod(value, dateTypes, this.getTimeZone(), inputLocale);
                    if (dp != null) {
                        return dp;
                    }
                }
                catch (ParseException dateTypes) {
                    // empty catch block
                }
                Object transformObj = StringToMissingValuesTransform.defaultInstance.transform(value);
                if (transformObj.equals(MissingValues.Dot)) {
                    return MissingValues.Dot;
                }
            } else {
                if (inputValue instanceof MissingValues) {
                    return inputValue;
                }
                if (inputValue instanceof SpecialValues) {
                    return inputValue;
                }
                if (inputValue == null) {
                    return null;
                }
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(RB.getStringResource("WeekType.unableToConvert.fmt", inputLocale), this.formatValueForException(inputValue, inputLocale)));
    }

    @Override
    public Object coerceValueFromPersistedString(String input) {
        Object out = null;
        try {
            out = new DatePeriod(CalendarUtil.parseDateString(input, "'W'ww',' yyyy", this.timeZone, true), DateTypes.WEEK, this.timeZone, Locale.US);
        }
        catch (ParseException e) {
            out = this.coerceValue(input, Locale.US);
        }
        return out;
    }

    @Override
    public String getPersistanceString(Object value) throws IllegalArgumentException {
        if (value instanceof DatePeriod) {
            SimpleDateFormat sdf = new SimpleDateFormat("'W'ww',' yyyy", Locale.US);
            sdf.setLenient(false);
            this.setCalendarAndTimeZone(sdf);
            if (!((DatePeriod)value).isRelativeDate()) {
                Calendar cal = sdf.getCalendar();
                cal.setTime(((DatePeriod)value).getStartOfPeriod());
                int year = DatePeriod.getISOYear(cal);
                sdf.applyPattern("'W'ww',' " + year);
            }
            return ((DatePeriod)value).toString(sdf, Locale.US);
        }
        return this.getValueAsString(value, Locale.US);
    }

    @Override
    public DateFormat getDateFormatter(Object value, Locale locale) {
        String formatString = "";
        if (value instanceof Date) {
            Calendar cal = DataTypeUtil.getCalendar(this.getTimeZone(), locale);
            formatString = WeekType.getWeekFormatString((Date)value, locale, cal);
        } else {
            formatString = NLFormats.getPattern(this.getDefaultFormatName(), locale);
            formatString = formatString.replaceAll("'", "'");
        }
        SimpleDateFormat sdf = new SimpleDateFormat(formatString, locale);
        sdf.setLenient(false);
        return sdf;
    }

    public static String getWeekFormatString(Date value, Locale locale, Calendar cal) {
        cal.setTime(value);
        int weekNum = cal.get(3);
        String weekString = String.valueOf(weekNum);
        if (weekNum < 10) {
            weekString = "0" + weekString;
        }
        String formatString = NLFormats.getPattern(DEFAULT_INSTANCE.getDefaultFormatName(), locale);
        formatString = formatString.replaceAll("\\bw\\b", weekString);
        formatString = formatString.replaceAll("\\byy{2,4}\\b", String.valueOf(DatePeriod.getISOYear(cal)));
        return formatString;
    }

    @Override
    public DateTypes getDateType() {
        return DateTypes.WEEK;
    }

    @Override
    public Map getMacroVariableValues(MacroVariableOptionInterface macroInfoSource, Object value, Locale locale) {
        return this.getMacroVariableValuesForDatePeriod(DateTypes.WEEK, macroInfoSource, value, locale);
    }

    @Override
    public Object copyValue(Object value, Locale inputLocale) throws IllegalArgumentException {
        return this.coerceValue(value, inputLocale);
    }

    @Override
    public String getDefaultFormatName() {
        return "NLDATEYW";
    }
}

