/*
 * Decompiled with CFR 0.152.
 */
package com.sas.datatypes;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.codepolicy.SASScope;
import com.sas.datatypes.BaseDateType;
import com.sas.datatypes.RB;
import com.sas.text.NLFormats;
import com.sas.util.CalendarUtil;
import com.sas.util.DatePeriod;
import com.sas.util.DateTypes;
import com.sas.util.Util;
import com.sas.util.ValueItem;
import com.sas.util.macrovar.MacroVariableOptionInterface;
import com.sas.util.transforms.StringToMissingValuesTransform;
import java.sql.Time;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

@SASScope
public class MonthType
extends BaseDateType {
    public static final String RB_KEY = "MonthType.";
    public static final MonthType DEFAULT_INSTANCE = new MonthType();
    public static final MonthType DEFAULT_LOCAL_INSTANCE = new MonthType(TimeZone.getDefault());

    public MonthType() {
    }

    public MonthType(TimeZone timeZone) {
        super(timeZone);
    }

    @Override
    public Object coerceValue(Object inputValue, Locale inputLocale) throws IllegalArgumentException {
        if (inputValue instanceof List && ((List)inputValue).size() == 1) {
            inputValue = ((List)inputValue).get(0);
        }
        if (inputValue instanceof DatePeriod) {
            DatePeriod dp = (DatePeriod)inputValue;
            if (dp.getPeriodType() == DateTypes.MONTH && Util.equal(dp.getTimeZone(), this.getTimeZone())) {
                return dp;
            }
            return this.coerceValue(dp.toString(null, inputLocale), inputLocale);
        }
        if (inputValue instanceof Calendar) {
            DatePeriod datePeriod = new DatePeriod(((Calendar)inputValue).getTime(), DateTypes.MONTH, this.getTimeZone(), inputLocale);
            return datePeriod;
        }
        if (inputValue instanceof Date) {
            if (!(inputValue instanceof Time)) {
                DatePeriod datePeriod = new DatePeriod((Date)inputValue, DateTypes.MONTH, this.getTimeZone(), inputLocale);
                return datePeriod;
            }
        } else {
            if (inputValue instanceof ValueItem) {
                return this.coerceValue(((ValueItem)inputValue).getValue(), inputLocale);
            }
            if (inputValue instanceof String[] && ((String[])inputValue).length == 1) {
                return this.coerceValue(((String[])inputValue)[0], inputLocale);
            }
            if (inputValue instanceof String) {
                String value = (String)inputValue;
                if (value.trim().length() == 0) {
                    return null;
                }
                MissingValues missingValue = MissingValues.getNumericMissingValues((String)inputValue);
                if (missingValue != null) {
                    return missingValue;
                }
                SpecialValues specialValue = SpecialValues.valueOf((String)inputValue);
                if (specialValue != null) {
                    return specialValue;
                }
                try {
                    DateTypes[] dateTypes = new DateTypes[]{DateTypes.MONTH};
                    DatePeriod dp = DatePeriod.parseDatePeriod(value, dateTypes, this.getTimeZone(), inputLocale);
                    if (dp != null) {
                        return dp;
                    }
                }
                catch (ParseException dateTypes) {
                    // empty catch block
                }
                Object transformObj = StringToMissingValuesTransform.defaultInstance.transform(value);
                if (transformObj.equals(MissingValues.Dot)) {
                    return MissingValues.Dot;
                }
            } else {
                if (inputValue instanceof MissingValues) {
                    return inputValue;
                }
                if (inputValue instanceof SpecialValues) {
                    return inputValue;
                }
                if (inputValue == null) {
                    return null;
                }
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(RB.getStringResource("MonthType.unableToConvert.fmt", inputLocale), this.formatValueForException(inputValue, inputLocale)));
    }

    @Override
    public Object coerceValueFromPersistedString(String input) {
        Object out = null;
        try {
            out = new DatePeriod(CalendarUtil.parseDateString(input, "MMM yyyy", this.timeZone), DateTypes.MONTH, this.timeZone, Locale.US);
        }
        catch (ParseException e) {
            out = this.coerceValue(input, Locale.US);
        }
        return out;
    }

    @Override
    public String getPersistanceString(Object value) throws IllegalArgumentException {
        if (value instanceof DatePeriod) {
            SimpleDateFormat sdf = new SimpleDateFormat("MMM yyyy", Locale.US);
            sdf.setLenient(false);
            this.setCalendarAndTimeZone(sdf);
            return ((DatePeriod)value).toString(sdf, Locale.US);
        }
        return this.getValueAsString(value, Locale.US);
    }

    @Override
    public DateFormat getDateFormatter(Object value, Locale locale) {
        SimpleDateFormat sdf = new SimpleDateFormat(NLFormats.getPattern(this.getDefaultFormatName(), locale), locale);
        sdf.setLenient(false);
        return sdf;
    }

    @Override
    public DateTypes getDateType() {
        return DateTypes.MONTH;
    }

    @Override
    public Map getMacroVariableValues(MacroVariableOptionInterface macroInfoSource, Object value, Locale locale) {
        return this.getMacroVariableValuesForDatePeriod(DateTypes.MONTH, macroInfoSource, value, locale);
    }

    @Override
    public Object copyValue(Object value, Locale inputLocale) throws IllegalArgumentException {
        Object out = this.coerceValue(value, inputLocale);
        if (null != out && out == value && out instanceof DatePeriod) {
            out = ((DatePeriod)out).clone();
        }
        return out;
    }

    @Override
    public String getDefaultFormatName() {
        return "NLDATEYM";
    }
}

