/*
 * Decompiled with CFR 0.152.
 */
package com.sas.datatypes;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.codepolicy.SASScope;
import com.sas.datatypes.BaseDataType;
import com.sas.datatypes.RB;
import com.sas.util.Strings;
import com.sas.util.ValueItem;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.List;
import java.util.Locale;

@SASScope
public class IntegerType
extends BaseDataType {
    public static final IntegerType DEFAULT_INSTANCE = new IntegerType();

    @Override
    public Object coerceValue(Object inputValue, Locale inputLocale) throws IllegalArgumentException {
        if (inputValue instanceof List && ((List)inputValue).size() == 1) {
            inputValue = ((List)inputValue).get(0);
        }
        if (inputValue instanceof Integer) {
            return inputValue;
        }
        if (inputValue instanceof Number) {
            if (IntegerType.isInteger((Number)inputValue)) {
                return new Integer(((Number)inputValue).intValue());
            }
        } else {
            if (inputValue instanceof ValueItem) {
                return this.coerceValue(((ValueItem)inputValue).getValue(), inputLocale);
            }
            if (inputValue instanceof String) {
                if (((String)inputValue).trim().length() == 0) {
                    return null;
                }
                MissingValues missingValue = MissingValues.getNumericMissingValues((String)inputValue);
                if (missingValue != null) {
                    return missingValue;
                }
                SpecialValues specialValue = SpecialValues.valueOf((String)inputValue);
                if (specialValue != null) {
                    return specialValue;
                }
                try {
                    NumberFormat formatter = NumberFormat.getNumberInstance(inputLocale);
                    ParsePosition position = new ParsePosition(0);
                    String parsedString = ((String)inputValue).trim();
                    parsedString = Strings.replace(parsedString, 0, -1, "E+", "E");
                    parsedString = Strings.replace(parsedString, 0, -1, "e+", "e");
                    parsedString = BaseDataType.replaceBreakingSpace(formatter, parsedString);
                    Number number = formatter.parse(parsedString, position);
                    if (number != null && IntegerType.isInteger(number) && position.getErrorIndex() == -1 && position.getIndex() == parsedString.length()) {
                        boolean valid = true;
                        if (formatter instanceof DecimalFormat) {
                            valid = IntegerType.isGroupingValid((DecimalFormat)formatter, parsedString);
                        }
                        if (valid) {
                            return new Integer(number.intValue());
                        }
                    } else if (number != null && !IntegerType.isInteger(number)) {
                        throw new IllegalArgumentException(MessageFormat.format(RB.getStringResource("IntegerType.outsideValidRange.fmt", inputLocale), this.formatValueForException(inputValue, inputLocale)));
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                if (inputValue instanceof String[] && ((String[])inputValue).length == 1) {
                    return this.coerceValue(((String[])inputValue)[0], inputLocale);
                }
                if (inputValue instanceof Boolean) {
                    return (Boolean)inputValue != false ? 1 : 0;
                }
                if (inputValue instanceof MissingValues) {
                    return inputValue;
                }
                if (inputValue instanceof SpecialValues) {
                    return inputValue;
                }
                if (inputValue == null) {
                    return null;
                }
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(RB.getStringResource("IntegerType.unableToConvert.fmt", inputLocale), this.formatValueForException(inputValue, inputLocale)));
    }

    @Override
    public String getValueAsString(Object value, Locale outputLocale) {
        if (value == null) {
            return null;
        }
        if (value instanceof String && ((String)value).trim().length() == 0) {
            return null;
        }
        if (value instanceof MissingValues) {
            return MissingValues.toQueryString((MissingValues)value);
        }
        if (value instanceof SpecialValues) {
            return this.getSpecialValuesAsString((SpecialValues)value, outputLocale);
        }
        return value.toString();
    }

    @Override
    public Object coerceValueFromPersistedString(String input) {
        return this.coerceValue(input, Locale.US);
    }

    @Override
    public String getPersistanceString(Object value) throws IllegalArgumentException {
        return this.getValueAsString(value, Locale.US);
    }

    public static boolean isInteger(Number value) {
        int intValue;
        double doubleValue = value.doubleValue();
        return doubleValue == (double)(intValue = value.intValue());
    }

    @Override
    public int getSQLType() {
        return 4;
    }

    @Override
    public Object copyValue(Object value, Locale inputLocale) throws IllegalArgumentException {
        return this.coerceValue(value, inputLocale);
    }
}

